/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.basic.requirement.helpers;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.polarsys.capella.basic.requirement.Requirement;
import org.polarsys.capella.basic.requirement.RequirementFactory;
import org.polarsys.capella.basic.requirement.RequirementsPkg;
import org.polarsys.capella.basic.requirement.RequirementsTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.kitalpha.emde.model.ElementExtension;

public class RequirementModelHelper {
    private static String REQUIREMENTSPKG_DEFAULT_NAME = "Requirements";

    public static Structure getRequirementsPkg(BlockArchitecture architecture, boolean create) {
        Set<RequirementsPkg> requirementPkgs = RequirementModelHelper.getRequirementsPkgs(architecture);
        if (requirementPkgs.isEmpty() && create) {
            if (create) {
                RequirementsPkg pkg = RequirementFactory.eINSTANCE.createRequirementsPkg();
                pkg.setName(REQUIREMENTSPKG_DEFAULT_NAME);
                architecture.getOwnedExtensions().add((Object)pkg);
            } else {
                return null;
            }
        }
        if (requirementPkgs.iterator().hasNext()) {
            return requirementPkgs.iterator().next();
        }
        return null;
    }

    public static Structure getRequirementsPkg(BlockArchitecture architecture) {
        return RequirementModelHelper.getRequirementsPkg(architecture, true);
    }

    public static Set<RequirementsPkg> getRequirementsPkgs(BlockArchitecture architecture) {
        LinkedHashSet<RequirementsPkg> requirementPkgs = new LinkedHashSet<RequirementsPkg>();
        for (ElementExtension extension : architecture.getOwnedExtensions()) {
            if (!(extension instanceof RequirementsPkg)) continue;
            requirementPkgs.add((RequirementsPkg)extension);
        }
        return requirementPkgs;
    }

    public static List<Requirement> getAppliedRequirements(CapellaElement element) {
        ArrayList<Requirement> currentElements = new ArrayList<Requirement>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            TraceableElement target;
            if (!(trace instanceof RequirementsTrace) || !((target = trace.getTargetElement()) instanceof Requirement)) continue;
            currentElements.add((Requirement)target);
        }
        return currentElements;
    }

    public static List<CapellaElement> getRelatedCapellaElements(Requirement element) {
        ArrayList<CapellaElement> currentElements = new ArrayList<CapellaElement>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            TraceableElement source;
            if (!(trace instanceof RequirementsTrace) || !((source = trace.getSourceElement()) instanceof CapellaElement)) continue;
            currentElements.add((CapellaElement)source);
        }
        return currentElements;
    }
}

