/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.FindOccurrencesEngine;
import org.eclipse.wst.jsdt.internal.ui.search.OccurrencesFinder;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class FindOccurrencesInFileAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;
    private IActionBars fActionBars;

    public FindOccurrencesInFileAction(IViewPart part) {
        this((IWorkbenchSite)part.getSite());
    }

    public FindOccurrencesInFileAction(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public FindOccurrencesInFileAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(FindOccurrencesInFileAction.getEditorInput(editor) != null);
    }

    public FindOccurrencesInFileAction(IWorkbenchSite site) {
        super(site);
        if (site instanceof IViewSite) {
            this.fActionBars = ((IViewSite)site).getActionBars();
        } else if (site instanceof IEditorSite) {
            this.fActionBars = ((IEditorSite)site).getActionBars();
        } else if (site instanceof IPageSite) {
            this.fActionBars = ((IPageSite)site).getActionBars();
        }
        this.setText(SearchMessages.Search_FindOccurrencesInFile_label);
        this.setToolTipText(SearchMessages.Search_FindOccurrencesInFile_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.find_occurrences_in_file_action");
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.getMember(selection) != null);
    }

    private IMember getMember(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object o = selection.getFirstElement();
        if (o instanceof IMember) {
            IMember member = (IMember)o;
            try {
                if (member.getNameRange() == null) {
                    return null;
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return null;
            }
            IClassFile file = member.getClassFile();
            if (file != null) {
                try {
                    if (file.getSourceRange() != null) {
                        return member;
                    }
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    return null;
                }
            }
            return member;
        }
        return null;
    }

    @Override
    public void run(IStructuredSelection selection) {
        IMember member = this.getMember(selection);
        if (!ActionUtil.isProcessable(this.getShell(), (IJavaScriptElement)member)) {
            return;
        }
        FindOccurrencesEngine engine = FindOccurrencesEngine.create((IJavaScriptElement)member, new OccurrencesFinder());
        try {
            ISourceRange range = member.getNameRange();
            String result = engine.run(range.getOffset(), range.getLength());
            if (result != null) {
                FindOccurrencesInFileAction.showMessage(this.getShell(), this.fActionBars, result);
            }
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
        }
    }

    private static void showMessage(Shell shell, IActionBars actionBars, String msg) {
        IStatusLineManager statusLine;
        if (actionBars != null && (statusLine = actionBars.getStatusLineManager()) != null) {
            statusLine.setMessage(msg);
        }
        shell.getDisplay().beep();
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }

    @Override
    public final void run(ITextSelection ts) {
        IJavaScriptElement input = FindOccurrencesInFileAction.getEditorInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), input)) {
            return;
        }
        FindOccurrencesEngine engine = FindOccurrencesEngine.create(input, new OccurrencesFinder());
        try {
            String result = engine.run(ts.getOffset(), ts.getLength());
            if (result != null) {
                FindOccurrencesInFileAction.showMessage(this.getShell(), this.fEditor, result);
            }
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
        }
    }

    private static IJavaScriptElement getEditorInput(JavaEditor editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)input).getClassFile();
        }
        return JavaScriptPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(input);
    }

    private static void showMessage(Shell shell, JavaEditor editor, String msg) {
        IEditorStatusLine statusLine = (IEditorStatusLine)editor.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(true, msg, null);
        }
        shell.getDisplay().beep();
    }
}

