/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.api.tools.internal.model.ApiModelFactory;
import org.eclipse.pde.api.tools.internal.model.SystemLibraryApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.ui.internal.ApiToolsLabelProvider;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.wizards.ApiBaselineWizardPage;
import org.eclipse.pde.api.tools.ui.internal.wizards.WizardMessages;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.ExternalFileTargetHandle;
import org.eclipse.pde.internal.core.target.WorkspaceFileTargetHandle;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class TargetBasedApiBaselineWizardPage
extends ApiBaselineWizardPage {
    private List<ITargetDefinition> fTargets = new ArrayList<ITargetDefinition>();
    private ITargetDefinition selectedTargetDefinition;
    private Text nametext = null;
    private CheckboxTableViewer targetsViewer;
    private TreeViewer treeviewer = null;
    private Button reloadbutton = null;

    public static boolean isApplicable(IApiBaseline profile) {
        return ApiModelFactory.isDerivedFromTarget((IApiBaseline)profile);
    }

    public TargetBasedApiBaselineWizardPage(IApiBaseline profile) {
        super(profile);
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 4, 1, 768);
        SWTFactory.createWrapLabel(comp, WizardMessages.ApiProfileWizardPage_5, 1);
        this.nametext = SWTFactory.createText(comp, 2052, 3, 769);
        this.nametext.addModifyListener(e -> this.setPageComplete(this.pageValid()));
        SWTFactory.createVerticalSpacer(comp, 1);
        this.targetsViewer = CheckboxTableViewer.newCheckList((Composite)comp, (int)2050);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, true).applyTo(this.targetsViewer.getControl());
        this.targetsViewer.setLabelProvider((IBaseLabelProvider)new TargetLabelProvider());
        this.targetsViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.targetsViewer.addCheckStateListener(event -> {
            if (event.getChecked()) {
                this.targetsViewer.setCheckedElements(new Object[]{event.getElement()});
                this.selectedTargetDefinition = (ITargetDefinition)event.getElement();
            } else {
                this.selectedTargetDefinition = null;
            }
            this.updateButtons();
            this.setPageComplete(this.pageValid());
        });
        ITargetPlatformService service = this.getTargetService();
        if (service != null) {
            ITargetHandle[] iTargetHandleArray = service.getTargets(null);
            int n = iTargetHandleArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetHandle handle = iTargetHandleArray[n2];
                try {
                    this.fTargets.add(handle.getTargetDefinition());
                }
                catch (CoreException e2) {
                    PDECore.log((Throwable)e2);
                }
                ++n2;
            }
            if (this.fTargets.isEmpty()) {
                try {
                    this.fTargets.add(service.getWorkspaceTargetDefinition());
                }
                catch (CoreException e3) {
                    PDECore.log((Throwable)e3);
                }
            }
            this.targetsViewer.setInput(this.fTargets);
        }
        this.targetsViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String name1 = ((ITargetDefinition)e1).getName();
                String name2 = ((ITargetDefinition)e2).getName();
                if (name1 == null) {
                    return -1;
                }
                if (name2 == null) {
                    return 1;
                }
                return name1.compareToIgnoreCase(name2);
            }
        });
        this.reloadbutton = SWTFactory.createPushButton(comp, WizardMessages.ApiProfileWizardPage_12, null);
        this.reloadbutton.setEnabled(this.targetsViewer.getCheckedElements().length == 1);
        this.reloadbutton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.doReload()));
        SWTFactory.createWrapLabel(comp, WizardMessages.ApiProfileWizardPage_13, 4);
        Tree tree = new Tree(comp, 67586);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        gd.horizontalSpan = 4;
        tree.setLayoutData((Object)gd);
        this.treeviewer = new TreeViewer(tree);
        this.treeviewer.setLabelProvider((IBaseLabelProvider)new ApiToolsLabelProvider());
        this.treeviewer.setContentProvider((IContentProvider)new ApiBaselineWizardPage.ContentProvider());
        this.treeviewer.setComparator(new ViewerComparator());
        this.treeviewer.setInput((Object)this.getCurrentComponents());
        this.treeviewer.addSelectionChangedListener(event -> this.updateButtons());
        this.treeviewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IApiComponent) {
                    IApiComponent component = (IApiComponent)element;
                    try {
                        if (component.isSourceComponent() || component.isSystemComponent()) {
                            return false;
                        }
                    }
                    catch (CoreException e) {
                        ApiPlugin.log((Throwable)e);
                    }
                    return true;
                }
                return !(element instanceof SystemLibraryApiComponent);
            }
        });
        this.setControl((Control)comp);
        if (this.fProfile != null) {
            this.nametext.setText(this.fProfile.getName());
            ITargetDefinition found = null;
            for (ITargetDefinition target : this.fTargets) {
                if (!ApiModelFactory.isDerivedFromTarget((IApiBaseline)this.fProfile, (ITargetDefinition)target)) continue;
                found = target;
                break;
            }
            if (found != null) {
                this.selectedTargetDefinition = found;
                this.targetsViewer.setCheckedElements(new Object[]{found});
            }
        }
        this.initialize();
        this.updateButtons();
        this.setPageComplete(this.pageValid());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, IApiToolsHelpContextIds.APIPROFILES_WIZARD_PAGE);
        Dialog.applyDialogFont((Control)comp);
    }

    protected boolean pageValid() {
        this.setErrorMessage(null);
        ITargetDefinition selected = this.getSelectedTargetDefinition();
        if (selected != null && selected.getStatus() != null && !selected.getStatus().isOK()) {
            this.setErrorMessage(WizardMessages.TargetBasedApiBaselineWizardPage_loading_error);
            return false;
        }
        if (!this.isNameValid(this.nametext.getText().trim())) {
            return false;
        }
        if (this.targetsViewer.getCheckedElements().length != 1) {
            this.setErrorMessage(WizardMessages.ApiProfileWizardPage_select_target);
            this.reloadbutton.setEnabled(false);
            return false;
        }
        if (this.fProfile != null) {
            if (this.fProfile.getApiComponents().length == 0) {
                this.setErrorMessage(WizardMessages.ApiProfileWizardPage_2);
                return false;
            }
            IStatus status = this.fProfile.getExecutionEnvironmentStatus();
            if (status.getSeverity() == 4) {
                this.setErrorMessage(status.getMessage());
                return false;
            }
            if (!ApiModelFactory.isUpToDateWithTarget((IApiBaseline)this.fProfile, (ITargetDefinition)selected)) {
                this.setErrorMessage(WizardMessages.ApiProfileWizardPage_location_needs_reset);
                return false;
            }
        } else {
            this.setErrorMessage(WizardMessages.ApiProfileWizardPage_location_needs_reset);
            return false;
        }
        return true;
    }

    private ITargetDefinition getSelectedTargetDefinition() {
        return this.selectedTargetDefinition;
    }

    protected void updateButtons() {
        this.reloadbutton.setEnabled(this.getSelectedTargetDefinition() != null);
    }

    @Override
    public IApiBaseline finish() throws IOException, CoreException {
        if (this.fProfile != null) {
            this.fProfile.setName(this.nametext.getText().trim());
        }
        return this.fProfile;
    }

    protected void doReload() {
        ReloadTargetOperation op = new ReloadTargetOperation(this.getSelectedTargetDefinition(), this.nametext.getText().trim());
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
            this.treeviewer.setInput((Object)this.getCurrentComponents());
            this.treeviewer.refresh();
            this.setPageComplete(this.pageValid());
        }
        catch (InterruptedException | InvocationTargetException exception) {}
    }

    private ITargetPlatformService getTargetService() {
        return (ITargetPlatformService)ApiPlugin.getDefault().acquireService(ITargetPlatformService.class);
    }

    class ReloadTargetOperation
    implements IRunnableWithProgress {
        private ITargetDefinition definition;
        private String name;

        public ReloadTargetOperation(ITargetDefinition definition, String name) {
            this.definition = definition;
            this.name = name;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                TargetBasedApiBaselineWizardPage.this.fProfile = ApiModelFactory.newApiBaselineFromTarget((String)this.name, (ITargetDefinition)this.definition, (IProgressMonitor)monitor);
                TargetBasedApiBaselineWizardPage.this.contentchange = true;
            }
            catch (CoreException e) {
                ApiPlugin.log((Throwable)e);
            }
        }
    }

    private static class TargetLabelProvider
    extends StyledCellLabelProvider {
        private final PDELabelProvider pdeLabelProvider = PDEPlugin.getDefault().getLabelProvider();

        public TargetLabelProvider() {
            this.pdeLabelProvider.connect((Object)this);
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            ITargetDefinition targetDef = (ITargetDefinition)element;
            ITargetHandle targetHandle = targetDef.getHandle();
            String name = targetDef.getName();
            if (name == null || name.length() == 0) {
                name = targetHandle.toString();
            }
            StyledString styledString = new StyledString(name);
            if (targetHandle instanceof WorkspaceFileTargetHandle) {
                IFile file = ((WorkspaceFileTargetHandle)targetHandle).getTargetFile();
                String location = " - " + file.getFullPath();
                styledString.append(location, StyledString.DECORATIONS_STYLER);
            } else if (targetHandle instanceof ExternalFileTargetHandle) {
                URI uri = ((ExternalFileTargetHandle)targetHandle).getLocation();
                String location = " - " + uri.toASCIIString();
                styledString.append(location, StyledString.DECORATIONS_STYLER);
            }
            cell.setText(styledString.toString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(this.getImage());
            super.update(cell);
        }

        public Image getImage() {
            return this.pdeLabelProvider.get(PDEPluginImages.DESC_TARGET_DEFINITION);
        }

        public void dispose() {
            this.pdeLabelProvider.disconnect((Object)this);
            super.dispose();
        }
    }
}

