/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.internal.iseries;

import java.sql.Connection;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.IDatabaseRecognizer;

public class ISeriesDatabaseRecognizer
implements IDatabaseRecognizer {
    private static final String PRODUCT = "DB2 UDB iSeries";

    public DatabaseDefinition recognize(Connection connection) {
        try {
            String version = connection.getMetaData().getDatabaseProductVersion();
            if (version.indexOf("V5R1") > -1) {
                return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, "V5R1");
            }
            if (version.indexOf("V5R2") > -1) {
                return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, "V5R2");
            }
            if (version.indexOf("V5R3") > -1) {
                return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, "V5R3");
            }
            if (version.indexOf("V05R01") > -1) {
                return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, "V5R1");
            }
            if (version.indexOf("V05R02") > -1) {
                return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, "V5R2");
            }
            if (version.indexOf("V05R03") > -1) {
                return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, "V5R3");
            }
            if (version.startsWith("QSQ050")) {
                char r = version.charAt(6);
                if (r == '1') {
                    return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, "V5R1");
                }
                if (r == '2') {
                    return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, "V5R2");
                }
                if (r == '3') {
                    return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, "V5R3");
                }
                if (r == '4') {
                    return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, "V5R4");
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

