/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.actions;

import java.util.List;
import org.eclipse.birt.report.designer.data.ui.dataset.AdvancedDataSetEditor;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataSourceSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractElementAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DerivedDataSetHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.ui.PlatformUI;

public class EditDataSetAction
extends AbstractElementAction {
    public static final String ID = "org.eclipse.birt.report.designer.ui.actions.EditDataSetAction";

    public EditDataSetAction(Object selectedObject) {
        super(selectedObject);
        this.setId(ID);
    }

    public EditDataSetAction(Object selectedObject, String text) {
        super(selectedObject, text);
        this.setId(ID);
    }

    protected boolean doAction() throws Exception {
        AdvancedDataSetEditor dialog;
        DataSetHandle dsHandle;
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Edit data set action >> Runs ...");
        }
        if (!((dsHandle = (DataSetHandle)this.getSelection()) instanceof JointDataSetHandle) && !(dsHandle instanceof DerivedDataSetHandle) && dsHandle.getDataSource() == null) {
            DataSourceSelectionDialog dataSorucedialog;
            block6: {
                try {
                    List dataSourceList = DEUtil.getDataSources();
                    String[] names = new String[dataSourceList.size()];
                    int i = 0;
                    while (i < names.length) {
                        names[i] = ((DataSourceHandle)dataSourceList.get(i)).getName();
                        ++i;
                    }
                    dataSorucedialog = new DataSourceSelectionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"dataSourceSelectionPage.title"), names);
                    if (dataSorucedialog.open() != 1) break block6;
                    return false;
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle((Throwable)e);
                    return false;
                }
            }
            dsHandle.setDataSource(dataSorucedialog.getResult().toString());
        }
        return (dialog = new AdvancedDataSetEditor(PlatformUI.getWorkbench().getDisplay().getActiveShell(), dsHandle, false, false)).open() == 0;
    }

    public boolean isEnabled() {
        return ((DataSetHandle)this.getSelection()).canEdit();
    }

    protected String getTransactionLabel() {
        return Messages.getFormattedString((String)"dataset.edit", (Object[])new String[]{((DataSetHandle)this.getSelection()).getName()});
    }
}

