/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.dialog;

import com.ibm.icu.util.ULocale;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelperProvider;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.dialog.IMeasureDialogHelper;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.CubeACLExpressionProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.CubeMeasureExpressionProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.LinkToCubeExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.BaseTitleAreaDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.FormatValueHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.FormatValue;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MeasureDialog
extends BaseTitleAreaDialog {
    private static final String ARGUMENT_EXPRESSION = "Expression";
    private boolean isEdit = false;
    private boolean isAutoPrimaryKeyChecked = false;
    private CubeMeasureExpressionProvider provider;
    private Combo typeCombo;
    private Text expressionText;
    private Text txtFilter;
    private Button derivedMeasureBtn;
    private Button visibilityBtn;
    private Label exprDesc;
    private FunctionUI functionUI;
    private MeasureHandle input;
    private Text nameText;
    private static IChoice[] dataTypes = DEUtil.getMetaDataDictionary().getElement("Measure").getProperty("dataType").getAllowedChoices().getChoices();
    private Object result;
    private IDialogHelper securityHelper;
    private IDialogHelper formatHelper;
    private IDialogHelper alignmentHelper;
    private IMeasureDialogHelper measureHelper;
    private Text displayNameText;

    public MeasureDialog(boolean newOrEdit) {
        super(UIUtil.getDefaultShell());
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.isEdit = !newOrEdit;
    }

    private String[] getDataTypeNames() {
        IChoice[] choices = dataTypes;
        if (choices == null) {
            return new String[0];
        }
        String[] names = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            names[i] = choices[i].getName();
            ++i;
        }
        return names;
    }

    private String getDataTypeDisplayName(String name) {
        return ChoiceSetFactory.getDisplayNameFromChoiceSet((String)name, (IChoiceSet)DEUtil.getMetaDataDictionary().getElement("Measure").getProperty("dataType").getAllowedChoices());
    }

    private String[] getDataTypeDisplayNames() {
        IChoice[] choices = dataTypes;
        if (choices == null) {
            return new String[0];
        }
        String[] displayNames = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            displayNames[i] = choices[i].getDisplayName();
            ++i;
        }
        return displayNames;
    }

    public void setInput(MeasureHandle input) {
        this.input = input;
    }

    public void setAutoPrimaryKeyStatus(boolean isChecked) {
        this.isAutoPrimaryKeyChecked = isChecked;
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.MeasureDialog_ID");
        Composite area = (Composite)super.createDialogArea(parent);
        ScrolledComposite sc = new ScrolledComposite(area, 512);
        sc.setAlwaysShowScrollBars(false);
        sc.setExpandHorizontal(true);
        sc.setLayoutData((Object)new GridData(1808));
        Composite contents = new Composite((Composite)sc, 0);
        sc.setContent((Control)contents);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.marginWidth = 20;
        contents.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(70);
        contents.setLayoutData((Object)data);
        this.createMeasureArea(contents);
        this.createVisibilityGroup(contents);
        WidgetUtil.createGridPlaceholder((Composite)contents, (int)1, (boolean)true);
        this.initMeasureDialog();
        Point size = contents.computeSize(-1, -1);
        contents.setSize(Math.max(size.x, 400), Math.max(size.y, 320));
        return contents;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(Messages.getString("MeasureDialog.Title.Description"));
        this.setMessage(Messages.getString("MeasureDialog.Text.Description"));
        return control;
    }

    private void initMeasureDialog() {
        Expression filterExpr;
        this.functionUI.initUI();
        this.typeCombo.setItems(this.getDataTypeDisplayNames());
        if (!this.isEdit) {
            if (this.typeCombo.getItemCount() > 0) {
                this.typeCombo.select(0);
            }
            this.handleFunctionSelectEvent();
        } else {
            try {
                String funcName = DataAdapterUtil.adaptModelAggregationType((String)this.input.getFunction());
                Map<String, Expression> arguments = this.getArguments(this.input);
                ExpressionHandle argExpr = this.input.getExpressionProperty("measureExpression");
                this.functionUI.setAggregation(funcName, arguments, (Expression)argExpr.getValue());
            }
            catch (AdapterException e) {
                ExceptionUtil.handle((Throwable)e);
            }
            ExpressionButtonUtil.initExpressionButtonControl((Control)this.expressionText, (Object)this.input, (String)"measureExpression");
            this.nameText.setText(this.input.getName() == null ? "" : this.input.getName());
            this.displayNameText.setText(this.input.getDisplayName() == null ? "" : this.input.getDisplayName());
            this.handleFunctionSelectEvent();
            this.typeCombo.setText(this.getDataTypeDisplayName(this.input.getDataType()) == null ? "" : this.getDataTypeDisplayName(this.input.getDataType()));
            this.derivedMeasureBtn.setSelection(this.input.isCalculated());
            this.updateDerivedMeasureStatus();
        }
        if (this.measureHelper != null && this.measureHelper.hasFilter(this.input) && (filterExpr = this.measureHelper.getFilter(this.input)) != null) {
            ExpressionButtonUtil.initExpressionButtonControl((Control)this.txtFilter, (Expression)filterExpr);
        }
        if (this.formatHelper != null) {
            if (this.typeCombo.getSelectionIndex() > -1) {
                this.formatHelper.setProperty("Format Value Type", (Object)this.getDataTypeNames()[this.typeCombo.getSelectionIndex()]);
            }
            this.formatHelper.update(true);
        }
        if (this.alignmentHelper != null) {
            if (this.input.getAlignment() != null) {
                this.alignmentHelper.setProperty("Alignment Value", (Object)this.input.getAlignment());
            } else if (!this.isEdit && this.input.getDataType() != null) {
                if (this.isNumber(this.input.getDataType())) {
                    this.alignmentHelper.setProperty("Alignment Value", (Object)"right");
                } else {
                    this.alignmentHelper.setProperty("Alignment Value", (Object)"left");
                }
            }
            this.alignmentHelper.update(true);
        }
    }

    private boolean isNumber(String dataType) {
        return "decimal".equals(dataType) || "float".equals(dataType) || "integer".equals(dataType);
    }

    public Object getResult() {
        return this.result;
    }

    private boolean hasFilter(MeasureHandle measure) {
        if (this.measureHelper != null) {
            return this.measureHelper.hasFilter(measure);
        }
        return false;
    }

    private void setFilter(MeasureHandle measure, Expression expr) throws SemanticException {
        if (this.measureHelper != null) {
            this.measureHelper.setFilter(measure, expr);
        }
    }

    private Map<String, Expression> getArguments(MeasureHandle measure) {
        if (this.measureHelper != null) {
            return this.measureHelper.getArguments(measure);
        }
        return null;
    }

    private void setArguments(MeasureHandle measure, Map<String, Expression> arguments) throws SemanticException {
        if (this.measureHelper != null) {
            this.measureHelper.setArguments(measure, arguments);
        }
    }

    private MeasureHandle createMeasure(String name) throws SemanticException {
        if (this.measureHelper != null) {
            return this.measureHelper.createMeasure(name);
        }
        return DesignElementFactory.getInstance().newTabularMeasure(this.nameText.getText());
    }

    protected void okPressed() {
        try {
            MeasureHandle measure = this.input;
            if (measure == null) {
                measure = this.createMeasure(this.nameText.getText().trim());
            } else {
                this.input.setName(this.nameText.getText().trim());
            }
            if (this.displayNameText.getText().trim().length() > 0) {
                measure.setDisplayName(this.displayNameText.getText().trim());
            } else {
                measure.setDisplayName(null);
            }
            measure.setCalculated(this.derivedMeasureBtn.getSelection());
            if (this.derivedMeasureBtn.getSelection()) {
                measure.setFunction(null);
                this.setArguments(measure, null);
            } else {
                IAggrFunction func = this.functionUI.getSelectedFunction();
                if (func != null) {
                    String modelFuncName = DataAdapterUtil.toModelAggregationType((String)func.getName());
                    measure.setFunction(modelFuncName);
                }
                this.setArguments(measure, this.functionUI.getArguments());
            }
            measure.setDataType(this.getDataTypeNames()[this.typeCombo.getSelectionIndex()]);
            if (this.expressionText.isEnabled()) {
                ExpressionButtonUtil.saveExpressionButtonControl((Control)this.expressionText, (Object)measure, (String)"measureExpression");
            }
            if (!this.derivedMeasureBtn.getSelection()) {
                if (this.securityHelper != null) {
                    this.securityHelper.validate();
                    measure.setExpressionProperty("ACLExpression", (Expression)this.securityHelper.getProperty("Security Expression Property"));
                }
                if (this.hasFilter(measure)) {
                    this.setFilter(measure, ExpressionButtonUtil.getExpression((Control)this.txtFilter));
                }
            } else {
                measure.setExpressionProperty("ACLExpression", null);
                if (this.hasFilter(measure)) {
                    this.setFilter(measure, null);
                }
            }
            if (this.alignmentHelper != null) {
                measure.setAlignment((String)this.alignmentHelper.getProperty("Alignment Value"));
            }
            if (this.formatHelper != null && this.formatHelper.getProperty("Format Value Result") instanceof Object[]) {
                Object[] formatValue = (Object[])this.formatHelper.getProperty("Format Value Result");
                Object value = measure.getProperty("format");
                if (value == null) {
                    FormatValue formatValueToSet = new FormatValue();
                    formatValueToSet.setCategory((String)formatValue[0]);
                    formatValueToSet.setPattern((String)formatValue[1]);
                    formatValueToSet.setLocale((ULocale)formatValue[2]);
                    measure.setProperty("format", (Object)formatValueToSet);
                } else {
                    PropertyHandle propHandle = measure.getPropertyHandle("format");
                    FormatValue formatValueToSet = (FormatValue)value;
                    FormatValueHandle formatHandle = (FormatValueHandle)formatValueToSet.getHandle((SimpleValueHandle)propHandle);
                    formatHandle.setCategory((String)formatValue[0]);
                    formatHandle.setPattern((String)formatValue[1]);
                    formatHandle.setLocale((ULocale)formatValue[2]);
                }
            }
            measure.setVisible(!this.visibilityBtn.getSelection());
            this.result = measure;
        }
        catch (SemanticException e) {
            ExceptionUtil.handle((Throwable)e);
            return;
        }
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.checkOkButtonStatus();
    }

    private Composite createMeasureArea(Composite parent) {
        DesignElementHandle container = this.input.getContainer();
        DesignElementHandle superContainer = container.getContainer();
        this.measureHelper = (IMeasureDialogHelper)ElementAdapterManager.getAdapter((Object)superContainer, IMeasureDialogHelper.class);
        this.getShell().setText(Messages.getString("MeasureDialog.Title.Property"));
        Group group = new Group(parent, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        Label nameLabel = new Label((Composite)group, 0);
        nameLabel.setText(Messages.getString("MeasureDialog.Label.Name"));
        this.nameText = new Text((Composite)group, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gd);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MeasureDialog.this.checkOkButtonStatus();
            }
        });
        Label displayNameLabel = new Label((Composite)group, 0);
        displayNameLabel.setText(Messages.getString("MeasureDialog.Label.DisplayName"));
        this.displayNameText = new Text((Composite)group, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.displayNameText.setLayoutData((Object)gd);
        this.displayNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MeasureDialog.this.checkOkButtonStatus();
            }
        });
        new Label((Composite)group, 0);
        this.derivedMeasureBtn = new Button((Composite)group, 32);
        this.derivedMeasureBtn.setText(Messages.getString("MeasureDialog.Label.DerivedMeasure"));
        this.derivedMeasureBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MeasureDialog.this.updateDerivedMeasureStatus();
                if (!MeasureDialog.this.derivedMeasureBtn.getSelection()) {
                    MeasureDialog.this.handleTypeSelectEvent();
                }
                MeasureDialog.this.checkOkButtonStatus();
            }
        });
        new Label((Composite)group, 0);
        this.functionUI = this.createFunctionUI((Composite)group);
        this.functionUI.createUI();
        Label typeLabel = new Label((Composite)group, 0);
        typeLabel.setText(Messages.getString("MeasureDialog.Label.DataType"));
        this.typeCombo = new Combo((Composite)group, 2056);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.typeCombo.setLayoutData((Object)gd);
        this.typeCombo.setVisibleItemCount(30);
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!MeasureDialog.this.derivedMeasureBtn.getSelection()) {
                    MeasureDialog.this.handleTypeSelectEvent();
                }
                MeasureDialog.this.checkOkButtonStatus();
                if (MeasureDialog.this.formatHelper != null) {
                    if (MeasureDialog.this.typeCombo.getSelectionIndex() > -1) {
                        MeasureDialog.this.formatHelper.setProperty("Format Value Type", (Object)MeasureDialog.this.getDataTypeNames()[MeasureDialog.this.typeCombo.getSelectionIndex()]);
                    }
                    MeasureDialog.this.formatHelper.update(true);
                }
            }
        });
        Label expressionLabel = new Label((Composite)group, 0);
        expressionLabel.setText(Messages.getString("MeasureDialog.Label.Expression"));
        this.expressionText = new Text((Composite)group, 2050);
        gd = new GridData(768);
        gd.heightHint = this.expressionText.computeSize((int)-1, (int)-1).y - this.expressionText.getBorderWidth() * 2;
        this.expressionText.setLayoutData((Object)gd);
        this.expressionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MeasureDialog.this.checkOkButtonStatus();
            }
        });
        this.provider = this.measureHelper != null ? this.measureHelper.getExpressionProvider(this.input) : new CubeMeasureExpressionProvider(this.input, this.input.isCalculated());
        ExpressionButtonUtil.createExpressionButton((Composite)group, (Control)this.expressionText, (IExpressionProvider)this.provider, (Object)this.input);
        new Label((Composite)group, 0);
        this.exprDesc = new Label((Composite)group, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        this.exprDesc.setLayoutData((Object)gd);
        this.exprDesc.setText(Messages.getString(Messages.getString(this.derivedMeasureBtn.getSelection() ? "MeasureDialog.Label.ExprDesc.Derived" : "MeasureDialog.Label.ExprDesc")));
        this.exprDesc.setForeground(ColorManager.getColor((int)128, (int)128, (int)128));
        if (this.hasFilter(this.input)) {
            this.createFilterPart((Composite)group);
        }
        if (this.measureHelper == null || !this.measureHelper.hideSecurityPart()) {
            this.createSecurityPart((Composite)group);
        }
        if (this.measureHelper == null || !this.measureHelper.hideHyperLinkPart()) {
            this.createHyperLinkPart((Composite)group);
        }
        if (this.measureHelper == null || !this.measureHelper.hideFormatPart()) {
            this.createFormatPart((Composite)group);
        }
        if (this.measureHelper == null || !this.measureHelper.hideAlignmentPart()) {
            this.createAlignmentPart((Composite)group);
        }
        return group;
    }

    private Composite createVisibilityGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setText(Messages.getString("MeasureDialog.Label.Visibility.Group"));
        this.visibilityBtn = new Button((Composite)group, 32);
        this.visibilityBtn.setText(Messages.getString("MeasureDialog.Label.Visibility"));
        this.visibilityBtn.setSelection(!this.input.isVisible());
        return group;
    }

    private IDialogHelper createHyperLinkPart(Composite parent) {
        Object[] helperProviders = ElementAdapterManager.getAdapters((Object)this.input, IDialogHelperProvider.class);
        if (helperProviders != null) {
            int i = 0;
            while (i < helperProviders.length) {
                IDialogHelper hyperLinkHelper;
                IDialogHelperProvider helperProvider = (IDialogHelperProvider)helperProviders[i];
                if (helperProvider != null && (hyperLinkHelper = helperProvider.createHelper((Object)this, "HyperLink Helper")) != null) {
                    hyperLinkHelper.setProperty("HyperLink Label", (Object)Messages.getString("MeasureDialog.Label.LinkTo"));
                    hyperLinkHelper.setProperty("HyperLink Button Text", (Object)Messages.getString("MeasureDialog.Button.Text.Edit"));
                    hyperLinkHelper.setProperty("HyperLink Report Item Handle", (Object)this.input);
                    hyperLinkHelper.setProperty("HyperLink Report Item Expression Provider", (Object)new LinkToCubeExpressionProvider((DesignElementHandle)this.input));
                    hyperLinkHelper.createContent(parent);
                    hyperLinkHelper.addListener(24, new Listener(){

                        public void handleEvent(Event event) {
                            hyperLinkHelper.update(false);
                        }
                    });
                    hyperLinkHelper.update(true);
                    return hyperLinkHelper;
                }
                ++i;
            }
        }
        return null;
    }

    private IDialogHelper createFormatPart(Composite parent) {
        Object[] helperProviders = ElementAdapterManager.getAdapters((Object)this.input, IDialogHelperProvider.class);
        if (helperProviders != null) {
            int i = 0;
            while (i < helperProviders.length) {
                IDialogHelperProvider helperProvider = (IDialogHelperProvider)helperProviders[i];
                if (helperProvider != null) {
                    this.formatHelper = helperProvider.createHelper((Object)this, "Format Helper");
                    if (this.formatHelper != null) {
                        this.formatHelper.setProperty("Format Label", (Object)Messages.getString("MeasureDialog.Label.Format"));
                        this.formatHelper.setProperty("Format Button Text", (Object)Messages.getString("MeasureDialog.Button.Format.Edit"));
                        PropertyHandle propHandle = this.input.getPropertyHandle("format");
                        if (this.input.getProperty("format") != null) {
                            Object value = this.input.getProperty("format");
                            FormatValue formatValueToSet = (FormatValue)value;
                            FormatValueHandle formatHandle = (FormatValueHandle)formatValueToSet.getHandle((SimpleValueHandle)propHandle);
                            this.formatHelper.setProperty("Format Value", (Object)formatHandle);
                        }
                        this.formatHelper.createContent(parent);
                        this.formatHelper.update(true);
                        return this.formatHelper;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private IDialogHelper createAlignmentPart(Composite parent) {
        Object[] helperProviders = ElementAdapterManager.getAdapters((Object)this.input, IDialogHelperProvider.class);
        if (helperProviders != null) {
            int i = 0;
            while (i < helperProviders.length) {
                IDialogHelperProvider helperProvider = (IDialogHelperProvider)helperProviders[i];
                if (helperProvider != null) {
                    this.alignmentHelper = helperProvider.createHelper((Object)this, "Alignment Helper");
                    if (this.alignmentHelper != null) {
                        this.alignmentHelper.setProperty("Alignment Label", (Object)Messages.getString("MeasureDialog.Label.Alignment"));
                        this.alignmentHelper.setProperty("Alignment Value", (Object)this.input.getAlignment());
                        this.alignmentHelper.createContent(parent);
                        this.alignmentHelper.update(true);
                        return this.alignmentHelper;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private void createSecurityPart(Composite parent) {
        Object[] helperProviders = ElementAdapterManager.getAdapters((Object)this.input, IDialogHelperProvider.class);
        if (helperProviders != null) {
            int i = 0;
            while (i < helperProviders.length) {
                IDialogHelperProvider helperProvider = (IDialogHelperProvider)helperProviders[i];
                if (helperProvider != null && this.securityHelper == null) {
                    this.securityHelper = helperProvider.createHelper((Object)this, "Security Helper");
                    if (this.securityHelper != null) {
                        this.securityHelper.setProperty("Security Label", (Object)Messages.getString("MeasureDialog.Access.Control.List.Expression"));
                        this.securityHelper.setProperty("Security Expression Context", (Object)this.input);
                        this.securityHelper.setProperty("Security Expression Provider", (Object)new CubeACLExpressionProvider((DesignElementHandle)this.input));
                        this.securityHelper.setProperty("Security Expression Property", (Object)this.input.getACLExpression());
                        this.securityHelper.createContent(parent);
                        this.securityHelper.addListener(24, new Listener(){

                            public void handleEvent(Event event) {
                                MeasureDialog.this.securityHelper.update(false);
                            }
                        });
                        this.securityHelper.update(true);
                    }
                }
                ++i;
            }
        }
    }

    private void createFilterPart(Composite composite) {
        new Label(composite, 0).setText(Messages.getString("MeasureDialog.Label.Filter"));
        this.txtFilter = new Text(composite, 2050);
        GridData gd = new GridData(768);
        gd.heightHint = this.txtFilter.computeSize((int)-1, (int)-1).y - this.txtFilter.getBorderWidth() * 2;
        gd.horizontalSpan = 1;
        this.txtFilter.setLayoutData((Object)gd);
        this.txtFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MeasureDialog.this.checkOkButtonStatus();
            }
        });
        ExpressionButtonUtil.createExpressionButton((Composite)composite, (Control)this.txtFilter, (IExpressionProvider)this.provider, (Object)this.input);
    }

    protected void handleTypeSelectEvent() {
        IAggrFunction function = this.functionUI.getSelectedFunction();
        if (function == null) {
            return;
        }
        int returnType = function.getDataType();
        String typeName = DataAdapterUtil.adapterToModelDataType((int)returnType);
        String recommendType = this.getDataTypeDisplayName(typeName);
        if (!this.typeCombo.getText().equals(recommendType) && this.typeCombo.indexOf(recommendType) != -1 && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.getString("MeasureDialog.MessageDialog.Title"), (String)Messages.getFormattedString("MeasureDialog.MessageDialog.Message", new Object[]{recommendType}))) {
            this.typeCombo.setText(recommendType);
        }
    }

    private FunctionProvider createFuncProvider() {
        IAggrFunction[] funcs = null;
        if (this.measureHelper != null) {
            funcs = this.measureHelper.getAggregationFunctions(this.input);
        } else {
            try {
                List aggrInfoList = DataUtil.getAggregationManager().getAggregations(2);
                funcs = aggrInfoList.toArray(new IAggrFunction[0]);
            }
            catch (BirtException e) {
                ExceptionUtil.handle((Throwable)e);
                funcs = new IAggrFunction[]{};
            }
        }
        return new FunctionProvider(funcs);
    }

    protected Runnable createFunctionUICallback() {
        return new Runnable(){

            @Override
            public void run() {
                MeasureDialog.this.handleFunctionSelectEvent();
                MeasureDialog.this.checkOkButtonStatus();
            }
        };
    }

    protected FunctionUI createFunctionUI(Composite composite) {
        FunctionProvider funcProvider = this.createFuncProvider();
        Runnable callback = this.createFunctionUICallback();
        FunctionUI ui = new FunctionUI(composite, (DesignElementHandle)this.input, funcProvider, this.provider, null, callback);
        return ui;
    }

    protected void createFunctionUIPart(Composite composite) {
        this.functionUI = this.createFunctionUI(composite);
        this.functionUI.createUI();
        this.functionUI.initUI();
    }

    private void handleFunctionSelectEvent() {
        IAggrFunction func = this.functionUI.getSelectedFunction();
        if (func == null) {
            return;
        }
        int returnType = func.getDataType();
        String typeName = DataAdapterUtil.adapterToModelDataType((int)returnType);
        String typeDisplayText = this.getDataTypeDisplayName(typeName);
        this.typeCombo.setText(typeDisplayText);
        int parameterLength = func.getParameterDefn().length;
        this.expressionText.setEnabled(parameterLength > 0);
        ((ExpressionButton)this.expressionText.getData("exprButton")).setEnabled(parameterLength > 0);
    }

    private boolean isValidExpression(Expression expr) {
        return expr != null && expr.getStringExpression() != null && expr.getStringExpression().trim().length() != 0;
    }

    protected String checkExpression() {
        if (this.expressionText.getText() == null || this.expressionText.getText().trim().length() == 0) {
            return Messages.getString("MeasureDialog.Message.BlankExpression");
        }
        if (!this.derivedMeasureBtn.getSelection()) {
            IAggrFunction function = this.functionUI.getSelectedFunction();
            if (function == null) {
                return Messages.getString("MeasureDialog.Message.BlankFunction");
            }
            IParameterDefn[] paramDefs = function.getParameterDefn();
            if (paramDefs != null) {
                Map<String, Expression> argValues = this.functionUI.getArguments();
                IParameterDefn[] iParameterDefnArray = paramDefs;
                int n = paramDefs.length;
                int n2 = 0;
                while (n2 < n) {
                    Expression value;
                    String argName;
                    IParameterDefn paramDef = iParameterDefnArray[n2];
                    if (!(paramDef.isOptional() || ARGUMENT_EXPRESSION.equals(argName = DataAdapterUtil.adaptArgumentName((String)paramDef.getName())) || this.isValidExpression(value = argValues.get(argName)))) {
                        return Messages.getFormattedString("MessageDialog.Message.BlankArgument", new String[]{paramDef.getDisplayName().replaceAll("\\(&[a-zA-Z0-9]\\)", "").replace("&", "")});
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    private String checkName() {
        if (this.nameText.getText() == null || this.nameText.getText().trim().equals("")) {
            return Messages.getString("MeasureDialog.Message.BlankName");
        }
        if (!UIUtil.validateDimensionName((String)this.nameText.getText())) {
            return Messages.getString("MeasureDialog.Message.NumericName");
        }
        return null;
    }

    private String checkType() {
        if (this.typeCombo.getSelectionIndex() == -1) {
            return Messages.getString("MeasureDialog.Message.BlankType");
        }
        return null;
    }

    protected void checkOkButtonStatus() {
        String errorMessage = this.checkName();
        if (errorMessage == null && (errorMessage = this.checkType()) == null && (errorMessage = this.checkExpression()) == null && this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
            this.setMessage(Messages.getString("MeasureDialog.Text.Description"));
            return;
        }
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(false);
            this.setMessage(null);
            this.setErrorMessage(errorMessage);
        }
    }

    private void updateDerivedMeasureStatus() {
        boolean isDerivedMeasure = this.derivedMeasureBtn.getSelection();
        if (this.txtFilter != null) {
            this.txtFilter.setEnabled(!isDerivedMeasure);
            ExpressionButtonUtil.getExpressionButton((Control)this.txtFilter).setEnabled(!isDerivedMeasure);
        }
        this.functionUI.setEnabled(!isDerivedMeasure && !this.isAutoPrimaryKeyChecked);
        if (this.securityHelper != null) {
            this.securityHelper.setProperty("Security Expression Enable", (Object)(!isDerivedMeasure ? 1 : 0));
            this.securityHelper.update(true);
        }
        this.exprDesc.setText(Messages.getString(isDerivedMeasure ? "MeasureDialog.Label.ExprDesc.Derived" : "MeasureDialog.Label.ExprDesc"));
        this.provider.setDerivedMeasure(isDerivedMeasure);
    }

    private class FunctionProvider {
        private IAggrFunction[] funcs;
        private HashMap<String, IAggrFunction> displayName2Funcs;
        private HashMap<String, IAggrFunction> name2Funcs;

        public FunctionProvider(IAggrFunction[] funcs) {
            this.funcs = funcs == null ? new IAggrFunction[]{} : funcs;
            this.displayName2Funcs = new HashMap(funcs.length);
            this.name2Funcs = new HashMap(funcs.length);
            IAggrFunction[] iAggrFunctionArray = funcs;
            int n = funcs.length;
            int n2 = 0;
            while (n2 < n) {
                IAggrFunction func = iAggrFunctionArray[n2];
                this.displayName2Funcs.put(func.getDisplayName(), func);
                this.name2Funcs.put(func.getName(), func);
                ++n2;
            }
        }

        public IAggrFunction getFunction(String funcName) {
            return this.name2Funcs.get(funcName);
        }

        public IAggrFunction getFunctionByDisplayText(String displayText) {
            return this.displayName2Funcs.get(displayText);
        }

        public String[] getDisplayTexts() {
            String[] displayTexts = new String[this.funcs.length];
            int i = 0;
            while (i < this.funcs.length) {
                displayTexts[i] = this.funcs[i].getDisplayName();
                ++i;
            }
            Arrays.sort(displayTexts, new AlphabeticallyComparator());
            return displayTexts;
        }
    }

    protected static class FunctionUI {
        static final String FUNCTION = Messages.getString("MeasureDialog.Label.Function");
        protected Composite parent;
        private Combo cmbFunction;
        private Composite paramsComposite;
        private Map<String, Control> paramsMap = new HashMap<String, Control>();
        private DesignElementHandle bindingHolder;
        private ExpressionProvider exprProvider;
        private FunctionProvider funcProvider;
        private ComputedColumn[] bindings;
        private Runnable callback;
        private Map<String, Expression> paramsValueMap = new HashMap<String, Expression>();

        public FunctionUI(Composite parent, DesignElementHandle bindingHolder, FunctionProvider funcProvider, ExpressionProvider exprProvider, ComputedColumn[] bindings, Runnable callback) {
            this.parent = parent;
            this.bindingHolder = bindingHolder;
            this.exprProvider = exprProvider;
            this.funcProvider = funcProvider;
            this.bindings = bindings;
            this.callback = callback;
        }

        public void setAggregation(String funcName, Map<String, Expression> args, Expression expr) {
            IAggrFunction func = this.funcProvider.getFunction(funcName);
            this.cmbFunction.setText(func == null ? "" : func.getDisplayName());
            if (args != null) {
                this.paramsValueMap.putAll(args);
            }
            this.updateArgumentUI();
        }

        public void setEnabled(boolean enabled) {
            this.cmbFunction.setEnabled(enabled);
            this.paramsComposite.setEnabled(enabled);
        }

        public IAggrFunction getSelectedFunction() {
            String displayText = this.cmbFunction.getText();
            return this.funcProvider.getFunctionByDisplayText(displayText);
        }

        public String getSelectedFunctionName() {
            IAggrFunction func = this.getSelectedFunction();
            return func == null ? "" : func.getName();
        }

        public Map<String, Expression> getArguments() {
            HashMap<String, Expression> results = new HashMap<String, Expression>();
            for (String argName : this.paramsMap.keySet()) {
                Control control = this.paramsMap.get(argName);
                Expression expr = ExpressionButtonUtil.getExpression((Control)control);
                results.put(argName, expr);
            }
            return results;
        }

        private int getParentLayoutColumns() {
            assert (this.parent.getLayout() instanceof GridLayout);
            Layout layout = this.parent.getLayout();
            if (layout instanceof GridLayout) {
                return ((GridLayout)layout).numColumns;
            }
            return 3;
        }

        public void createUI() {
            int columns = this.getParentLayoutColumns();
            new Label(this.parent, 0).setText(FUNCTION);
            this.cmbFunction = new Combo(this.parent, 2056);
            GridData gd = new GridData(768);
            gd.horizontalSpan = gd.horizontalSpan = columns - 1;
            this.cmbFunction.setLayoutData((Object)gd);
            this.cmbFunction.setVisibleItemCount(30);
            this.cmbFunction.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String funcText = cmbFunction.getText();
                    IAggrFunction func = funcProvider.getFunctionByDisplayText(funcText);
                    if (func != null) {
                        this.updateArgumentUI();
                        callback.run();
                    }
                }
            });
            this.paramsComposite = new Composite(this.parent, 0);
            GridData gridData = new GridData(768);
            gridData.horizontalIndent = 0;
            gridData.horizontalSpan = columns;
            gridData.exclude = true;
            this.paramsComposite.setLayoutData((Object)gridData);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 3;
            Layout parentLayout = this.parent.getLayout();
            if (parentLayout instanceof GridLayout) {
                layout.horizontalSpacing = ((GridLayout)parentLayout).horizontalSpacing;
            }
            this.paramsComposite.setLayout((Layout)layout);
        }

        private void initUI() {
            this.cmbFunction.setItems(this.funcProvider.getDisplayTexts());
            this.cmbFunction.select(0);
            this.updateArgumentUI();
        }

        private void resetArgumentUI() {
            Control[] children = this.paramsComposite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
            this.paramsMap.clear();
            ((GridData)this.paramsComposite.getLayoutData()).exclude = true;
            ((GridData)this.paramsComposite.getLayoutData()).heightHint = 0;
        }

        private int getMaxLabelWidth(Composite parent) {
            int maxWidth = 0;
            Control[] controls = parent.getChildren();
            int i = 0;
            while (i < controls.length) {
                int labelWidth;
                if (controls[i] instanceof Label && (labelWidth = this.getLabelWidth((Label)controls[i])) > maxWidth) {
                    maxWidth = labelWidth;
                }
                ++i;
            }
            return maxWidth;
        }

        private int getLabelWidth(Label label) {
            Object layout = label.getLayoutData();
            if (layout instanceof GridData && ((GridData)layout).horizontalSpan == 1) {
                return label.getBounds().width - label.getBorderWidth() * 2;
            }
            return 0;
        }

        private void createArgumentUI() {
            IParameterDefn[] params;
            IAggrFunction function = this.getSelectedFunction();
            if (function != null && (params = function.getParameterDefn()) != null && params.length > 0) {
                ((GridData)this.paramsComposite.getLayoutData()).exclude = false;
                ((GridData)this.paramsComposite.getLayoutData()).heightHint = -1;
                int width = this.getMaxLabelWidth(this.parent);
                IParameterDefn[] iParameterDefnArray = params;
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    IParameterDefn param = iParameterDefnArray[n2];
                    String paramName = DataAdapterUtil.adaptArgumentName((String)param.getName());
                    if (!MeasureDialog.ARGUMENT_EXPRESSION.equals(paramName)) {
                        Label lblParam = new Label(this.paramsComposite, 0);
                        lblParam.setText(String.valueOf(param.getDisplayName()) + Messages.getString("MeasureDialog.Text.Colon"));
                        GridData gd = new GridData();
                        gd.widthHint = lblParam.computeSize((int)-1, (int)-1).x;
                        if (gd.widthHint < width) {
                            gd.widthHint = width;
                        }
                        lblParam.setLayoutData((Object)gd);
                        if (param.isDataField()) {
                            this.createComboControl(this.paramsComposite, param);
                        } else {
                            this.createTextControl(this.paramsComposite, param);
                        }
                    }
                    ++n2;
                }
            }
        }

        private void createComboControl(Composite paramsComposite, final IParameterDefn param) {
            assert (param.isDataField());
            final Combo cmbDataField = new Combo(paramsComposite, 2048);
            cmbDataField.setLayoutData((Object)new GridData(768));
            cmbDataField.setVisibleItemCount(30);
            this.createExpressionButton(paramsComposite, (Control)cmbDataField, param);
            this.paramsMap.put(param.getName(), (Control)cmbDataField);
            cmbDataField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    paramsValueMap.put(param.getName(), new Expression((Object)cmbDataField.getText(), (String)cmbDataField.getData("exprType")));
                    callback.run();
                }
            });
            cmbDataField.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Expression expr = this.createBindingExpression(cmbDataField);
                    if (expr != null) {
                        cmbDataField.setText(expr.getStringExpression());
                    }
                    if (expr == null) {
                        expr = new Expression((Object)cmbDataField.getText(), (String)cmbDataField.getData("exprType"));
                    }
                    paramsValueMap.put(param.getName(), expr);
                }
            });
        }

        private void createTextControl(Composite paramsComposite, final IParameterDefn param) {
            assert (!param.isDataField());
            final Text txtParam = new Text(paramsComposite, 2050);
            GridData gridData = new GridData(768);
            gridData.heightHint = txtParam.computeSize((int)-1, (int)-1).y - txtParam.getBorderWidth() * 2;
            gridData.horizontalIndent = 0;
            txtParam.setLayoutData((Object)gridData);
            this.createExpressionButton(paramsComposite, (Control)txtParam, param);
            this.paramsMap.put(param.getName(), (Control)txtParam);
            txtParam.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    paramsValueMap.put(param.getName(), new Expression((Object)txtParam.getText(), (String)txtParam.getData("exprType")));
                    callback.run();
                }
            });
        }

        private void initArgumentUI() {
            IAggrFunction function = this.getSelectedFunction();
            if (function != null) {
                IParameterDefn[] params;
                IParameterDefn[] iParameterDefnArray = params = function.getParameterDefn();
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    IParameterDefn param = iParameterDefnArray[n2];
                    this.initArgumentField(param);
                    ++n2;
                }
            }
        }

        protected void updateArgumentUI() {
            this.resetArgumentUI();
            this.createArgumentUI();
            this.initArgumentUI();
            Point size = this.parent.getParent().computeSize(-1, -1);
            this.parent.getParent().setSize(Math.max(size.x, 400), Math.max(size.y, 320));
        }

        private void initArgumentField(IParameterDefn param) {
            Expression expr = this.paramsValueMap.get(param.getName());
            if (expr != null) {
                String text = expr.getStringExpression() == null ? "" : expr.getStringExpression();
                String type = expr.getType() == null ? "javascript" : expr.getType();
                Control control = this.paramsMap.get(param.getName());
                assert (control != null);
                if (control instanceof Text) {
                    Text txtParam = (Text)control;
                    txtParam.setText(text);
                    txtParam.setData("exprType", (Object)type);
                } else if (control instanceof Combo) {
                    Combo cmbDataField = (Combo)control;
                    cmbDataField.setItems(this.getColumnBindings());
                    cmbDataField.setText(text);
                    cmbDataField.setData("exprType", (Object)type);
                }
                ExpressionButton button = (ExpressionButton)control.getData("exprButton");
                if (button != null) {
                    button.refresh();
                }
            }
        }

        private void createExpressionButton(Composite parent, Control control, IParameterDefn param) {
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    callback.run();
                }
            };
            ExpressionButtonUtil.createExpressionButton((Composite)parent, (Control)control, (IExpressionProvider)this.exprProvider, (Object)this.bindingHolder, (Listener)listener);
        }

        private String[] getColumnBindings() {
            if (this.bindings == null) {
                return new String[0];
            }
            String[] names = new String[this.bindings.length];
            int i = 0;
            while (i < this.bindings.length) {
                names[i] = this.bindings[i].getName();
                ++i;
            }
            return names;
        }

        private Expression createBindingExpression(Combo combo) {
            String text = combo.getText();
            String expr = ExpressionButtonUtil.getCurrentExpressionConverter((Control)combo).getBindingExpression(text);
            if (expr != null) {
                return new Expression((Object)expr, "javascript");
            }
            return new Expression((Object)text, "javascript");
        }
    }
}

