/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.IOException;
import org.eclipse.birt.data.engine.olap.data.util.BaseDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.DataType;
import org.eclipse.birt.data.engine.olap.data.util.IOUtil;
import org.eclipse.birt.data.engine.olap.data.util.IObjectReader;
import org.eclipse.birt.data.engine.olap.data.util.IObjectWriter;

public class PrimitiveDiskArray
extends BaseDiskArray {
    private IObjectWriter fieldWriter = null;
    private IObjectReader fieldReader = null;

    @Override
    protected void writeObject(Object object) throws IOException {
        if (object == null) {
            this.getRandomAccessFile().writeShort(-1);
            return;
        }
        this.getRandomAccessFile().writeShort(0);
        if (this.fieldWriter == null) {
            this.fieldWriter = IOUtil.getRandomWriter(DataType.getDataType(object.getClass()));
            this.fieldReader = IOUtil.getRandomReader(DataType.getDataType(object.getClass()));
        }
        this.fieldWriter.write(this.getRandomAccessFile(), object);
    }

    @Override
    protected Object readObject() throws IOException {
        short fieldCount = this.getRandomAccessFile().readShort();
        if (fieldCount == -1) {
            return null;
        }
        return this.fieldReader.read(this.getRandomAccessFile());
    }

    @Override
    public void clear() throws IOException {
        this.fieldWriter = null;
        this.fieldReader = null;
        super.clear();
    }
}

