/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.cache;

import org.eclipse.birt.data.engine.cache.BasicCachedList;
import org.eclipse.birt.data.engine.impl.DataEngineSession;

public class BasicCachedArray {
    BasicCachedList cachedList = null;
    int initialCapacity;

    public BasicCachedArray(String tempDir, int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.cachedList = new BasicCachedList(tempDir, DataEngineSession.getCurrentClassLoader());
        this.initialCapacity = initialCapacity;
    }

    public Object get(int index) {
        this.RangeCheck(index);
        if (this.cachedList.size() <= index) {
            this.resize(index + 1);
        }
        return this.cachedList.get(index);
    }

    public void set(int index, Object element) {
        this.RangeCheck(index);
        if (this.cachedList.size() > index) {
            this.cachedList.set(index, element);
        } else if (this.cachedList.size() == index) {
            this.cachedList.add(element);
        } else {
            this.resize(index + 1);
            this.cachedList.set(index, element);
        }
    }

    public int length() {
        return this.initialCapacity;
    }

    private void resize(int totalSize) {
        int oldSize = this.cachedList.size();
        int i = 0;
        while (i < totalSize - oldSize) {
            this.cachedList.add((Object)null);
            ++i;
        }
    }

    private void RangeCheck(int index) {
        if (index >= this.initialCapacity) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.initialCapacity);
        }
    }
}

