/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.style;

import com.lowagie.text.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.eclipse.birt.report.engine.nLayout.area.style.AreaConstants;
import org.eclipse.birt.report.engine.util.ResourceLocatorWrapper;
import org.eclipse.birt.report.engine.util.SvgFile;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.util.StructureRefUtil;
import org.w3c.dom.css.CSSValue;

public class BackgroundImageInfo
extends AreaConstants {
    protected int xOffset = 0;
    protected int yOffset = 0;
    protected int repeatedMode;
    protected int width = 0;
    protected int height = 0;
    protected String url;
    protected String dataUrl;
    protected byte[] imageData;
    protected String sourceType;
    protected String mimeType;
    protected String fileExtension;
    private static final String DATA_PROTOCOL = "data:";
    private static final String DATA_URL_BASE64 = ";base64,";
    private static final String[][] SUPPORTED_MIME_TYPES = new String[][]{{".jpg", "image/jpeg", "jpg"}, {".jpe", "image/jpeg", "jpg"}, {".jpeg", "image/jpeg", "jpg"}, {".tiff", "image/tiff", "tiff"}, {".svg", "image/svg+xml", "svg"}, {".png", "image/png", "png"}, {".gif", "image/gif", "gif"}};
    protected static final String BGI_SRC_TYPE_DEFAULT = "url";
    private Module module = null;
    private Image image = null;
    private ResourceLocatorWrapper rl = null;

    public BackgroundImageInfo(String url, int repeatedMode, int xOffset, int yOffset, int height, int width, ResourceLocatorWrapper rl, Module module, String sourceType) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.repeatedMode = repeatedMode;
        this.width = width;
        this.height = height;
        this.url = url;
        this.rl = rl;
        this.module = module;
        this.sourceType = sourceType != null ? sourceType : BGI_SRC_TYPE_DEFAULT;
        this.prepareImageByteArray();
    }

    public BackgroundImageInfo(BackgroundImageInfo bgi) {
        this.xOffset = bgi.xOffset;
        this.yOffset = bgi.yOffset;
        this.repeatedMode = bgi.repeatedMode;
        this.width = bgi.width;
        this.height = bgi.height;
        this.url = bgi.url;
        this.imageData = bgi.imageData;
        this.image = bgi.image;
        this.rl = bgi.rl;
        this.sourceType = bgi.sourceType != null ? bgi.sourceType : BGI_SRC_TYPE_DEFAULT;
    }

    public BackgroundImageInfo(String url, CSSValue mode, int xOffset, int yOffset, int height, int width, ResourceLocatorWrapper rl, Module module) {
        this(url, mode != null ? (Integer)repeatMap.get(mode) : 3, xOffset, yOffset, height, width, rl, module, BGI_SRC_TYPE_DEFAULT);
    }

    public BackgroundImageInfo(String url, CSSValue mode, int xOffset, int yOffset, int height, int width, ResourceLocatorWrapper rl, Module module, CSSValue sourceType) {
        this(url, mode != null ? (Integer)repeatMap.get(mode) : 3, xOffset, yOffset, height, width, rl, module, sourceType != null ? (String)bgiSourceTypeMap.get(sourceType) : BGI_SRC_TYPE_DEFAULT);
    }

    public void setResourceLocator(ResourceLocatorWrapper rl) {
        this.rl = rl;
    }

    private void createDataUrl() {
        if (this.url != null && this.url.contains(DATA_PROTOCOL)) {
            this.dataUrl = this.url;
        } else if (this.imageData != null) {
            Base64.Encoder encoder = Base64.getEncoder();
            this.dataUrl = DATA_PROTOCOL + this.mimeType + DATA_URL_BASE64 + new String(encoder.encode(this.imageData), StandardCharsets.UTF_8);
        }
    }

    public String getDataUrl() {
        return this.dataUrl;
    }

    private void setMimeType(String mimeType) {
        if (mimeType != null) {
            this.mimeType = mimeType;
        } else if (this.url.contains(DATA_PROTOCOL)) {
            try {
                if (this.url.contains(";") && this.url.contains(DATA_PROTOCOL)) {
                    String partMimeType = this.url.split(";")[1];
                    this.mimeType = partMimeType.split(DATA_PROTOCOL)[0];
                }
            }
            catch (IndexOutOfBoundsException ioobe) {
                this.mimeType = null;
            }
        } else {
            int index = 0;
            while (index < SUPPORTED_MIME_TYPES.length) {
                if (this.url.toLowerCase().contains(SUPPORTED_MIME_TYPES[index][0])) {
                    this.mimeType = SUPPORTED_MIME_TYPES[index][1];
                    this.fileExtension = SUPPORTED_MIME_TYPES[index][2];
                    break;
                }
                ++index;
            }
        }
    }

    private void prepareImageByteArray() {
        String mimeType;
        block35: {
            mimeType = null;
            if (this.sourceType.equals(BGI_SRC_TYPE_DEFAULT)) {
                if (this.url.contains(DATA_PROTOCOL)) {
                    String[] imageDataArray = this.url.split(DATA_URL_BASE64);
                    if (imageDataArray.length == 2 && this.url.contains(DATA_PROTOCOL)) {
                        try {
                            String imageDataBase64 = imageDataArray[1];
                            Base64.Decoder decoder = Base64.getDecoder();
                            this.imageData = decoder.decode(imageDataBase64);
                            this.mimeType = imageDataArray[0].split(DATA_PROTOCOL)[1];
                        }
                        catch (IndexOutOfBoundsException ioobe) {
                            this.imageData = null;
                            this.image = null;
                            this.mimeType = null;
                        }
                    } else {
                        this.imageData = null;
                        this.image = null;
                        this.mimeType = null;
                    }
                } else if (this.rl == null) {
                    InputStream in = null;
                    try {
                        try {
                            in = new URL(this.url).openStream();
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            byte[] buffer = new byte[1024];
                            int size = in.read(buffer);
                            while (size != -1) {
                                out.write(buffer, 0, size);
                                size = in.read(buffer);
                            }
                            this.imageData = out.toByteArray();
                            out.close();
                        }
                        catch (IOException ioe) {
                            this.imageData = null;
                            this.image = null;
                            this.mimeType = null;
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block35;
                        }
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    try {
                        this.imageData = this.rl.findResource(new URL(this.url));
                    }
                    catch (MalformedURLException mue) {
                        this.imageData = null;
                        this.image = null;
                        this.mimeType = null;
                    }
                }
            }
        }
        if (this.sourceType.equals("embed") || this.imageData == null) {
            StructureDefn defn = (StructureDefn)MetaDataDictionary.getInstance().getStructure("EmbeddedImage");
            byte[] imageData = null;
            try {
                EmbeddedImage ei = (EmbeddedImage)StructureRefUtil.findStructure((Module)this.module, (StructureDefn)defn, (String)this.url);
                imageData = ei.getData(this.module);
                mimeType = ei.getType(this.module);
                if (this.sourceType.equals(BGI_SRC_TYPE_DEFAULT)) {
                    this.sourceType = "embed";
                }
            }
            catch (Exception te) {
                this.imageData = null;
                this.image = null;
                this.mimeType = null;
            }
            this.imageData = imageData;
        }
        if (this.imageData != null) {
            try {
                this.image = Image.getInstance((byte[])this.imageData);
            }
            catch (Exception e) {
                try {
                    this.imageData = SvgFile.transSvgToArray(new ByteArrayInputStream(this.imageData));
                    this.image = Image.getInstance((byte[])this.imageData);
                }
                catch (Exception te) {
                    this.imageData = null;
                    this.image = null;
                    this.mimeType = null;
                }
            }
        }
        this.setMimeType(mimeType);
        this.createDataUrl();
    }

    public Image getImageInstance() {
        return this.image;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int x) {
        this.xOffset = x;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int y) {
        this.yOffset = y;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getRepeatedMode() {
        return this.repeatedMode;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getUrl() {
        return this.url;
    }

    public byte[] getImageData() {
        return this.imageData;
    }
}

