/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.script.internal.scale;

import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.script.api.scale.ILinearScale;
import org.eclipse.birt.chart.script.internal.scale.ScaleImpl;

public class LinearScaleImpl
extends ScaleImpl
implements ILinearScale {
    protected LinearScaleImpl(Axis axis) {
        super(axis);
    }

    @Override
    public double getMax() {
        DataElement data = this.scale.getMax();
        if (data instanceof NumberDataElement) {
            return ((NumberDataElement)data).getValue();
        }
        return Double.NaN;
    }

    @Override
    public double getMin() {
        DataElement data = this.scale.getMin();
        if (data instanceof NumberDataElement) {
            return ((NumberDataElement)data).getValue();
        }
        return Double.NaN;
    }

    @Override
    public int getNumberOfSteps() {
        return this.scale.getStepNumber();
    }

    @Override
    public int getStepSize() {
        return (int)this.scale.getStep();
    }

    @Override
    public void setMax(double max) {
        this.scale.setMax((DataElement)(Double.isNaN(max) ? null : NumberDataElementImpl.create((double)max)));
    }

    @Override
    public void setMin(double min) {
        this.scale.setMin((DataElement)(Double.isNaN(min) ? null : NumberDataElementImpl.create((double)min)));
    }

    @Override
    public void setNumberOfSteps(int steps) {
        this.scale.setStepNumber(steps);
    }

    @Override
    public void setStepSize(int size) {
        this.scale.setStep((double)size);
    }
}

