/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SelectVariableDialog
extends BaseDialog {
    private ReportDesignHandle designHandle;
    private Combo variablesCombo;

    public SelectVariableDialog(ReportDesignHandle designHandle) {
        super(Messages.getString((String)"SelectVariableDialog.Title"));
        this.designHandle = designHandle;
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayoutData((Object)GridDataFactory.swtDefaults().hint(300, -1).create());
        content.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).margins(15, 15).create());
        new Label(content, 0).setText(Messages.getString((String)"SelectVariableDialog.AvailableVariables"));
        this.variablesCombo = new Combo(content, 8);
        this.variablesCombo.setLayoutData((Object)new GridData(768));
        this.variablesCombo.setVisibleItemCount(30);
        this.variablesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectVariableDialog.this.validate();
            }
        });
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.SelectVariableDialog_ID");
        return content;
    }

    @Override
    protected boolean initDialog() {
        List variables = this.designHandle.getPageVariables();
        ArrayList<String> items = new ArrayList<String>();
        items.add(Messages.getString((String)"SelectVariableDialog.ReportSeperator"));
        for (VariableElementHandle variable : variables) {
            if (variable.getType() != null && !variable.getType().equals("report")) continue;
            items.add(variable.getName());
        }
        items.add(Messages.getString((String)"SelectVariableDialog.PageSeperator"));
        for (VariableElementHandle variable : variables) {
            if (variable.getType() == null || !variable.getType().equals("page")) continue;
            items.add(variable.getName());
        }
        this.variablesCombo.setItems(items.toArray(new String[items.size()]));
        this.variablesCombo.select(0);
        this.validate();
        return true;
    }

    protected void okPressed() {
        this.setResult(this.variablesCombo.getText());
        super.okPressed();
    }

    private void validate() {
        String value = this.variablesCombo.getText();
        if (value == null || value.equals("")) {
            this.getOkButton().setEnabled(false);
        } else if (value.equals(Messages.getString((String)"SelectVariableDialog.ReportSeperator")) || value.equals(Messages.getString((String)"SelectVariableDialog.PageSeperator"))) {
            this.getOkButton().setEnabled(false);
        } else {
            this.getOkButton().setEnabled(true);
        }
    }
}

