/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.schematic.GridHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractLayoutCheck;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.TableHandle;

public class TableHandleLayoutCheck
extends AbstractLayoutCheck {
    @Override
    public boolean layoutCheck(Object model) {
        TableHandleAdapter adapter;
        if (model instanceof TableHandle) {
            adapter = new TableHandleAdapter((ReportItemHandle)((TableHandle)model), null);
        } else if (model instanceof GridHandle) {
            adapter = new GridHandleAdapter((GridHandle)model, null);
        } else {
            return true;
        }
        try {
            adapter.reload();
        }
        catch (Exception e) {
            return false;
        }
        int columnCount = adapter.getColumnCount();
        List rows = adapter.getRows();
        return this.getTrueColumnNumber(rows, columnCount);
    }

    private boolean getTrueColumnNumber(List rows, int modelColumnCount) {
        HashMap<Integer, Integer> addRowMap = new HashMap<Integer, Integer>();
        ArrayList<CellHandle> list = new ArrayList<CellHandle>();
        int i = 0;
        while (i < rows.size()) {
            int count = 0;
            RowHandle rowHandle = (RowHandle)rows.get(i);
            List children = rowHandle.getCells().getContents();
            int j = 0;
            while (j < children.size()) {
                CellHandle cellHandle = (CellHandle)children.get(j);
                int rowSpan = cellHandle.getRowSpan();
                int columnSpan = cellHandle.getColumnSpan();
                if (!list.contains(cellHandle)) {
                    int k = 2;
                    while (k <= rowSpan) {
                        if (i + k > rows.size()) {
                            return false;
                        }
                        this.addColumnCounts(i + k, columnSpan, addRowMap);
                        ++k;
                    }
                }
                count = count + 1 + columnSpan - 1;
                list.add(cellHandle);
                ++j;
            }
            Integer addSize = (Integer)addRowMap.get(i + 1);
            if (addSize != null) {
                count = addSize + count;
            }
            if (count != modelColumnCount) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void addColumnCounts(int rowNumber, int size, Map<Integer, Integer> addRowMap) {
        Integer ori = addRowMap.get(rowNumber);
        if (ori == null) {
            addRowMap.put(rowNumber, size);
        } else {
            addRowMap.put(rowNumber, ori + size);
        }
    }
}

