/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.border;

import java.util.HashMap;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.geometry.Insets;

public abstract class BaseBorder
extends AbstractBorder {
    public static final String STYLE_NONO = "none";
    public static final String STYLE_SOLID = "solid";
    public static final String STYLE_DOTTED = "dotted";
    public static final String STYLE_DASHED = "dashed";
    public static final String STYLE_DOUBLE = "double";
    public static final String STYLE_RIDGE = "ridge";
    public static final String STYLE_GROOVE = "groove";
    public static final String STYLE_INSET = "inset";
    public static final String STYLE_OUTSET = "outset";
    public static final int LINE_STYLE_SOLID = 1;
    public static final int LINE_STYLE_DOTTED = 3;
    public static final int LINE_STYLE_DASHED = 2;
    public static final int LINE_STYLE_NONE = 0;
    public static final int LINE_STYLE_DOUBLE = -2;
    public static final int LINE_STYLE_RIDGE = -3;
    public static final int LINE_STYLE_GROOVE = -4;
    public static final int LINE_STYLE_INSET = -5;
    public static final int LINE_STYLE_OUTSET = -6;
    public String bottomWidth;
    public String bottomStyle;
    public int bottomColor;
    public String topWidth;
    public String topStyle;
    public int topColor;
    public String leftWidth;
    public String leftStyle;
    public int leftColor;
    public String rightWidth;
    public String rightStyle;
    public int rightColor;
    protected int i_bottom_style;
    protected int i_bottom_width = 1;
    protected int i_top_style;
    protected int i_top_width = 1;
    protected int i_left_style;
    protected int i_left_width = 1;
    protected int i_right_style;
    protected int i_right_width = 1;
    private static final HashMap<String, Integer> styleMap = new HashMap();
    private static final HashMap<String, Integer> widthMap = new HashMap();
    private static final double EPS = 1.0E-10;
    protected int leftGap;
    protected int rightGap;
    protected int bottomGap;
    protected int topGap;
    private static final HashMap<String, Integer> commonCacheWidthMap;

    static {
        styleMap.put(STYLE_SOLID, 1);
        styleMap.put(STYLE_DOTTED, 3);
        styleMap.put(STYLE_DASHED, 2);
        styleMap.put(STYLE_DOUBLE, -2);
        styleMap.put(STYLE_RIDGE, -3);
        styleMap.put(STYLE_GROOVE, -4);
        styleMap.put(STYLE_INSET, -5);
        styleMap.put(STYLE_OUTSET, -6);
        styleMap.put(STYLE_NONO, 0);
        widthMap.put("thin", 1);
        widthMap.put("medium", 2);
        widthMap.put("thick", 3);
        commonCacheWidthMap = new HashMap();
    }

    public static void cleanWidthCache() {
        commonCacheWidthMap.clear();
    }

    public abstract Insets getTrueBorderInsets();

    public abstract Insets getBorderInsets();

    public abstract void setPaddingInsets(Insets var1);

    protected int getBorderStyle(Object obj) {
        Integer retValue = styleMap.get(obj);
        if (retValue == null) {
            return 1;
        }
        return retValue;
    }

    protected int getBorderWidth(Object obj) {
        String[] rt;
        Integer retValue = widthMap.get(obj);
        if (retValue != null) {
            return retValue;
        }
        retValue = commonCacheWidthMap.get(obj);
        if (retValue != null) {
            return retValue;
        }
        if (obj instanceof String && (rt = DEUtil.splitString((String)((String)obj)))[0] != null && DEUtil.isValidNumber((String)rt[0])) {
            double w = DEUtil.convertoToPixel((Object)new DimensionValue(Double.parseDouble(rt[0]), rt[1]));
            if (w <= 1.0E-10) {
                return 0;
            }
            int cw = Math.max(1, (int)w);
            commonCacheWidthMap.put((String)obj, cw);
            return cw;
        }
        return 1;
    }

    public int getLeftBorderStyle() {
        return this.getBorderStyle(this.leftStyle);
    }

    public int getRightBorderStyle() {
        return this.getBorderStyle(this.rightStyle);
    }

    public int getTopBorderStyle() {
        return this.getBorderStyle(this.topStyle);
    }

    public int getBottomBorderStyle() {
        return this.getBorderStyle(this.bottomStyle);
    }

    public int getLeftBorderWidth() {
        return this.getBorderWidth(this.leftWidth);
    }

    public int getRightBorderWidth() {
        return this.getBorderWidth(this.rightWidth);
    }

    public int getTopBorderWidth() {
        return this.getBorderWidth(this.topWidth);
    }

    public int getBottomBorderWidth() {
        return this.getBorderWidth(this.bottomWidth);
    }

    public int getLeftBorderColor() {
        return this.leftColor;
    }

    public int getRightBorderColor() {
        return this.rightColor;
    }

    public int getTopBorderColor() {
        return this.topColor;
    }

    public int getBottomBorderColor() {
        return this.bottomColor;
    }
}

