/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportEditorInput;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.editors.IPathEditorInputFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class EditorUtil {
    public static void openEditor(Object adaptable, File target, String editorId) throws PartInitException {
        IWorkbenchPage page;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench == null ? null : workbench.getActiveWorkbenchWindow();
        IWorkbenchPage iWorkbenchPage = page = window == null ? null : window.getActivePage();
        if (page != null) {
            IFile file;
            ReportEditorInput input = null;
            Object adapter = Platform.getAdapterManager().getAdapter(adaptable, IPathEditorInputFactory.class);
            if (adapter instanceof IPathEditorInputFactory && (file = (IFile)(input = ((IPathEditorInputFactory)adapter).create((IPath)new Path(target.getAbsolutePath()))).getAdapter(IFile.class)) != null) {
                try {
                    file.refreshLocal(2, null);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            if (input == null) {
                input = new ReportEditorInput(target);
            }
            page.openEditor((IEditorInput)input, editorId, true);
        }
    }

    public static File convertToFile(URL url) throws IOException {
        if (url == null) {
            throw new IOException(Messages.getString((String)"ResourceAction.ConvertToFile.URLIsNull"));
        }
        URL fileURL = FileLocator.toFileURL((URL)url);
        Path path = new Path(fileURL.getPath());
        String ref = fileURL.getRef();
        String fullPath = path.toFile().getAbsolutePath();
        if (ref != null) {
            ref = "#" + ref;
            if (path.toString().endsWith("/")) {
                return path.append(ref).toFile();
            }
            fullPath = String.valueOf(fullPath) + ref;
        }
        return new File(fullPath);
    }
}

