/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.birt.core.util.CommonUtil;
import org.eclipse.birt.report.model.util.XMLParserPool;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class XMLParserPoolImpl
implements XMLParserPool {
    private static final int SAXPARSER_DEFAULT_SIZE = 300;
    private static Logger logger = Logger.getLogger(XMLParserPoolImpl.class.getName());
    private final Map<Set<?>, List<SAXParser>> parserCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SAXParser get(Map<String, ?> properties) throws ParserConfigurationException, SAXException {
        HashSet<String> keys = null;
        SAXParser parser = null;
        if (properties != null) {
            keys = new HashSet<String>(properties.keySet());
        }
        XMLParserPoolImpl xMLParserPoolImpl = this;
        synchronized (xMLParserPoolImpl) {
            List<SAXParser> list = this.parserCache.get(keys);
            if (list != null) {
                int size = list.size();
                if (size > 0) {
                    parser = list.remove(size - 1);
                }
            } else {
                this.parserCache.put(keys, new ArrayList());
            }
        }
        if (parser == null) {
            parser = this.createParser(properties);
        }
        if (properties != null) {
            for (Map.Entry<String, ?> entry : properties.entrySet()) {
                parser.getXMLReader().setProperty(entry.getKey(), entry.getValue());
            }
        }
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void release(SAXParser parser, Map<String, ?> properties) {
        assert (parser != null);
        Set<String> keys = null;
        if (properties != null) {
            keys = properties.keySet();
        }
        try {
            XMLReader reader = parser.getXMLReader();
            if (keys != null && reader != null) {
                for (String key : keys) {
                    reader.setProperty(key, null);
                }
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        parser.reset();
        XMLParserPoolImpl xMLParserPoolImpl = this;
        synchronized (xMLParserPoolImpl) {
            List<SAXParser> list = this.parserCache.get(keys);
            int currentSize = list.size();
            if (currentSize < 300) {
                list.add(parser);
            }
        }
    }

    private SAXParser createParser(Map<String, ?> properties) throws ParserConfigurationException, SAXException {
        SAXParser parser = CommonUtil.createSAXParser();
        logger.log(Level.FINEST, "created a new SAX parser");
        return parser;
    }
}

