/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.parser.CompatibleLibraryStylesState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ModuleState;
import org.eclipse.birt.report.model.parser.ParametersState;
import org.eclipse.birt.report.model.parser.PropertyState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.LibraryUtil;
import org.xml.sax.SAXException;

public class LibraryState
extends ModuleState {
    public LibraryState(ModuleParserHandler theHandler) {
        super(theHandler);
    }

    @Override
    public void end() throws SAXException {
        if (this.handler.versionNumber >= 3021600) {
            super.end();
            return;
        }
        Library library = (Library)this.getElement();
        Object themeObj = this.getElement().getLocalProperty(this.module, "theme");
        if (themeObj != null) {
            return;
        }
        Theme theme = ((Library)this.module).findNativeTheme(ModelMessages.getMessage("Theme.defaultThemeName"));
        if (theme == null) {
            theme = new Theme(ModelMessages.getMessage("Theme.defaultThemeName"));
            LibraryUtil.insertCompatibleThemeToLibrary(library, theme);
            this.handler.unhandleIDElements.add(theme);
            library.setProperty("theme", (Object)new ElementRefValue(null, theme));
        }
        super.end();
    }

    @Override
    public AbstractParseState startElement(String tagName) {
        if (this.handler.isReadOnlyModuleProperties) {
            return super.startElement(tagName);
        }
        if (tagName.equalsIgnoreCase("translations")) {
            return new ModuleState.TranslationsState();
        }
        if (tagName.equalsIgnoreCase("parameters")) {
            return new ParametersState(this.handler, this.getElement(), 1);
        }
        if (tagName.equalsIgnoreCase("data-sources")) {
            return new ModuleState.DataSourcesState(this.handler, this.getElement(), 2);
        }
        if (tagName.equalsIgnoreCase("data-sets")) {
            return new ModuleState.DataSetsState(this.handler, this.getElement(), 3);
        }
        if (tagName.equalsIgnoreCase("themes")) {
            return new ModuleState.ThemesState(this.handler, this.getElement(), 0);
        }
        if (tagName.equalsIgnoreCase("styles") && this.handler.versionNumber < 3000000) {
            return new CompatibleLibraryStylesState(this.handler, this.getElement(), 0);
        }
        if (tagName.equalsIgnoreCase("page-setup")) {
            return new ModuleState.PageSetupState(this.handler, this.getElement(), 4);
        }
        if (tagName.equalsIgnoreCase("components")) {
            return new ModuleState.ComponentsState(this.handler, this.getElement(), 5);
        }
        if (tagName.equalsIgnoreCase("property")) {
            return new PropertyState(this.handler, this.getElement());
        }
        if (tagName.equalsIgnoreCase("cubes")) {
            return new ModuleState.CubesState(this.handler, this.getElement(), 6);
        }
        return super.startElement(tagName);
    }
}

