/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements.strategy;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.extension.IStyleDeclaration;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.PropertySearchStrategy;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.MultiViews;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.strategy.ReportItemPropSearchStrategy;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.SystemPropertyDefn;

public class ExtendedItemPropSearchStrategy
extends ReportItemPropSearchStrategy {
    private static Logger logger = Logger.getLogger(ExtendedItemPropSearchStrategy.class.getName());
    protected static final Set<Integer> hostViewRelatedProps;
    private static final ExtendedItemPropSearchStrategy instance;

    static {
        HashSet<Integer> tmpSet = new HashSet<Integer>();
        tmpSet.add("display".hashCode());
        tmpSet.add("masterPage".hashCode());
        tmpSet.add("pageBreakBefore".hashCode());
        tmpSet.add("pageBreakAfter".hashCode());
        tmpSet.add("pageBreakInside".hashCode());
        tmpSet.add("showIfBlank".hashCode());
        tmpSet.add("toc".hashCode());
        tmpSet.add("bookmark".hashCode());
        tmpSet.add("visibility".hashCode());
        tmpSet.add("allowExport".hashCode());
        tmpSet.add("zIndex".hashCode());
        hostViewRelatedProps = Collections.unmodifiableSet(tmpSet);
        instance = new ExtendedItemPropSearchStrategy();
    }

    protected ExtendedItemPropSearchStrategy() {
    }

    public static PropertySearchStrategy getInstance() {
        return instance;
    }

    @Override
    public Object getPropertyFromSelfSelector(Module module, DesignElement element, ElementPropertyDefn prop, PropertySearchStrategy.PropertyValueInfo valueInfo) {
        String selector;
        ExtendedItem extendedItem = (ExtendedItem)element;
        Object value = null;
        Object selectorValue = null;
        ExtensionElementDefn elementDefn = extendedItem.getExtDefn();
        if (elementDefn != null && (selectorValue = this.getPropertyFromSelector(module, extendedItem, prop, selector = extendedItem.getExtDefn().getSelector(), valueInfo)) != null) {
            if (value == null) {
                value = selectorValue;
            }
            if (valueInfo == null) {
                return value;
            }
        }
        if ((selectorValue = this.getPropertyFromPredefinedStyles(module, extendedItem, prop, valueInfo)) != null) {
            if (value == null) {
                value = selectorValue;
            }
            if (valueInfo == null) {
                return value;
            }
        }
        return value;
    }

    private Object getPropertyFromPredefinedStyles(Module module, ExtendedItem extendedItem, ElementPropertyDefn prop, PropertySearchStrategy.PropertyValueInfo valueInfo) {
        List<Object> predefinedStyles = extendedItem.getReportItemDefinedSelectors(module);
        Object value = null;
        if (predefinedStyles == null || predefinedStyles.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < predefinedStyles.size()) {
            Object selectorValue;
            Object predefinedStyle = predefinedStyles.get(i);
            if (predefinedStyle instanceof String) {
                String styleName = (String)predefinedStyle;
                selectorValue = this.getPropertyFromSelector(module, extendedItem, prop, styleName, valueInfo);
                if (selectorValue != null) {
                    if (value == null) {
                        value = selectorValue;
                    }
                    if (valueInfo == null) {
                        return value;
                    }
                }
            } else if (predefinedStyle instanceof IStyleDeclaration) {
                IStyleDeclaration style = (IStyleDeclaration)predefinedStyle;
                if (valueInfo != null) {
                    Style createdStyle = new Style(style.getName());
                    module.makeUniqueName(createdStyle);
                    this.copyValues(module, createdStyle, style);
                    valueInfo.addSelectorStyle(createdStyle);
                }
                if ((selectorValue = style.getProperty(prop.getName())) != null) {
                    try {
                        selectorValue = prop.validateValue(module, null, selectorValue);
                        if (selectorValue != null) {
                            if (value == null) {
                                value = selectorValue;
                            }
                            if (valueInfo == null) {
                                return value;
                            }
                        }
                    }
                    catch (PropertyValueException e) {
                        logger.log(Level.WARNING, "property( " + prop.getName() + " ) value " + value + "is invalid");
                    }
                }
            } else assert (false);
            ++i;
        }
        return null;
    }

    private void copyValues(Module module, StyleElement target, IStyleDeclaration source) {
        IElementDefn styleDefn = MetaDataDictionary.getInstance().getStyle();
        List<IElementPropertyDefn> props = styleDefn.getProperties();
        int i = 0;
        while (i < props.size()) {
            ElementPropertyDefn prop = (ElementPropertyDefn)props.get(i);
            if (prop.isStyleProperty()) {
                Object value = source.getProperty(prop.getName());
                try {
                    value = prop.validateValue(module, target, value);
                    target.setProperty(prop, value);
                }
                catch (PropertyValueException e) {
                    logger.log(Level.WARNING, "property( " + prop.getName() + " ) value " + value + "is invalid");
                }
            }
            ++i;
        }
    }

    @Override
    protected Object getPropertyFromSelf(Module module, DesignElement element, ElementPropertyDefn prop) {
        if (!(element.getContainer() instanceof MultiViews)) {
            return super.getPropertyFromSelf(module, element, prop);
        }
        String propName = prop.getName();
        if (!ExtendedItemPropSearchStrategy.isDataBindingProperty(element, propName) && !ExtendedItemPropSearchStrategy.isHostViewProperty(element, propName)) {
            return super.getPropertyFromSelf(module, element, prop);
        }
        DesignElement grandContainer = element.getContainer().getContainer();
        if (grandContainer == null) {
            return super.getPropertyFromSelf(module, element, prop);
        }
        ElementPropertyDefn grandPropDefn = grandContainer.getPropertyDefn(prop.getName());
        if (grandPropDefn != null && prop.getTypeCode() == grandPropDefn.getTypeCode()) {
            return grandContainer.getProperty(module, grandPropDefn);
        }
        return super.getPropertyFromSelf(module, element, prop);
    }

    private static Set<Integer> getHostViewProperties(DesignElement tmpElement) {
        if (tmpElement instanceof ReportItem) {
            return hostViewRelatedProps;
        }
        return Collections.emptySet();
    }

    public static boolean isHostViewProperty(DesignElement element, String propName) {
        if (!(element instanceof ExtendedItem) || StringUtil.isBlank(propName)) {
            return false;
        }
        return ExtendedItemPropSearchStrategy.getHostViewProperties(element).contains(propName.hashCode());
    }

    @Override
    protected Object getNonIntrinsicPropertyFromElement(Module module, DesignElement element, ElementPropertyDefn prop) {
        ExtendedItem extendedItem = (ExtendedItem)element;
        ElementPropertyDefn propDefn = extendedItem.getPropertyDefn(prop.getName());
        if (propDefn == null) {
            return null;
        }
        if (!propDefn.enableContextSearch()) {
            return super.getNonIntrinsicPropertyFromElement(module, element, prop);
        }
        IReportItem reportItem = extendedItem.getExtendedElement();
        if (reportItem != null) {
            return reportItem.getProperty(prop.getName());
        }
        return null;
    }

    public Object getMetaFactoryProperty(Module module, DesignElement element, ElementPropertyDefn prop) {
        assert (prop.isSystemProperty() && ((SystemPropertyDefn)prop).enableContextSearch());
        return super.getNonIntrinsicPropertyFromElement(module, element, prop);
    }

    @Override
    protected DesignElement getStyleContainer(DesignElement designElement) {
        DesignElement tmpContainer = designElement.getContainer();
        if (tmpContainer == null || !(tmpContainer instanceof MultiViews)) {
            return tmpContainer;
        }
        if ((tmpContainer = tmpContainer.getContainer()) == null) {
            return null;
        }
        return tmpContainer.getContainer();
    }
}

