/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.RunningAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalRunningCount
extends AggrFunction {
    public String getName() {
        return "RUNNINGCOUNT";
    }

    public int getType() {
        return 1;
    }

    public int getDataType() {
        return 2;
    }

    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, true, true, SupportedDataTypes.CALCULATABLE, "")};
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    public String getDescription() {
        return Messages.getString("TotalRunningCount.description");
    }

    public String getDisplayName() {
        return Messages.getString("TotalRunningCount.displayName");
    }

    private static class MyAccumulator
    extends RunningAccumulator {
        private int count;
        boolean countByColumn = true;

        private MyAccumulator() {
        }

        public void start() throws DataException {
            this.count = 0;
        }

        public void onRow(Object[] args) throws DataException {
            if (!this.countByColumn || args == null || args.length == 0) {
                if (this.countByColumn) {
                    this.countByColumn = false;
                }
                ++this.count;
            } else if (args.length > 0 && args[0] != null) {
                ++this.count;
            }
        }

        public Object getValue() throws DataException {
            return this.count;
        }
    }
}

