/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.CellBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportComponentEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportContainerEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.CellFigure;
import org.eclipse.birt.report.designer.internal.ui.util.bidi.BidiUIUtils;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.CrosstabCellEditPart;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editpolicies.VirtualCrosstabCellFlowLayoutEditPolicy;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.VirtualCrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.internal.ui.views.provider.CrosstabPropertyHandleWrapper;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.draw2d.Border;
import org.eclipse.gef.EditPolicy;

public class VirtualCellEditPart
extends CrosstabCellEditPart {
    public VirtualCellEditPart(Object model) {
        super(model);
    }

    @Override
    public void refreshFigure() {
        CellBorder cborder = new CellBorder();
        if (this.getFigure().getBorder() instanceof CellBorder) {
            cborder.setBorderInsets(((CellBorder)this.getFigure().getBorder()).getBorderInsets());
        }
        this.initEmptyBorder(cborder);
        this.getFigure().setBorder((Border)cborder);
        this.updateBlankString();
        ((CellFigure)this.getFigure()).setDirectionRTL(BidiUIUtils.INSTANCE.isDirectionRTL(this.getModel()));
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ReportComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new VirtualCrosstabCellFlowLayoutEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new ReportContainerEditPolicy());
    }

    public void updateBlankString() {
        int type = ((VirtualCrosstabCellAdapter)this.getCrosstabCellAdapter()).getType();
        switch (type) {
            case 1: {
                ((CellFigure)this.getFigure()).setBlankString(Messages.getString("Blank.text.column"));
                break;
            }
            case 0: {
                ((CellFigure)this.getFigure()).setBlankString(Messages.getString("Blank.text.row"));
                break;
            }
            case 2: {
                ((CellFigure)this.getFigure()).setBlankString(Messages.getString("Blank.text.measure"));
                break;
            }
            default: {
                ((CellFigure)this.getFigure()).setBlankString(null);
            }
        }
    }

    private void initEmptyBorder(CellBorder cborder) {
        cborder.bottomStyle = "none";
        cborder.topStyle = "none";
        cborder.leftStyle = "none";
        cborder.rightStyle = "none";
    }

    @Override
    protected List getHandleList() {
        return super.getHandleList();
    }

    @Override
    public boolean isinterestSelection(Object object) {
        if (object instanceof VirtualCrosstabCellAdapter && object == this.getModel()) {
            return true;
        }
        if (object instanceof CrosstabPropertyHandleWrapper) {
            PropertyHandle property = ((CrosstabPropertyHandleWrapper)object).getModel();
            if ("rows".equals(property.getPropertyDefn().getName()) && ((VirtualCrosstabCellAdapter)this.getCrosstabCellAdapter()).getType() == 0) {
                return true;
            }
            if ("columns".equals(property.getPropertyDefn().getName()) && ((VirtualCrosstabCellAdapter)this.getCrosstabCellAdapter()).getType() == 1) {
                return true;
            }
            if ("measures".equals(property.getPropertyDefn().getName()) && ((VirtualCrosstabCellAdapter)this.getCrosstabCellAdapter()).getType() == 2) {
                return true;
            }
        }
        return false;
    }
}

