/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model.schematic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.core.model.ITableAdapterHelper;
import org.eclipse.birt.report.designer.core.model.ReportItemtHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.CellHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.ColumnHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.RowHandleAdapter;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.draw2d.geometry.Dimension;

public class TableHandleAdapter
extends ReportItemtHandleAdapter {
    private static final String TRANS_LABEL_INSERT_ROW = Messages.getString("TableHandleAdapter.transLabel.insertRow");
    private static final String NAME_NULL = "";
    private static final String NAME_DETAIL = Messages.getString("TableHandleAdapter.name.detail");
    private static final String NAME_FOOTER = Messages.getString("TableHandleAdapter.name.footer");
    private static final String NAME_HEADRER = Messages.getString("TableHandleAdapter.name.header");
    private static final String TRANS_LABEL_NOT_INCLUDE = Messages.getString("TableHandleAdapter.transLabel.notInclude");
    private static final String TRANS_LABEL_INCLUDE = Messages.getString("TableHandleAdapter.transLabel.include");
    private static final String TRANS_LABEL_INSERT_GROUP = Messages.getString("TableHandleAdapter.transLabel.insertGroup");
    private static final String TRANS_LABEL_SPLIT_CELLS = Messages.getString("TableHandleAdapter.transLabel.splitCells");
    private static final String TRANS_LABEL_DELETE_ROW = Messages.getString("TableHandleAdapter.transLabel.deleteRow");
    private static final String TRANS_LABEL_DELETE_ROWS = Messages.getString("TableHandleAdapter.transLabel.deleteRows");
    private static final String TRANS_LABEL_DELETE_COLUMN = Messages.getString("TableHandleAdapter.transLabel.deleteColumn");
    private static final String TRANS_LABEL_DELETE_COLUMNS = Messages.getString("TableHandleAdapter.transLabel.deleteColumns");
    private static final String TRANS_LABEL_INSERT_COLUMN = Messages.getString("TableHandleAdapter.transLabel.insertColumn");
    private static final String TRANS_LABEL_DELETE_GROUP = Messages.getString("TableHandleAdapter.transLable.deleteGroup");
    public static final int HEADER = 0;
    public static final int DETAIL = 2;
    public static final int FOOTER = 3;
    public static final String TABLE_HEADER = "H";
    public static final String TABLE_FOOTER = "F";
    public static final String TABLE_DETAIL = "D";
    public static final String TABLE_GROUP_HEADER = "gh";
    public static final String TABLE_GROUP_FOOTER = "gf";
    public static final String DEFAULT_WIDTH = "100.0%";
    private HashMap rowInfo = new HashMap();
    private List rows = new ArrayList();

    public TableHandleAdapter(ReportItemHandle table, IModelAdapterHelper mark) {
        super(table, mark);
    }

    @Override
    public List getChildren() {
        ArrayList children = new ArrayList();
        SlotHandle header = this.getTableHandle().getHeader();
        Iterator headerIter = header.iterator();
        while (headerIter.hasNext()) {
            children.addAll(((RowHandle)headerIter.next()).getCells().getContents());
        }
        SlotHandle group = this.getTableHandle().getGroups();
        for (TableGroupHandle tableGroups : group) {
            SlotHandle groupHeaders = tableGroups.getHeader();
            Iterator groupHeaderIter = groupHeaders.iterator();
            while (groupHeaderIter.hasNext()) {
                children.addAll(((RowHandle)groupHeaderIter.next()).getCells().getContents());
            }
        }
        SlotHandle detail = this.getTableHandle().getDetail();
        Iterator detailIter = detail.iterator();
        while (detailIter.hasNext()) {
            children.addAll(((RowHandle)detailIter.next()).getCells().getContents());
        }
        ListIterator groupIter = group.getContents().listIterator(group.getCount());
        while (groupIter.hasPrevious()) {
            TableGroupHandle tableGroups = (TableGroupHandle)groupIter.previous();
            SlotHandle groupFooters = tableGroups.getFooter();
            Iterator groupFooterIter = groupFooters.iterator();
            while (groupFooterIter.hasNext()) {
                children.addAll(((RowHandle)groupFooterIter.next()).getCells().getContents());
            }
        }
        SlotHandle footer = this.getTableHandle().getFooter();
        Iterator footerIter = footer.iterator();
        while (footerIter.hasNext()) {
            children.addAll(((RowHandle)footerIter.next()).getCells().getContents());
        }
        this.removePhantomCells(children);
        return children;
    }

    protected void removePhantomCells(List children) {
        ArrayList phantomCells = new ArrayList();
        for (Object cell : children) {
            CellHandleAdapter cellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(cell);
            if (cellAdapt.getRowNumber() != 0 && cellAdapt.getColumnNumber() != 0) continue;
            phantomCells.add(cell);
        }
        Iterator iter = phantomCells.iterator();
        while (iter.hasNext()) {
            children.remove(iter.next());
        }
    }

    protected void insertRowInfo(SlotHandle slotHandle, String displayName, String type) {
        for (RowHandle handle : slotHandle) {
            this.rows.add(handle);
            RowUIInfomation info = new RowUIInfomation(this.getColumnCount());
            info.setType(type);
            info.setRowDisplayName(displayName);
            info.addChildren(handle.getCells().getContents());
            this.rowInfo.put(handle, info);
        }
    }

    public List getRows() {
        if (this.checkDirty() || this.rowInfo.isEmpty()) {
            this.reload();
        }
        return this.rows;
    }

    protected void clearBuffer() {
        this.rowInfo.clear();
        this.rows.clear();
    }

    public void initRowsInfo() {
        this.clearBuffer();
        this.buildRowInfo();
        this.caleRowInfo(this.rows);
    }

    protected void buildRowInfo() {
        this.insertRowInfo(this.getTableHandle().getHeader(), TABLE_HEADER, TABLE_HEADER);
        SlotHandle groups = this.getTableHandle().getGroups();
        int number = 0;
        for (TableGroupHandle tableGroup : groups) {
            this.insertRowInfo(tableGroup.getHeader(), Integer.toString(++number), TABLE_GROUP_HEADER);
        }
        this.insertRowInfo(this.getTableHandle().getDetail(), TABLE_DETAIL, TABLE_DETAIL);
        number = groups.getCount();
        ListIterator itor = groups.getContents().listIterator(number);
        while (itor.hasPrevious()) {
            TableGroupHandle tableGroup;
            tableGroup = (TableGroupHandle)itor.previous();
            this.insertRowInfo(tableGroup.getFooter(), Integer.toString(number), TABLE_GROUP_FOOTER);
            --number;
        }
        this.insertRowInfo(this.getTableHandle().getFooter(), TABLE_FOOTER, TABLE_FOOTER);
    }

    protected void caleRowInfo(List children) {
        int size = children.size();
        int i = 0;
        while (i < size) {
            RowHandleAdapter adapt = HandleAdapterFactory.getInstance().getRowHandleAdapter(children.get(i));
            List cellChildren = adapt.getChildren();
            int len = cellChildren.size();
            RowUIInfomation info = (RowUIInfomation)this.rowInfo.get(children.get(i));
            int j = 0;
            while (j < len) {
                CellHandleAdapter cellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(cellChildren.get(j));
                int cellIndex = info.getAllChildren().indexOf(cellChildren.get(j));
                if (cellAdapt.getColumnSpan() != 1 && cellIndex + 2 <= info.getAllChildren().size() && cellIndex >= 0) {
                    this.fillRowInfoChildrenList(children.get(i), cellIndex + 2, cellAdapt.getColumnSpan() - 1, cellChildren.get(j));
                }
                if (cellAdapt.getRowSpan() != 1) {
                    int k = i + 1;
                    while (k < i + cellAdapt.getRowSpan()) {
                        if (cellIndex >= 0 && cellIndex + cellAdapt.getColumnSpan() <= info.getAllChildren().size()) {
                            this.fillRowInfoChildrenList(children.get(k), cellIndex + 1, cellAdapt.getColumnSpan(), cellChildren.get(j));
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void fillRowInfoChildrenList(Object row, int columnNumber, int colSpan, Object cell) {
        RowUIInfomation info = (RowUIInfomation)this.rowInfo.get(row);
        if (info == null) {
            return;
        }
        int i = 0;
        while (i < colSpan) {
            info.addChildren(cell, columnNumber + i - 1);
            ++i;
        }
    }

    public RowUIInfomation getRowInfo(Object row) {
        if (this.checkDirty()) {
            this.reload();
        }
        return (RowUIInfomation)this.rowInfo.get(row);
    }

    @Override
    public void reload() {
        super.reload();
        this.initRowsInfo();
        if (this.getModelAdaptHelper() != null) {
            this.getModelAdaptHelper().markDirty(false);
        }
    }

    public List getColumns() {
        return this.getTableHandle().getColumns().getContents();
    }

    public Object getRow(int i) {
        List list = this.getRows();
        if (i >= 1 && i <= list.size()) {
            return list.get(i - 1);
        }
        return null;
    }

    public Object getColumn(int i) {
        List list = this.getColumns();
        if (i >= 1 && i <= list.size()) {
            return list.get(i - 1);
        }
        return null;
    }

    public Object getCell(int rowNumber, int columnNumber, boolean bool) {
        Object obj = this.getRow(rowNumber);
        RowUIInfomation info = this.getRowInfo(obj);
        Object retValue = null;
        if (info != null && columnNumber >= 1 && info.getAllChildren().size() >= columnNumber) {
            retValue = info.getAllChildren().get(columnNumber - 1);
        }
        if (bool) {
            return retValue;
        }
        if (HandleAdapterFactory.getInstance().getCellHandleAdapter(retValue).getRowNumber() != rowNumber || HandleAdapterFactory.getInstance().getCellHandleAdapter(retValue).getColumnNumber() != columnNumber) {
            retValue = null;
        }
        return retValue;
    }

    public Object getCell(int i, int j) {
        return this.getCell(i, j, true);
    }

    public Dimension calculateSize() {
        if (!(this.getModelAdaptHelper() instanceof ITableAdapterHelper)) {
            return new Dimension();
        }
        ITableAdapterHelper tableHelper = (ITableAdapterHelper)this.getModelAdaptHelper();
        int columnCount = this.getColumnCount();
        int samColumnWidth = 0;
        int i = 0;
        while (i < columnCount) {
            samColumnWidth += tableHelper.caleVisualWidth(i + 1);
            ++i;
        }
        int rowCount = this.getRowCount();
        int samRowHeight = 0;
        int i2 = 0;
        while (i2 < rowCount) {
            samRowHeight += tableHelper.caleVisualHeight(i2 + 1);
            ++i2;
        }
        return new Dimension(samColumnWidth, samRowHeight).expand(tableHelper.getInsets().getWidth(), tableHelper.getInsets().getHeight());
    }

    public void ajustSize(Dimension size) throws SemanticException {
        if (this.isFixLayout()) {
            this.adjustFixSize(size);
        } else {
            this.adjustAutoSize(size);
        }
    }

    private boolean isFixLayout() {
        if (this.getHandle().getModuleHandle() instanceof ReportDesignHandle) {
            return "fixed layout".equals(((ReportDesignHandle)this.getHandle().getModuleHandle()).getLayoutPreference());
        }
        return false;
    }

    private void adjustFixSize(Dimension size) throws SemanticException {
        int i;
        int i2;
        int temp;
        if (!(this.getModelAdaptHelper() instanceof ITableAdapterHelper)) {
            return;
        }
        ITableAdapterHelper tableHelper = (ITableAdapterHelper)this.getModelAdaptHelper();
        int width = size.width - tableHelper.getInsets().getWidth();
        int height = size.height - tableHelper.getInsets().getHeight();
        int columnCount = this.getColumnCount();
        int rowCount = this.getRowCount();
        Dimension parentSize = new Dimension();
        int i3 = 0;
        while (i3 < columnCount) {
            temp = tableHelper.caleVisualWidth(i3 + 1);
            parentSize.width += temp;
            ++i3;
        }
        i3 = 0;
        while (i3 < rowCount) {
            temp = tableHelper.caleVisualHeight(i3 + 1);
            parentSize.height += temp;
            ++i3;
        }
        double[] columns = new double[columnCount];
        double[] rows = new double[rowCount];
        if (width >= 0) {
            int totalWidth = 0;
            i2 = 0;
            while (i2 < columnCount) {
                double columnWidth = tableHelper.caleVisualWidth(i2 + 1);
                columns[i2] = columnWidth / (double)parentSize.width * (double)width;
                if (Math.round(columns[i2]) < 1L) {
                    columns[i2] = 1.0;
                }
                totalWidth += (int)Math.round(columns[i2]);
                ++i2;
            }
            columns[0] = columns[0] + (double)width - (double)totalWidth;
            i2 = 0;
            while (i2 < columnCount) {
                HandleAdapterFactory.getInstance().getColumnHandleAdapter(this.getColumn(i2 + 1)).setWidth((int)Math.round(columns[i2]));
                ++i2;
            }
        } else if (size.width > 0) {
            i = 0;
            while (i < columnCount) {
                HandleAdapterFactory.getInstance().getColumnHandleAdapter(this.getColumn(i + 1)).setWidth(Math.round(1.0f));
                ++i;
            }
        }
        if (height >= 0) {
            int totalHeight = 0;
            i2 = 0;
            while (i2 < rowCount) {
                double rowHeight = tableHelper.caleVisualHeight(i2 + 1);
                rows[i2] = rowHeight / (double)parentSize.height * (double)height;
                if (Math.round(rows[i2]) < 1L) {
                    rows[i2] = 1.0;
                }
                totalHeight += (int)Math.round(rows[i2]);
                ++i2;
            }
            rows[0] = rows[0] + (double)height - (double)totalHeight;
            i2 = 0;
            while (i2 < rowCount) {
                HandleAdapterFactory.getInstance().getRowHandleAdapter(this.getRow(i2 + 1)).setHeight((int)Math.round(rows[i2]));
                ++i2;
            }
        } else if (size.height > 0) {
            i = 0;
            while (i < rowCount) {
                HandleAdapterFactory.getInstance().getRowHandleAdapter(this.getRow(i + 1)).setHeight(Math.round(1.0f));
                ++i;
            }
        }
        this.setSize(new Dimension(width, height));
    }

    private void adjustAutoSize(Dimension size) throws SemanticException {
        int i;
        if (!(this.getModelAdaptHelper() instanceof ITableAdapterHelper)) {
            return;
        }
        ITableAdapterHelper tableHelper = (ITableAdapterHelper)this.getModelAdaptHelper();
        int width = size.width;
        int height = size.height;
        size = size.shrink(width < 0 ? 0 : tableHelper.getInsets().getWidth(), height < 0 ? 0 : tableHelper.getInsets().getHeight());
        if (width >= 0) {
            int columnCount = this.getColumnCount();
            int samColumnWidth = 0;
            i = 0;
            while (i < columnCount) {
                if (i != columnCount - 1) {
                    samColumnWidth += tableHelper.caleVisualWidth(i + 1);
                }
                ++i;
            }
            int lastColumnWidth = size.width - samColumnWidth;
            if (lastColumnWidth < tableHelper.getMinWidth(columnCount)) {
                lastColumnWidth = tableHelper.getMinWidth(columnCount);
                HandleAdapterFactory.getInstance().getColumnHandleAdapter(this.getColumn(columnCount)).setWidth(lastColumnWidth);
            } else if (lastColumnWidth != tableHelper.caleVisualWidth(columnCount)) {
                HandleAdapterFactory.getInstance().getColumnHandleAdapter(this.getColumn(columnCount)).setWidth(lastColumnWidth);
            }
            width = samColumnWidth + lastColumnWidth;
        }
        if (height >= 0) {
            int rowCount = this.getRowCount();
            int samRowHeight = 0;
            i = 0;
            while (i < rowCount) {
                if (i != rowCount - 1) {
                    samRowHeight += tableHelper.caleVisualHeight(i + 1);
                }
                ++i;
            }
            int lastRowHeight = size.height - samRowHeight;
            if (lastRowHeight < tableHelper.getMinHeight(rowCount)) {
                lastRowHeight = tableHelper.getMinHeight(rowCount);
                HandleAdapterFactory.getInstance().getRowHandleAdapter(this.getRow(rowCount)).setHeight(lastRowHeight);
            } else if (lastRowHeight != tableHelper.caleVisualHeight(rowCount)) {
                HandleAdapterFactory.getInstance().getRowHandleAdapter(this.getRow(rowCount)).setHeight(lastRowHeight);
            }
            height = samRowHeight + lastRowHeight;
        }
        this.setSize(new Dimension(width, height).expand(width < 0 ? 0 : tableHelper.getInsets().getWidth(), height < 0 ? 0 : tableHelper.getInsets().getHeight()));
    }

    public int getMinHeight(int rowNumber) {
        return 23;
    }

    public int getMinWidth(int columnNumber) {
        return 20;
    }

    public Dimension getClientAreaSize() {
        if (this.getModelAdaptHelper() instanceof ITableAdapterHelper) {
            return ((ITableAdapterHelper)this.getModelAdaptHelper()).getClientAreaSize();
        }
        return new Dimension();
    }

    private TableHandle getTableHandle() {
        return (TableHandle)this.getHandle();
    }

    public String getDefinedWidth() {
        DimensionHandle handle = ((ReportItemHandle)this.getHandle()).getWidth();
        if (handle.getUnits() == null || handle.getUnits().length() == 0) {
            return DEFAULT_WIDTH;
        }
        if ("%".equals(handle.getUnits())) {
            return String.valueOf(handle.getMeasure()) + "%";
        }
        int px = (int)DEUtil.convertoToPixel(handle);
        if (px <= 0) {
            return null;
        }
        return String.valueOf(px);
    }

    public boolean isForceWidth() {
        DimensionHandle handle = ((ReportItemHandle)this.getHandle()).getWidth();
        return handle.isSet();
    }

    public int getDefaultWidth(int colNumber) {
        Dimension size = this.getDefaultSize();
        Object obj = this.getRow(1);
        if (obj == null) {
            return size.width;
        }
        int allNumbers = this.getColumnCount();
        if (allNumbers <= 0 || colNumber <= 0) {
            return size.width;
        }
        int width = size.width;
        int columnNumber = allNumbers;
        int i = 1;
        while (i < columnNumber + 1) {
            Object column = this.getColumn(i);
            ColumnHandleAdapter adapt = HandleAdapterFactory.getInstance().getColumnHandleAdapter(column);
            if (adapt.isCustomWidth()) {
                --allNumbers;
                width -= adapt.getWidth();
            }
            ++i;
        }
        if (colNumber == allNumbers) {
            return width / allNumbers + width % allNumbers;
        }
        return width / allNumbers;
    }

    public int getRowCount() {
        return this.getRows().size();
    }

    public int getColumnCount() {
        return this.getColumns().size();
    }

    public Object getDataSet() {
        return this.getTableHandle().getDataSet();
    }

    public void insertRow(int rowNumber, int parentRowNumber) throws SemanticException {
        this.transStar(TRANS_LABEL_INSERT_ROW);
        assert (rowNumber != 0);
        int realRowNumber = rowNumber > 0 ? parentRowNumber + rowNumber : parentRowNumber + rowNumber + 1;
        int shiftPos = rowNumber > 0 ? rowNumber : rowNumber + 1;
        RowHandle row = (RowHandle)this.getRow(parentRowNumber);
        RowHandleAdapter adapt = HandleAdapterFactory.getInstance().getRowHandleAdapter(row);
        RowHandle copy = (RowHandle)adapt.copy();
        RowUIInfomation rowInfo = this.getRowInfo(row);
        List rowList = rowInfo.getAllChildren();
        int rowSize = rowList.size();
        int i = 0;
        while (i < rowSize) {
            CellHandle parentCell = (CellHandle)rowList.get(i);
            CellHandle cell = this.getCellHandleCopy(parentCell);
            copy.getSlot(0).add((DesignElementHandle)cell);
            ++i;
        }
        SlotHandle parentHandle = row.getContainerSlotHandle();
        parentHandle.add((DesignElementHandle)copy);
        int pos = parentHandle.findPosn((DesignElementHandle)row);
        parentHandle.shift((DesignElementHandle)copy, pos + shiftPos);
        RowHandleAdapter copyAdapt = HandleAdapterFactory.getInstance().getRowHandleAdapter(copy);
        List copyChildren = copyAdapt.getChildren();
        if (this.getModelAdaptHelper() != null) {
            this.getModelAdaptHelper().markDirty(true);
        }
        RowUIInfomation info = this.getRowInfo(copy);
        List list = info.getAllChildren();
        ArrayList<Integer> temp = new ArrayList<Integer>();
        int size = list.size();
        ArrayList hasAdjust = new ArrayList();
        int i2 = 0;
        while (i2 < size) {
            Object fillCell = list.get(i2);
            CellHandleAdapter cellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(fillCell);
            if (cellAdapt.getRowNumber() != realRowNumber) {
                if (!hasAdjust.contains(fillCell)) {
                    cellAdapt.setRowSpan(cellAdapt.getRowSpan() + 1);
                    hasAdjust.add(fillCell);
                }
                temp.add(i2);
            }
            ++i2;
        }
        int copyRowSize = copyChildren.size();
        int i3 = 0;
        while (i3 < copyRowSize) {
            if (temp.contains(i3)) {
                ((CellHandle)copyChildren.get(i3)).drop();
            }
            ++i3;
        }
        this.transEnd();
    }

    public void insertRows(int rowCount, int baseRowNumber) throws SemanticException {
        this.transStar(TRANS_LABEL_INSERT_ROW);
        int absoluteCount = Math.abs(rowCount);
        int sign = rowCount / absoluteCount;
        int i = 0;
        while (i < absoluteCount) {
            this.insertRow(sign, baseRowNumber);
            ++i;
        }
        this.transEnd();
    }

    public void insertColumn(int columnNumber, int parentColumnNumber) throws SemanticException {
        this.transStar(TRANS_LABEL_INSERT_COLUMN);
        assert (columnNumber != 0);
        int realColumnNumber = columnNumber > 0 ? parentColumnNumber + columnNumber : parentColumnNumber + columnNumber + 1;
        int shiftPos = columnNumber > 0 ? columnNumber : columnNumber + 1;
        ColumnHandle column = (ColumnHandle)this.getColumn(parentColumnNumber);
        ColumnHandleAdapter adapt = HandleAdapterFactory.getInstance().getColumnHandleAdapter(column);
        ColumnHandle copy = (ColumnHandle)adapt.copy();
        int rowNumber = this.getRowCount();
        ArrayList<CellHandle> copyChildren = new ArrayList<CellHandle>();
        int i = 0;
        while (i < rowNumber) {
            RowUIInfomation rowInfo = this.getRowInfo(this.getRow(i + 1));
            List rowList = rowInfo.getAllChildren();
            CellHandle parentCell = (CellHandle)rowList.get(parentColumnNumber - 1);
            CellHandle cell = this.getCellHandleCopy(parentCell);
            copyChildren.add(cell);
            ++i;
        }
        int copyRowSize = copyChildren.size();
        int i2 = 0;
        while (i2 < copyRowSize) {
            RowHandle row = (RowHandle)this.getRow(i2 + 1);
            int number = this.getReallyRowNumber(row, realColumnNumber);
            row.getSlot(0).add((DesignElementHandle)((CellHandle)copyChildren.get(i2)), number - 1);
            ++i2;
        }
        SlotHandle parentHandle = column.getContainerSlotHandle();
        parentHandle.add((DesignElementHandle)copy);
        int pos = parentHandle.findPosn((DesignElementHandle)column);
        parentHandle.shift((DesignElementHandle)copy, pos + shiftPos);
        ArrayList<Integer> temp = new ArrayList<Integer>();
        ArrayList hasAdjust = new ArrayList();
        this.reload();
        int i3 = 0;
        while (i3 < rowNumber) {
            RowUIInfomation rowInfo = this.getRowInfo(this.getRow(i3 + 1));
            List rowList = rowInfo.getAllChildren();
            Object fillCell = rowList.get(realColumnNumber - 1);
            CellHandleAdapter cellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(fillCell);
            if (cellAdapt.getColumnNumber() != realColumnNumber) {
                if (!hasAdjust.contains(fillCell)) {
                    cellAdapt.setColumnSpan(cellAdapt.getColumnSpan() + 1);
                    hasAdjust.add(fillCell);
                }
                temp.add(i3);
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < copyRowSize) {
            if (temp.contains(i3)) {
                ((CellHandle)copyChildren.get(i3)).drop();
            }
            ++i3;
        }
        this.transEnd();
    }

    private int getReallyRowNumber(RowHandle rowHandle, int number) {
        RowUIInfomation rowInfo = this.getRowInfo(rowHandle);
        int rowNumber = HandleAdapterFactory.getInstance().getRowHandleAdapter(rowHandle).getRowNumber();
        List rowList = rowInfo.getAllChildren();
        int retValue = number;
        ArrayList hasAdjust = new ArrayList();
        int i = 0;
        while (i < number - 1) {
            Object fillCell = rowList.get(i);
            CellHandleAdapter cellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(fillCell);
            if (hasAdjust.contains(fillCell)) {
                --retValue;
            } else {
                if (cellAdapt.getRowNumber() != rowNumber) {
                    --retValue;
                }
                hasAdjust.add(fillCell);
            }
            ++i;
        }
        return retValue;
    }

    public void insertColumns(int columnCount, int baseColumnNumber) throws SemanticException {
        this.transStar(TRANS_LABEL_INSERT_COLUMN);
        int absoluteCount = Math.abs(columnCount);
        int sign = columnCount / absoluteCount;
        int i = 0;
        while (i < absoluteCount) {
            this.insertColumn(sign, baseColumnNumber);
            ++i;
        }
        this.transEnd();
    }

    public void removeChild(Object model) throws SemanticException {
        assert (model instanceof DesignElementHandle);
        DesignElementHandle ele = (DesignElementHandle)model;
        ele.drop();
    }

    public void deleteColumn(int[] columns) throws SemanticException {
        if (columns == null) {
            return;
        }
        this.transStar(TRANS_LABEL_DELETE_COLUMNS);
        if (this.getColumnCount() == columns.length) {
            this.getHandle().drop();
            this.transEnd();
            return;
        }
        Arrays.sort(columns);
        ArrayList<Object> temp = new ArrayList<Object>();
        int len = columns.length;
        int i = 0;
        while (i < len) {
            temp.add(this.getColumn(columns[i]));
            ++i;
        }
        i = 0;
        while (i < len) {
            this.deleteColumn(HandleAdapterFactory.getInstance().getColumnHandleAdapter(temp.get(i)).getColumnNumber());
            ++i;
        }
        this.transEnd();
    }

    public void deleteColumn(int columnNumber) throws SemanticException {
        Object cell;
        this.transStar(TRANS_LABEL_DELETE_COLUMN);
        int rowCount = this.getRowCount();
        ColumnHandle column = (ColumnHandle)this.getColumn(columnNumber);
        ArrayList deleteCells = new ArrayList();
        int i = 0;
        while (i < rowCount) {
            Object row = this.getRow(i + 1);
            RowUIInfomation info = this.getRowInfo(row);
            deleteCells.add(info.getAllChildren().get(columnNumber - 1));
            ++i;
        }
        ArrayList trueDeleteCells = new ArrayList();
        int size = deleteCells.size();
        int i2 = 0;
        while (i2 < size) {
            Object cell2 = deleteCells.get(i2);
            CellHandleAdapter cellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(cell2);
            if (cellAdapt.getColumnNumber() == columnNumber && cellAdapt.getColumnSpan() == 1 && !trueDeleteCells.contains(cell2)) {
                trueDeleteCells.add(cell2);
            }
            ++i2;
        }
        ArrayList temp = new ArrayList();
        int i3 = 0;
        while (i3 < size) {
            cell = deleteCells.get(i3);
            if (!trueDeleteCells.contains(cell) && !temp.contains(cell)) {
                CellHandleAdapter cellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(cell);
                cellAdapt.setColumnSpan(cellAdapt.getColumnSpan() - 1);
                temp.add(cell);
            }
            ++i3;
        }
        size = trueDeleteCells.size();
        i3 = 0;
        while (i3 < size) {
            cell = (CellHandle)trueDeleteCells.get(i3);
            cell.drop();
            ++i3;
        }
        column.drop();
        this.transEnd();
        this.reload();
    }

    public void deleteRow(int[] rows) throws SemanticException {
        if (rows == null) {
            return;
        }
        this.transStar(TRANS_LABEL_DELETE_ROWS);
        if (this.getRowCount() == rows.length) {
            this.getHandle().drop();
            this.transEnd();
            return;
        }
        Arrays.sort(rows);
        ArrayList<Object> temp = new ArrayList<Object>();
        int len = rows.length;
        int i = 0;
        while (i < len) {
            temp.add(this.getRow(rows[i]));
            ++i;
        }
        i = len - 1;
        while (i >= 0) {
            this.deleteRow(HandleAdapterFactory.getInstance().getRowHandleAdapter(temp.get(i)).getRowNumber());
            --i;
        }
        this.transEnd();
    }

    public void deleteRow(int rowsNumber) throws SemanticException {
        this.transStar(TRANS_LABEL_DELETE_ROW);
        int rowCount = this.getRowCount();
        RowHandle row = (RowHandle)this.getRow(rowsNumber);
        RowHandleAdapter rowAdapt = HandleAdapterFactory.getInstance().getRowHandleAdapter(row);
        ArrayList temp = new ArrayList();
        RowHandle nextRow = null;
        ArrayList<ShiftNexRowInfo> shiftCellInfo = new ArrayList<ShiftNexRowInfo>();
        if (rowsNumber + 1 <= rowCount) {
            List trueChildren = rowAdapt.getChildren();
            int cellSize = trueChildren.size();
            nextRow = (RowHandle)this.getRow(rowsNumber + 1);
            RowUIInfomation nextRowInfo = this.getRowInfo(nextRow);
            List nextRowChildren = nextRowInfo.getAllChildren();
            int i = 0;
            while (i < cellSize) {
                Object cellHandle = trueChildren.get(i);
                CellHandleAdapter adapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(cellHandle);
                if (adapt.getRowSpan() != 1) {
                    int numberInfo = 0;
                    int index = nextRowChildren.indexOf(cellHandle);
                    int j = 0;
                    while (j < index) {
                        Object nextRowCell = nextRowChildren.get(j);
                        CellHandleAdapter nextRowCellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(nextRowCell);
                        if (nextRowCellAdapt.getRowNumber() == rowsNumber + 1 && !temp.contains(nextRowCell)) {
                            ++numberInfo;
                        }
                        temp.add(nextRowCell);
                        ++j;
                    }
                    shiftCellInfo.add(new ShiftNexRowInfo(numberInfo += shiftCellInfo.size(), cellHandle));
                }
                ++i;
            }
        }
        RowUIInfomation info = this.getRowInfo(row);
        List cells = info.getAllChildren();
        temp.clear();
        int cellSize = cells.size();
        int j = 0;
        while (j < cellSize) {
            Object cellHandle = cells.get(j);
            CellHandleAdapter adapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(cellHandle);
            if (adapt.getRowNumber() != rowsNumber && !temp.contains(cellHandle)) {
                adapt.setRowSpan(adapt.getRowSpan() - 1);
                temp.add(cellHandle);
            }
            ++j;
        }
        int i = 0;
        while (i < shiftCellInfo.size()) {
            ShiftNexRowInfo shiftInfo = (ShiftNexRowInfo)shiftCellInfo.get(i);
            CellHandleAdapter cellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(shiftInfo.cell);
            cellAdapt.setRowSpan(cellAdapt.getRowSpan() - 1);
            SlotHandle slotHandle = row.getCells();
            slotHandle.move((DesignElementHandle)shiftInfo.cell, (DesignElementHandle)nextRow, 0, shiftInfo.index);
            ++i;
        }
        row.drop();
        this.transEnd();
        this.reload();
    }

    public boolean canMerge(List list) {
        if (!this.getModuleHandle().canEdit()) {
            return false;
        }
        assert (list != null);
        int size = list.size();
        if (size <= 1) {
            return false;
        }
        RowUIInfomation rowInfo = this.getRowInfo(((CellHandle)list.get(0)).getContainer());
        if (rowInfo == null) {
            return false;
        }
        String first = rowInfo.getRowDisplayName();
        int i = 1;
        while (i < size) {
            CellHandle cell = (CellHandle)list.get(i);
            if (!cell.canDrop()) {
                return false;
            }
            RowUIInfomation info = this.getRowInfo(cell.getContainer());
            if (info == null) {
                return false;
            }
            String str = info.getRowDisplayName();
            if (!first.equals(str)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void splitCell(Object model) throws ContentException, NameException, SemanticException {
        RowHandle rowHandle;
        this.transStar(TRANS_LABEL_SPLIT_CELLS);
        assert (model instanceof CellHandle);
        CellHandle cellHandle = (CellHandle)model;
        CellHandleAdapter cellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(cellHandle);
        int rowNumber = cellAdapt.getRowNumber();
        int rowSpan = cellAdapt.getRowSpan();
        int colSpan = cellAdapt.getColumnSpan();
        if (colSpan != 1) {
            int index = this.getIndexofParent(cellHandle);
            rowHandle = (RowHandle)cellHandle.getContainer();
            int i = 1;
            while (i < colSpan) {
                rowHandle.addElement((DesignElementHandle)this.getCellHandleCopy(cellHandle), 0, i + index);
                ++i;
            }
        }
        if (rowSpan != 1) {
            int i = rowNumber + 1;
            while (i < rowNumber + rowSpan) {
                rowHandle = (RowHandle)this.getRow(i);
                int index = this.getIndexofParent(cellHandle);
                int j = 0;
                while (j < colSpan) {
                    rowHandle.addElement((DesignElementHandle)this.getCellHandleCopy(cellHandle), 0, j + index);
                    ++j;
                }
                ++i;
            }
        }
        cellAdapt.setRowSpan(1);
        cellAdapt.setColumnSpan(1);
        this.transEnd();
    }

    private int getIndexofParent(CellHandle cellHandle) {
        CellHandleAdapter cellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(cellHandle);
        RowUIInfomation info = this.getRowInfo(cellHandle.getContainer());
        List list = info.getAllChildren();
        int index = list.indexOf(cellHandle);
        ArrayList temp = new ArrayList();
        int number = 0;
        int j = 0;
        while (j < index) {
            CellHandleAdapter childCellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(list.get(j));
            if (childCellAdapt.getRowNumber() == cellAdapt.getRowNumber() && !temp.contains(list.get(j))) {
                ++number;
            }
            temp.add(list.get(j));
            ++j;
        }
        return number;
    }

    public CellHandle getCellHandleCopy(CellHandle cellHandle) throws SemanticException {
        if (cellHandle == null) {
            return null;
        }
        CellHandle cell = cellHandle.getElementFactory().newCell();
        Iterator iter = cellHandle.getPropertyIterator();
        while (iter.hasNext()) {
            PropertyHandle handle = (PropertyHandle)iter.next();
            if (handle.getDefn().getValueType() == 1) continue;
            String key = handle.getDefn().getName();
            if (!handle.isLocal() || "colSpan".equals(key) || "rowSpan".equals(key)) continue;
            cellHandle.copyPropertyTo(key, (DesignElementHandle)cell);
        }
        return cell;
    }

    public TableGroupHandle insertGroup() throws ContentException, NameException {
        if (DEUtil.getDataSetList((DesignElementHandle)this.getTableHandle()).isEmpty()) {
            return null;
        }
        this.transStar(TRANS_LABEL_INSERT_GROUP);
        RowHandle header = this.getTableHandle().getElementFactory().newTableRow();
        RowHandle footer = this.getTableHandle().getElementFactory().newTableRow();
        this.addCell(header);
        this.addCell(footer);
        TableGroupHandle groupHandle = this.getTableHandle().getElementFactory().newTableGroup();
        groupHandle.getSlot(0).add((DesignElementHandle)header);
        groupHandle.getSlot(1).add((DesignElementHandle)footer);
        SlotHandle handle = this.getTableHandle().getGroups();
        handle.add((DesignElementHandle)groupHandle);
        this.transEnd();
        return groupHandle;
    }

    public void removeGroup(Object group) throws SemanticException {
        this.transStar(TRANS_LABEL_DELETE_GROUP);
        ((RowHandle)group).getContainer().drop();
        if (this.getRows().size() == 0) {
            this.getHandle().drop();
        }
        this.transEnd();
    }

    protected void addCell(RowHandle handle) throws ContentException, NameException {
        int count = this.getColumnCount();
        int i = 0;
        while (i < count) {
            CellHandle cell = handle.getElementFactory().newCell();
            handle.addElement((DesignElementHandle)cell, 0);
            ++i;
        }
    }

    public void insertRowInSlotHandle(int id) throws ContentException, NameException {
        this.transStar(String.valueOf(TRANS_LABEL_INCLUDE) + TableHandleAdapter.getOperationName(id));
        RowHandle rowHandle = this.getTableHandle().getElementFactory().newTableRow();
        this.addCell(rowHandle);
        this.getTableHandle().getSlot(id).add((DesignElementHandle)rowHandle);
        this.transEnd();
    }

    public void deleteRowInSlotHandle(int id) throws SemanticException {
        this.transStar(String.valueOf(TRANS_LABEL_NOT_INCLUDE) + TableHandleAdapter.getOperationName(id));
        int[] rows = new int[]{};
        for (Object obj : this.getTableHandle().getSlot(id)) {
            RowHandleAdapter adapt = HandleAdapterFactory.getInstance().getRowHandleAdapter(obj);
            int lenegth = rows.length;
            int[] temp = new int[lenegth + 1];
            System.arraycopy(rows, 0, temp, 0, lenegth);
            temp[lenegth] = adapt.getRowNumber();
            rows = temp;
        }
        this.deleteRow(rows);
        this.transEnd();
    }

    protected static String getOperationName(int id) {
        switch (id) {
            case 0: {
                return NAME_HEADRER;
            }
            case 3: {
                return NAME_FOOTER;
            }
            case 2: {
                return NAME_DETAIL;
            }
        }
        return NAME_NULL;
    }

    public boolean hasSlotHandleRow(int id) {
        Iterator itor = this.getTableHandle().getSlot(id).iterator();
        return itor.hasNext();
    }

    @Override
    public void setSize(Dimension size) throws SemanticException {
        if (size.width >= 0) {
            MetricUtility.updateDimension(this.getReportItemHandle().getWidth(), size.width);
        }
        if (size.height >= 0 && this.isSupportHeight()) {
            MetricUtility.updateDimension(this.getReportItemHandle().getHeight(), size.height);
        }
    }

    public boolean isSupportHeight() {
        return false;
    }

    public static class RowUIInfomation {
        protected static final String GRID_ROW = "";
        private String type = "";
        private String rowDisplayName = "";
        Object[] cells = null;
        int[] infactAdd = new int[0];

        private RowUIInfomation(int columnMunber) {
            this.cells = new Object[columnMunber];
        }

        public String getRowDisplayName() {
            return this.rowDisplayName;
        }

        public void setRowDisplayName(String rowDisplayName) {
            this.rowDisplayName = rowDisplayName;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void addChildren(Object obj, int index) {
            int cellSize = this.cells.length;
            if (index >= cellSize) {
                return;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            if (this.cells[index] != null) {
                Object[] newArray = new Object[cellSize];
                int i = 0;
                while (i < cellSize) {
                    if (this.containIndex(i)) {
                        newArray[i] = this.cells[i];
                    } else if (this.cells[i] != null) {
                        list.add(this.cells[i]);
                    }
                    ++i;
                }
                newArray[index] = obj;
                int listSize = list.size();
                int i2 = 0;
                while (i2 < listSize) {
                    int j = 0;
                    while (j < cellSize) {
                        if (newArray[j] == null) {
                            newArray[j] = list.get(i2);
                            break;
                        }
                        ++j;
                    }
                    ++i2;
                }
                this.cells = newArray;
            } else {
                this.cells[index] = obj;
            }
            int lenegth = this.infactAdd.length;
            int[] temp = new int[lenegth + 1];
            System.arraycopy(this.infactAdd, 0, temp, 0, lenegth);
            temp[lenegth] = index;
            this.infactAdd = temp;
        }

        private boolean containIndex(int index) {
            int length = this.infactAdd.length;
            int i = 0;
            while (i < length) {
                if (this.infactAdd[i] == index) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void addChildren(Collection c) {
            Iterator itor = c.iterator();
            int cellSize = this.cells.length;
            block0: while (itor.hasNext()) {
                Object obj = itor.next();
                int i = 0;
                while (i < cellSize) {
                    if (this.cells[i] == null) {
                        this.cells[i] = obj;
                        continue block0;
                    }
                    ++i;
                }
            }
        }

        public List getAllChildren() {
            ArrayList<Object> retValue = new ArrayList<Object>();
            int cellSize = this.cells.length;
            int i = 0;
            while (i < cellSize) {
                retValue.add(this.cells[i]);
                ++i;
            }
            return retValue;
        }
    }

    static class ShiftNexRowInfo {
        protected int index;
        protected Object cell;

        public ShiftNexRowInfo(int index, Object cell) {
            this.index = index;
            this.cell = cell;
        }
    }
}

