/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel.handlers;

import java.util.Stack;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.ITaskOption;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.ir.ListGroupDesign;
import uk.co.spudsoft.birt.emitters.excel.BirtStyle;
import uk.co.spudsoft.birt.emitters.excel.EmitterServices;
import uk.co.spudsoft.birt.emitters.excel.HandlerState;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;
import uk.co.spudsoft.birt.emitters.excel.handlers.AbstractRealListHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.IHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.NestedTableHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.TopLevelContentHandler;

public class TopLevelListHandler
extends AbstractRealListHandler {
    private Stack<Integer> groupStarts;

    public TopLevelListHandler(Logger log, IHandler parent, IListContent list) {
        super(log, parent, list);
    }

    @Override
    public void startList(HandlerState state, IListContent list) throws BirtException {
        String password;
        this.log.debug("Call startList on ", this);
        super.startList(state, list);
        String name = state.correctSheetName(list.getName());
        if (name != null && !name.isEmpty()) {
            state.sheetName = name;
        }
        if ((password = EmitterServices.stringOption((ITaskOption)state.getRenderOptions(), (IContent)list, "ExcelEmitter.SheetProtectPassword", null)) != null && !password.isEmpty()) {
            state.sheetPassword = password;
        }
        BirtStyle birtStyle = new BirtStyle((IContent)list);
        this.log.debug("List Style: {}", birtStyle);
    }

    @Override
    public void startTable(HandlerState state, ITableContent table) throws BirtException {
        ++state.colNum;
        state.setHandler(new NestedTableHandler(this.log, this, table, 1));
        state.getHandler().startTable(state, table);
    }

    @Override
    public void startListGroup(HandlerState state, IListGroupContent group) throws BirtException {
        ListGroupDesign groupDesign;
        if (this.groupStarts == null) {
            this.groupStarts = new Stack();
        }
        this.groupStarts.push(state.rowNum);
        Object groupDesignObject = group.getGenerateBy();
        if (groupDesignObject instanceof ListGroupDesign && ("always".equals((groupDesign = (ListGroupDesign)groupDesignObject).getPageBreakBefore()) || "always-excluding-first".equals(groupDesign.getPageBreakBefore()) || "always".equals(groupDesign.getPageBreakAfter()) || "always-excluding-last".equals(groupDesign.getPageBreakAfter())) && group.getTOC() != null) {
            state.sheetName = state.correctSheetName(group.getTOC().toString());
        }
    }

    @Override
    public void startListBand(HandlerState state, IListBandContent band) throws BirtException {
        super.startListBand(state, band);
    }

    @Override
    public void endListGroup(HandlerState state, IListGroupContent group) throws BirtException {
        int start = this.groupStarts.pop();
        if (start < state.rowNum - 2) {
            boolean disableGrouping = false;
            if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)group, "ExcelEmitter.DisableGrouping", false)) {
                disableGrouping = true;
            }
            if (!disableGrouping) {
                state.currentSheet.groupRow(start, state.rowNum - 2);
            }
        }
    }

    @Override
    public void emitText(HandlerState state, ITextContent text) throws BirtException {
        state.setHandler(new TopLevelContentHandler(state.getEmitter(), this.log, this));
        state.getHandler().emitText(state, text);
    }

    @Override
    public void emitData(HandlerState state, IDataContent data) throws BirtException {
        state.setHandler(new TopLevelContentHandler(state.getEmitter(), this.log, this));
        state.getHandler().emitData(state, data);
    }

    @Override
    public void emitLabel(HandlerState state, ILabelContent label) throws BirtException {
        state.setHandler(new TopLevelContentHandler(state.getEmitter(), this.log, this));
        state.getHandler().emitLabel(state, label);
    }

    @Override
    public void emitAutoText(HandlerState state, IAutoTextContent autoText) throws BirtException {
        state.setHandler(new TopLevelContentHandler(state.getEmitter(), this.log, this));
        state.getHandler().emitAutoText(state, autoText);
    }

    @Override
    public void emitForeign(HandlerState state, IForeignContent foreign) throws BirtException {
        state.setHandler(new TopLevelContentHandler(state.getEmitter(), this.log, this));
        state.getHandler().emitForeign(state, foreign);
    }

    @Override
    public void emitImage(HandlerState state, IImageContent image) throws BirtException {
        state.setHandler(new TopLevelContentHandler(state.getEmitter(), this.log, this));
        state.getHandler().emitImage(state, image);
    }
}

