/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.dnd;

import java.util.ArrayList;
import org.eclipse.birt.report.data.adapter.api.LinkedDataSetUtil;
import org.eclipse.birt.report.designer.core.mediator.IMediatorRequest;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.dnd.DNDLocation;
import org.eclipse.birt.report.designer.internal.ui.dnd.IDropAdapter;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionConverter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.dialog.GroupDialog;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.SimpleCubeBuilder;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.CrosstabCellEditPart;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.CrosstabTableEditPart;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.VirtualCrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.plugin.CrosstabPlugin;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularDimensionHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.birt.report.model.api.olap.TabularMeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.TabularMeasureHandle;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DataColumnXTabDropAdapter
implements IDropAdapter {
    public int canDrop(Object transfer, Object target, int operation, DNDLocation location) {
        if (!this.isDataColumn(transfer)) {
            return 0;
        }
        DesignElementHandle handle = this.getExtendedItemHandle(target);
        if (handle instanceof ReportItemHandle && handle.getProperty("cube") == null && !LinkedDataSetUtil.bindToLinkedDataSet((ReportItemHandle)((ReportItemHandle)handle)) && (target instanceof CrosstabTableEditPart || target instanceof CrosstabCellEditPart)) {
            return 1;
        }
        return 0;
    }

    private boolean isDataColumn(Object transfer) {
        if (transfer instanceof Object[]) {
            Object[] transfers = (Object[])transfer;
            int i = 0;
            while (i < transfers.length) {
                if (!this.isDataColumn(transfers[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return transfer instanceof ResultSetColumnHandle;
    }

    public boolean performDrop(Object transfer, Object target, int operation, DNDLocation location) {
        DesignElementHandle handle = this.getExtendedItemHandle(target);
        if (handle != null) {
            if (handle.getProperty("cube") != null) {
                EditPart editPart = (EditPart)target;
                if (editPart != null) {
                    CreateRequest request = new CreateRequest();
                    request.getExtendedData().put("newObject", transfer);
                    request.setLocation(location.getPoint());
                    Command command = editPart.getCommand((Request)request);
                    if (command != null && command.canExecute()) {
                        editPart.getViewer().getEditDomain().getCommandStack().execute(command);
                        return true;
                    }
                    return false;
                }
                return false;
            }
            CommandStack stack = this.getActionStack();
            stack.startTrans("Create Cube");
            try {
                ResultSetColumnHandle columnHandle = this.getColumnHandle(transfer);
                if (columnHandle != null) {
                    Object model;
                    DataSetHandle dataSetHandle = (DataSetHandle)columnHandle.getElementHandle();
                    TabularCubeHandle newCube = DesignElementFactory.getInstance().newTabularCube(String.valueOf(Messages.getString("DataColumnXTabDropAdapter.DataCube")) + " - " + dataSetHandle.getName());
                    SessionHandleAdapter.getInstance().getReportDesignHandle().getCubes().add((DesignElementHandle)newCube);
                    SimpleCubeBuilder builder = new SimpleCubeBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                    builder.setInput(newCube, dataSetHandle);
                    EditPart editPart = (EditPart)target;
                    if (editPart != null && (model = editPart.getModel()) instanceof VirtualCrosstabCellAdapter) {
                        VirtualCrosstabCellAdapter adapter = (VirtualCrosstabCellAdapter)model;
                        if (adapter.getType() == 0 || adapter.getType() == 1) {
                            this.createDimension(columnHandle, newCube);
                        } else if (adapter.getType() == 2) {
                            this.createMeasureGroup(columnHandle, newCube);
                        }
                    }
                    if (builder.open() == 0) {
                        if (handle != null) {
                            handle.setProperty("cube", (Object)newCube);
                        }
                        stack.commit();
                        ReportRequest request = new ReportRequest();
                        ArrayList<DesignElementHandle> selectionObjects = new ArrayList<DesignElementHandle>();
                        selectionObjects.add(handle);
                        request.setSelectionObject(selectionObjects);
                        request.setType((Object)"selection");
                        SessionHandleAdapter.getInstance().getMediator().notifyRequest((IMediatorRequest)request);
                        this.storePreference();
                    } else {
                        stack.rollback();
                    }
                }
                return true;
            }
            catch (Exception e) {
                stack.rollback();
                ExceptionUtil.handle((Throwable)e);
            }
        }
        return false;
    }

    private void createMeasureGroup(ResultSetColumnHandle columnHandle, TabularCubeHandle newCube) {
        TabularMeasureGroupHandle measureGroup = DesignElementFactory.getInstance().newTabularMeasureGroup(null);
        try {
            newCube.add("measureGroups", (DesignElementHandle)measureGroup);
            TabularMeasureHandle measure = DesignElementFactory.getInstance().newTabularMeasure(columnHandle.getColumnName());
            Expression expression = new Expression((Object)ExpressionUtility.getExpression((Object)columnHandle, (IExpressionConverter)ExpressionUtility.getExpressionConverter((String)UIUtil.getDefaultScriptType())), UIUtil.getDefaultScriptType());
            measure.setExpressionProperty("measureExpression", expression);
            measure.setDataType(columnHandle.getDataType());
            measureGroup.add("measures", (DesignElementHandle)measure);
        }
        catch (SemanticException e) {
            ExceptionUtil.handle((Throwable)e);
        }
    }

    private void createDimension(ResultSetColumnHandle columnHandle, TabularCubeHandle newCube) {
        try {
            if (this.isDateType(columnHandle.getDataType())) {
                CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
                stack.startTrans("Create Group");
                GroupDialog dialog = this.createGroupDialog(newCube);
                dialog.setInput(newCube, columnHandle);
                if (dialog.open() == 1) {
                    stack.rollback();
                } else {
                    stack.commit();
                }
            } else {
                TabularDimensionHandle dimension = DesignElementFactory.getInstance().newTabularDimension(null);
                newCube.add("dimensions", (DesignElementHandle)dimension);
                TabularHierarchyHandle hierarchy = (TabularHierarchyHandle)dimension.getContent("hierarchies", 0);
                TabularLevelHandle level = DesignElementFactory.getInstance().newTabularLevel((DimensionHandle)dimension, columnHandle.getColumnName());
                level.setColumnName(columnHandle.getColumnName());
                level.setDataType(columnHandle.getDataType());
                hierarchy.add("levels", (DesignElementHandle)level);
            }
        }
        catch (SemanticException e) {
            ExceptionUtil.handle((Throwable)e);
        }
    }

    protected GroupDialog createGroupDialog(TabularCubeHandle cube) {
        Object adapter = ElementAdapterManager.getAdapter((Object)cube, GroupDialog.class);
        try {
            if (adapter instanceof GroupDialog) {
                return (GroupDialog)((GroupDialog)adapter).getClass().newInstance();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return new GroupDialog();
    }

    private boolean isDateType(String dataType) {
        return dataType.equals("date-time") || dataType.equals("date") || dataType.equals("time");
    }

    private DesignElementHandle getExtendedItemHandle(Object target) {
        if (target instanceof CrosstabTableEditPart) {
            return (DesignElementHandle)((CrosstabTableEditPart)target).getModel();
        }
        if (target instanceof EditPart) {
            EditPart part = (EditPart)target;
            DesignElementHandle handle = (DesignElementHandle)((IAdaptable)target).getAdapter(DesignElementHandle.class);
            if (handle == null && part.getParent() != null) {
                return this.getExtendedItemHandle(part.getParent());
            }
        }
        return null;
    }

    private ResultSetColumnHandle getColumnHandle(Object transfer) {
        if (transfer instanceof Object[]) {
            Object[] transfers = (Object[])transfer;
            int i = 0;
            while (i < transfers.length) {
                if (transfers[i] instanceof ResultSetColumnHandle) {
                    return (ResultSetColumnHandle)transfers[i];
                }
                ++i;
            }
            return null;
        }
        if (transfer instanceof ResultSetColumnHandle) {
            return (ResultSetColumnHandle)transfer;
        }
        return null;
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    private void storePreference() {
        String prompt = PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)CrosstabPlugin.getDefault()).getString("org.eclipse.birt.report.designer.ui.cubebuilder.warning");
        if (prompt == null || prompt.length() == 0 || prompt.equals("prompt")) {
            MessageDialogWithToggle opendialog = MessageDialogWithToggle.openInformation((Shell)UIUtil.getDefaultShell(), (String)Messages.getString("CubeBuilder.warning.title"), (String)Messages.getString("CubeBuilder.warning.message"), (String)Messages.getString("CubeBuilder.warning.prompt"), (boolean)false, null, null);
            if (opendialog.getReturnCode() != 0) {
                return;
            }
            if (opendialog.getToggleState()) {
                this.savePreference("never");
            } else {
                this.savePreference("prompt");
            }
        }
    }

    private void savePreference(String value) {
        PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)CrosstabPlugin.getDefault()).setValue("org.eclipse.birt.report.designer.ui.cubebuilder.warning", value);
    }
}

