/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.birt.report.designer.internal.ui.actions.ProjectFilterAction;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseElementTreeSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FileContentProvider;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FileLabelProvider;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FilePathEntry;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelperProvider;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.FragmentResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.PathResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.widget.TreeViewerBackup;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class ProjectFileDialog
extends BaseElementTreeSelectionDialog {
    public static final String HELPER_PROPERTY_SELECTED_TYPE = "HELPER_PROPERTY_SELECTED_TYPE";
    public static final String HELPER_PROPERTY_IS_RELATIVE_TO_PROJECT = "HELPER_PROPERTY_IS_RELATIVE_TO_PROJECT";
    public static final String HELPER_PROPERTY_PREFIX = "HELPER_PROPERTY_PREFIX";
    IDialogHelper helper = null;
    String selectedType;
    boolean isRelativeToProjectRoot;
    protected String newFileName = "";
    private Status OKStatus = new Status(0, "org.eclipse.birt.report.designer.ui", 0, "", null);
    private Status ErrorStatus = new Status(4, "org.eclipse.birt.report.designer.ui", 4, Messages.getString((String)"ProjectFileDialog.ErrorMessage"), null);
    private Status ErrorStatusNoSelection = new Status(4, "org.eclipse.birt.report.designer.ui", 4, "", null);
    private String input;
    private String[] filePattern;
    private MenuManager menuManager;
    private ToolItem toolItem;
    private ToolBar toolBar;
    private TreeViewerBackup treeViewerBackup;

    public String getPath() {
        Object[] selected = this.getResult();
        if (selected.length > 0) {
            return this.getPath(0);
        }
        return null;
    }

    public String getPath(int index) {
        Object prefix;
        Object[] selected = this.getResult();
        if (index < 0 || index >= selected.length || this.input == null) {
            return null;
        }
        FilePathEntry entry = (FilePathEntry)selected[index];
        String path = entry.getURL().getFile();
        if (entry.getURL().getProtocol().equals("file")) {
            path = URIUtil.resolveAbsolutePath((String)this.input, (String)URIUtil.getRelativePath((String)this.input, (String)path));
        }
        if (this.helper != null && (prefix = this.helper.getProperty(HELPER_PROPERTY_PREFIX)) != null) {
            path = prefix + path;
        }
        return path;
    }

    public ProjectFileDialog(String input, String selectedType, boolean isRelativeToProjectRoot) {
        this(input, null, selectedType, isRelativeToProjectRoot);
    }

    public void refreshRoot() {
        if (this.filePattern == null) {
            this.getTreeViewer().setInput((Object)new ResourceEntry[]{new FilePathEntry(this.input)});
        } else {
            this.getTreeViewer().setInput((Object)new ResourceEntry[]{new FilePathEntry(this.input, this.filePattern)});
        }
        this.handleTreeViewerRefresh();
    }

    public ProjectFileDialog(String input, String[] filePattern, String selectedType, boolean isRelativeToProjectRoot) {
        super(UIUtil.getDefaultShell(), (ILabelProvider)new FileLabelProvider(input), new FileContentProvider(true));
        this.input = input;
        this.selectedType = selectedType;
        this.isRelativeToProjectRoot = isRelativeToProjectRoot;
        if (filePattern != null && filePattern.length > 0) {
            this.filePattern = filePattern;
        }
        this.setInput(new ResourceEntry[]{new FilePathEntry(input, filePattern)});
        this.setDoubleClickSelects(true);
        this.setValidator(new Validator());
        this.setAllowMultiple(false);
        this.setTitle(Messages.getString((String)"ProjectFileDialog.Title"));
        this.setMessage(Messages.getString((String)"ProjectFileDialog.Message"));
        this.setSorter(new FileViewerSorter());
    }

    protected Label createMessageArea(Composite composite) {
        Composite infoContent = new Composite(composite, 0);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        infoContent.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.numColumns = 2;
        infoContent.setLayout((Layout)layout);
        Label label = new Label(infoContent, 0);
        if (this.getMessage() != null) {
            label.setText(this.getMessage());
        }
        label.setFont(composite.getFont());
        label.setLayoutData((Object)new GridData(768));
        this.createViewMenu(infoContent);
        return label;
    }

    private void createViewMenu(Composite parent) {
        this.toolBar = new ToolBar(parent, 0x800000);
        this.toolItem = new ToolItem(this.toolBar, 8, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        this.toolBar.setLayoutData((Object)data);
        this.toolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ProjectFileDialog.this.showViewMenu();
            }
        });
        this.toolItem.setImage(ReportPlatformUIImages.getImage("view menu"));
        this.toolItem.setToolTipText(Messages.getString((String)"ProjectFileDialog.Text.Menu"));
        this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectFileDialog.this.showViewMenu();
            }
        });
        this.menuManager = new MenuManager();
        this.fillViewMenu((IMenuManager)this.menuManager);
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        ProjectFilterAction action = new ProjectFilterAction(this);
        menuManager.add((IAction)action);
    }

    private void showViewMenu() {
        Menu menu = this.menuManager.createContextMenu((Control)this.getShell());
        Rectangle bounds = this.toolItem.getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = this.toolBar.toDisplay(topLeft);
        menu.setLocation(topLeft.x, topLeft.y);
        menu.setVisible(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite rt = (Composite)super.createDialogArea(parent);
        this.addToolTip();
        rt.setLayoutData((Object)new GridData(1808));
        this.getTreeViewer().expandToLevel(2);
        this.getTreeViewer().getTree().setFocus();
        TreeListener treeListener = new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                Item item = (Item)e.item;
                if (ProjectFileDialog.this.treeViewerBackup != null) {
                    ProjectFileDialog.this.treeViewerBackup.updateCollapsedStatus(ProjectFileDialog.this.getTreeViewer(), item.getData());
                }
            }

            public void treeExpanded(TreeEvent e) {
                Item item = (Item)e.item;
                if (ProjectFileDialog.this.treeViewerBackup != null) {
                    ProjectFileDialog.this.treeViewerBackup.updateExpandedStatus(ProjectFileDialog.this.getTreeViewer(), item.getData());
                }
            }
        };
        this.getTreeViewer().getTree().addTreeListener(treeListener);
        this.initDialogHelper(rt);
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ProjectFileDialog_ID");
        return rt;
    }

    private void initDialogHelper(Composite rt) {
        IDialogHelperProvider helperProvider = (IDialogHelperProvider)ElementAdapterManager.getAdapter((Object)this, IDialogHelperProvider.class);
        if (helperProvider != null) {
            this.helper = helperProvider.createHelper((Object)this, "");
            this.helper.setProperty(HELPER_PROPERTY_SELECTED_TYPE, this.selectedType);
            this.helper.setProperty(HELPER_PROPERTY_IS_RELATIVE_TO_PROJECT, this.isRelativeToProjectRoot);
            this.helper.createContent(rt);
        } else {
            this.helper = null;
        }
    }

    private void handleTreeViewerRefresh() {
        if (this.treeViewerBackup != null) {
            this.treeViewerBackup.restoreBackup(this.getTreeViewer());
        } else {
            this.treeViewerBackup = new TreeViewerBackup();
            this.getTreeViewer().expandToLevel(2);
            this.treeViewerBackup.updateStatus(this.getTreeViewer());
        }
    }

    protected void okPressed() {
        super.okPressed();
        Object[] selected = this.getResult();
        if (selected.length > 0 && !this.newFileName.equals("")) {
            ResourceEntry entry = (ResourceEntry)selected[0];
            File file = new File(entry.getURL().getPath());
            try {
                new File(file, this.newFileName).createNewFile();
            }
            catch (IOException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    protected void addToolTip() {
        final Tree tree = this.getTreeViewer().getTree();
        tree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                Widget widget = event.widget;
                if (widget == tree) {
                    Point pt = new Point(event.x, event.y);
                    TreeItem item = tree.getItem(pt);
                    if (item == null) {
                        tree.setToolTipText(null);
                    } else if (ProjectFileDialog.this.getTreeViewer().getLabelProvider() instanceof FileLabelProvider) {
                        tree.setToolTipText(((FileLabelProvider)ProjectFileDialog.this.getTreeViewer().getLabelProvider()).getToolTip(item.getData()));
                    } else {
                        tree.setToolTipText(null);
                    }
                }
            }
        });
        this.refreshRoot();
    }

    protected static class FileViewerSorter
    extends ViewerSorter {
        protected FileViewerSorter() {
        }

        public int category(Object element) {
            if (element instanceof File) {
                if (((File)element).isDirectory()) {
                    return 0;
                }
                return 1;
            }
            if (element instanceof ResourceEntry) {
                if (((ResourceEntry)element).isFile()) {
                    return 1;
                }
                return 0;
            }
            return 1;
        }

        public void sort(final Viewer viewer, Object[] elements) {
            Arrays.sort(elements, new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    if (a instanceof FragmentResourceEntry) {
                        if (b instanceof FragmentResourceEntry) {
                            return this.compare(viewer, a, b);
                        }
                        return -1;
                    }
                    if (a instanceof PathResourceEntry) {
                        if (b instanceof FragmentResourceEntry) {
                            return 1;
                        }
                        if (b instanceof PathResourceEntry) {
                            return this.compare(viewer, a, b);
                        }
                        return -1;
                    }
                    return this.compare(viewer, a, b);
                }
            });
        }
    }

    private class Validator
    implements ISelectionStatusValidator {
        private Validator() {
        }

        public IStatus validate(Object[] selection) {
            int nSelected = selection.length;
            if (nSelected == 0) {
                return ProjectFileDialog.this.ErrorStatusNoSelection;
            }
            if (nSelected > 1) {
                return ProjectFileDialog.this.ErrorStatus;
            }
            if (selection[0] instanceof ResourceEntry && ((ResourceEntry)selection[0]).isFile()) {
                return ProjectFileDialog.this.OKStatus;
            }
            return ProjectFileDialog.this.ErrorStatus;
        }
    }
}

