/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.impl.ForeignContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.TextItemDesign;

public class TextItemExecutor
extends QueryItemExecutor {
    public TextItemExecutor(ExecutorManager manager) {
        super(manager, 6);
    }

    @Override
    public IContent execute() {
        String text;
        TextItemDesign textDesign = (TextItemDesign)this.getDesign();
        String textType = textDesign.getTextType();
        String contentType = ForeignContent.getTextRawType(textType, text = textDesign.getText());
        if ("text/html".equals(contentType)) {
            return this.executeHtmlText();
        }
        return this.executePlainText();
    }

    @Override
    public void close() throws BirtException {
        this.finishTOCEntry();
        this.closeQuery();
        super.close();
    }

    protected IContent executeHtmlText() {
        TextItemDesign textDesign = (TextItemDesign)this.getDesign();
        IForeignContent textContent = this.report.createForeignContent();
        this.setContent(textContent);
        this.executeQuery();
        this.initializeContent(textDesign, textContent);
        this.processAction(textDesign, textContent);
        this.processBookmark(textDesign, textContent);
        this.processStyle(textDesign, textContent);
        this.processVisibility(textDesign, textContent);
        this.processUserProperties(textDesign, textContent);
        HashMap<String, Expression> exprs = textDesign.getExpressions();
        if (exprs != null && !exprs.isEmpty()) {
            HashMap<String, Object> results = new HashMap<String, Object>();
            for (Map.Entry<String, Expression> entry : exprs.entrySet()) {
                Expression expr = entry.getValue();
                Object value = this.evaluate(expr);
                results.put(entry.getKey(), value);
            }
            Object[] value = new Object[]{null, results};
            textContent.setRawValue(value);
        } else {
            textContent.setRawValue(new Object[2]);
        }
        textContent.setRawType("text/template");
        textContent.setJTidy(textDesign.isJTidy());
        if (this.context.isInFactory()) {
            this.handleOnCreate(textContent);
        }
        this.startTOCEntry(this.content);
        return textContent;
    }

    protected IContent executePlainText() {
        TextItemDesign textDesign = (TextItemDesign)this.getDesign();
        ILabelContent textContent = this.report.createLabelContent();
        this.setContent(textContent);
        this.executeQuery();
        this.initializeContent(textDesign, textContent);
        textContent.setLabelText(textDesign.getText());
        textContent.setLabelKey(textDesign.getTextKey());
        this.processAction(textDesign, textContent);
        this.processBookmark(textDesign, textContent);
        this.processStyle(textDesign, textContent);
        this.processVisibility(textDesign, textContent);
        this.processUserProperties(textDesign, textContent);
        if (this.context.isInFactory()) {
            this.handleOnCreate(textContent);
        }
        this.startTOCEntry(this.content);
        return textContent;
    }
}

