/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value.css;

import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.value.IdentifierManager;
import org.eclipse.birt.report.engine.css.engine.value.StringMap;
import org.eclipse.birt.report.engine.css.engine.value.StringValue;
import org.eclipse.birt.report.engine.css.engine.value.URIValue;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class URIManager
extends IdentifierManager {
    protected static final StringMap values = new StringMap();
    protected String propertyName;
    protected Value defaultValue;
    protected boolean inherit;

    static {
        values.put("none", CSSValueConstants.NONE_VALUE);
    }

    public URIManager(String propertyName, boolean inherit, Value defaultValue) {
        this.propertyName = propertyName;
        this.defaultValue = defaultValue;
        this.inherit = inherit;
    }

    @Override
    public boolean isInheritedProperty() {
        return this.inherit;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Value getDefaultValue() {
        return this.defaultValue;
    }

    public Value createValue(String value, CSSEngine engine) throws DOMException {
        return new URIValue(value);
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        if (lu.getLexicalUnitType() == 24) {
            return new URIValue(lu.getStringValue());
        }
        return this.createStringValue(lu.getLexicalUnitType(), lu.getStringValue(), engine);
    }

    @Override
    public Value createStringValue(short type, String value, CSSEngine engine) throws DOMException {
        return new StringValue(19, value);
    }

    @Override
    public StringMap getIdentifiers() {
        return values;
    }
}

