/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.DatatypeConverter;
import org.apache.poi.common.usermodel.GenericRecord;
import org.apache.poi.util.GenericRecordJsonWriter;
import org.apache.poi.util.GenericRecordUtil;

public class GenericRecordXmlWriter
implements Closeable {
    private static final String TABS;
    private static final String ZEROS = "0000000000000000";
    private static final Pattern ESC_CHARS;
    private static final List<Map.Entry<Class, BiConsumer<GenericRecordXmlWriter, Object>>> handler;
    private final PrintWriter fw;
    private int indent = 0;
    private boolean withComments = true;
    private int childIndex = 0;
    private boolean attributePhase = true;

    private static void handler(Class c, BiConsumer<GenericRecordXmlWriter, Object> printer) {
        handler.add(new AbstractMap.SimpleEntry<Class, BiConsumer<GenericRecordXmlWriter, Object>>(c, printer));
    }

    public GenericRecordXmlWriter(File fileName) throws IOException {
        OutputStream os = "null".equals(fileName.getName()) ? new GenericRecordJsonWriter.NullOutputStream() : new FileOutputStream(fileName);
        this.fw = new PrintWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
    }

    public GenericRecordXmlWriter(Appendable buffer) {
        this.fw = new PrintWriter(new GenericRecordJsonWriter.AppendableWriter(buffer));
    }

    public static String marshal(GenericRecord record) {
        return GenericRecordXmlWriter.marshal(record, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String marshal(GenericRecord record, boolean withComments) {
        StringBuilder sb = new StringBuilder();
        try (GenericRecordXmlWriter w = new GenericRecordXmlWriter(sb);){
            w.setWithComments(withComments);
            w.write(record);
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            return "<record/>";
        }
    }

    public void setWithComments(boolean withComments) {
        this.withComments = withComments;
    }

    @Override
    public void close() throws IOException {
        this.fw.close();
    }

    private String tabs() {
        return TABS.substring(0, Math.min(this.indent, TABS.length()));
    }

    public void write(GenericRecord record) {
        this.write(record, "record");
    }

    private void write(GenericRecord record, String name) {
        String tabs = this.tabs();
        Enum type = record.getGenericRecordType();
        String recordName = type != null ? type.name() : record.getClass().getSimpleName();
        this.fw.append(tabs);
        this.fw.append("<" + name + " type=\"");
        this.fw.append(recordName);
        this.fw.append("\"");
        if (this.childIndex > 0) {
            this.fw.append(" index=\"");
            this.fw.print(this.childIndex);
            this.fw.append("\"");
        }
        boolean hasChildren = false;
        Map<String, Supplier<?>> prop = record.getGenericProperties();
        if (prop != null) {
            int oldChildIndex = this.childIndex;
            this.childIndex = 0;
            this.attributePhase = true;
            List<Map.Entry> complex = prop.entrySet().stream().flatMap(this::writeProp).collect(Collectors.toList());
            this.attributePhase = false;
            if (!complex.isEmpty()) {
                hasChildren = true;
                this.fw.println(">");
                ++this.indent;
                complex.forEach(this::writeProp);
                --this.indent;
            }
            this.childIndex = oldChildIndex;
        } else {
            this.fw.print(">");
        }
        this.attributePhase = false;
        List<? extends GenericRecord> list = record.getGenericChildren();
        if (list != null && !list.isEmpty()) {
            hasChildren = true;
            ++this.indent;
            this.fw.println();
            this.fw.append(this.tabs());
            this.fw.println("<children>");
            ++this.indent;
            int oldChildIndex = this.childIndex;
            this.childIndex = 0;
            list.forEach(l -> {
                this.writeValue("record", l);
                ++this.childIndex;
            });
            this.childIndex = oldChildIndex;
            this.fw.println();
            --this.indent;
            this.fw.append(this.tabs());
            this.fw.println("</children>");
            --this.indent;
        }
        if (hasChildren) {
            this.fw.append(tabs);
            this.fw.println("</" + name + ">");
        } else {
            this.fw.println("/>");
        }
    }

    public void writeError(String errorMsg) {
        this.fw.append("<error>");
        this.printObject(errorMsg);
        this.fw.append("</error>");
    }

    private Stream<Map.Entry<String, Supplier<?>>> writeProp(Map.Entry<String, Supplier<?>> me) {
        Object obj = me.getValue().get();
        if (obj == null) {
            return Stream.empty();
        }
        boolean isComplex = GenericRecordXmlWriter.isComplex(obj);
        if (this.attributePhase == isComplex) {
            return isComplex ? Stream.of(new AbstractMap.SimpleEntry<String, Supplier<Object>>(me.getKey(), () -> obj)) : Stream.empty();
        }
        int oldChildIndex = this.childIndex;
        this.childIndex = 0;
        this.writeValue(me.getKey(), obj);
        this.childIndex = oldChildIndex;
        return Stream.empty();
    }

    private static boolean isComplex(Object obj) {
        return !(obj instanceof Number) && !(obj instanceof Boolean) && !(obj instanceof Character) && !(obj instanceof String) && !(obj instanceof Color) && !(obj instanceof Enum);
    }

    private void writeValue(String key, Object o) {
        assert (key != null);
        if (o instanceof GenericRecord) {
            this.printGenericRecord((GenericRecord)o, key);
        } else if (o != null) {
            if (key.endsWith(">")) {
                this.fw.print("\t");
            }
            this.fw.print(this.attributePhase ? " " + key + "=\"" : this.tabs() + "<" + key);
            if (key.endsWith(">")) {
                this.fw.println();
            }
            handler.stream().filter(h -> GenericRecordXmlWriter.matchInstanceOrArray((Class)h.getKey(), o)).findFirst().ifPresent(h -> ((BiConsumer)h.getValue()).accept(this, o));
            if (this.attributePhase) {
                this.fw.append("\"");
            }
            if (key.endsWith(">")) {
                this.fw.println(this.tabs() + "\t</" + key);
            } else if (o instanceof List || o.getClass().isArray()) {
                this.fw.println(this.tabs() + "</" + key + ">");
            }
        }
    }

    private static boolean matchInstanceOrArray(Class key, Object instance) {
        return key.isInstance(instance) || Array.class.equals((Object)key) && instance.getClass().isArray();
    }

    private void printNumber(Object o) {
        assert (this.attributePhase);
        Number n = (Number)o;
        this.fw.print(n.toString());
        if (this.attributePhase) {
            return;
        }
        int size = n instanceof Byte ? 2 : (n instanceof Short ? 4 : (n instanceof Integer ? 8 : (n instanceof Long ? 16 : -1)));
        long l = n.longValue();
        if (this.withComments && size > 0 && (l < 0L || l > 9L)) {
            this.fw.write(" /* 0x");
            this.fw.write(this.trimHex(l, size));
            this.fw.write(" */");
        }
    }

    private void printBoolean(Object o) {
        this.fw.write(((Boolean)o).toString());
    }

    private void printList(Object o) {
        assert (!this.attributePhase);
        this.fw.println(">");
        int oldChildIndex = this.childIndex;
        this.childIndex = 0;
        ((List)o).forEach(e -> {
            this.writeValue("item>", e);
            ++this.childIndex;
        });
        this.childIndex = oldChildIndex;
    }

    private void printArray(Object o) {
        assert (!this.attributePhase);
        this.fw.println(">");
        int length = Array.getLength(o);
        int oldChildIndex = this.childIndex;
        this.childIndex = 0;
        while (this.childIndex < length) {
            this.writeValue("item>", Array.get(o, this.childIndex));
            ++this.childIndex;
        }
        this.childIndex = oldChildIndex;
    }

    private void printGenericRecord(Object o, String name) {
        this.write((GenericRecord)o, name);
    }

    private void printAnnotatedFlag(Object o) {
        assert (!this.attributePhase);
        GenericRecordUtil.AnnotatedFlag af = (GenericRecordUtil.AnnotatedFlag)o;
        Number n = af.getValue().get();
        int len = n instanceof Byte ? 2 : (n instanceof Short ? 4 : (n instanceof Integer ? 8 : 16));
        this.fw.print(" flag=\"0x");
        this.fw.print(this.trimHex(n.longValue(), len));
        this.fw.print('\"');
        if (this.withComments) {
            this.fw.print(" description=\"");
            this.fw.print(af.getDescription());
            this.fw.print("\"");
        }
        this.fw.println("/>");
    }

    private void printBytes(Object o) {
        assert (!this.attributePhase);
        this.fw.write(">");
        this.fw.write(DatatypeConverter.printBase64Binary((byte[])((byte[])o)));
    }

    private void printPoint(Object o) {
        assert (!this.attributePhase);
        Point2D p = (Point2D)o;
        this.fw.println(" x=\"" + p.getX() + "\" y=\"" + p.getY() + "\"/>");
    }

    private void printDimension(Object o) {
        assert (!this.attributePhase);
        Dimension2D p = (Dimension2D)o;
        this.fw.println(" width=\"" + p.getWidth() + "\" height=\"" + p.getHeight() + "\"/>");
    }

    private void printRectangle(Object o) {
        assert (!this.attributePhase);
        Rectangle2D p = (Rectangle2D)o;
        this.fw.println(" x=\"" + p.getX() + "\" y=\"" + p.getY() + "\" width=\"" + p.getWidth() + "\" height=\"" + p.getHeight() + "\"/>");
    }

    private void printPath(Object o) {
        assert (!this.attributePhase);
        PathIterator iter = ((Path2D)o).getPathIterator(null);
        double[] pnts = new double[6];
        this.indent += 2;
        String t = this.tabs();
        this.indent -= 2;
        boolean isNext = false;
        while (!iter.isDone()) {
            this.fw.print(t);
            isNext = true;
            int segType = iter.currentSegment(pnts);
            this.fw.print("<pathelement ");
            switch (segType) {
                case 0: {
                    this.fw.print("type=\"move\" x=\"" + pnts[0] + "\" y=\"" + pnts[1] + "\"");
                    break;
                }
                case 1: {
                    this.fw.print("type=\"lineto\" x=\"" + pnts[0] + "\" y=\"" + pnts[1] + "\"");
                    break;
                }
                case 2: {
                    this.fw.print("type=\"quad\" x1=\"" + pnts[0] + "\" y1=\"" + pnts[1] + "\" x2=\"" + pnts[2] + "\" y2=\"" + pnts[3] + "\"");
                    break;
                }
                case 3: {
                    this.fw.print("type=\"cubic\" x1=\"" + pnts[0] + "\" y1=\"" + pnts[1] + "\" x2=\"" + pnts[2] + "\" y2=\"" + pnts[3] + "\" x3=\"" + pnts[4] + "\" y3=\"" + pnts[5] + "\"");
                    break;
                }
                case 4: {
                    this.fw.print("type=\"close\"");
                }
            }
            this.fw.println("/>");
            iter.next();
        }
    }

    private void printObject(Object o) {
        Matcher m = ESC_CHARS.matcher(o.toString());
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String repl;
            String match;
            switch (match = m.group()) {
                case "<": {
                    repl = "&lt;";
                    break;
                }
                case ">": {
                    repl = "&gt;";
                    break;
                }
                case "&": {
                    repl = "&amp;";
                    break;
                }
                case "'": {
                    repl = "&apos;";
                    break;
                }
                case "\"": {
                    repl = "&quot;";
                    break;
                }
                default: {
                    repl = "&#x" + Long.toHexString(match.codePointAt(0)) + ";";
                }
            }
            m.appendReplacement(sb, repl);
        }
        m.appendTail(sb);
        this.fw.write(sb.toString());
    }

    private void printAffineTransform(Object o) {
        assert (!this.attributePhase);
        AffineTransform xForm = (AffineTransform)o;
        this.fw.write(" scaleX=\"" + xForm.getScaleX() + "\" shearX=\"" + xForm.getShearX() + "\" transX=\"" + xForm.getTranslateX() + "\" scaleY=\"" + xForm.getScaleY() + "\" shearY=\"" + xForm.getShearY() + "\" transY=\"" + xForm.getTranslateY() + "\"/>");
    }

    private void printColor(Object o) {
        assert (this.attributePhase);
        int rgb = ((Color)o).getRGB();
        this.fw.print("0x");
        this.fw.print(this.trimHex(rgb, 8));
    }

    private void printBufferedImage(Object o) {
        assert (!this.attributePhase);
        BufferedImage bi = (BufferedImage)o;
        this.fw.println(" width=\"" + bi.getWidth() + "\" height=\"" + bi.getHeight() + "\" bands=\"" + bi.getColorModel().getNumComponents() + "\"/>");
    }

    private String trimHex(long l, int size) {
        String b = Long.toHexString(l);
        int len = b.length();
        return ZEROS.substring(0, Math.max(0, size - len)) + b.substring(Math.max(0, len - size), len);
    }

    static {
        ESC_CHARS = Pattern.compile("[<>&'\"\\p{Cntrl}]");
        handler = new ArrayList<Map.Entry<Class, BiConsumer<GenericRecordXmlWriter, Object>>>();
        char[] t = new char[255];
        Arrays.fill(t, '\t');
        TABS = new String(t);
        GenericRecordXmlWriter.handler(String.class, GenericRecordXmlWriter::printObject);
        GenericRecordXmlWriter.handler(Number.class, GenericRecordXmlWriter::printNumber);
        GenericRecordXmlWriter.handler(Boolean.class, GenericRecordXmlWriter::printBoolean);
        GenericRecordXmlWriter.handler(List.class, GenericRecordXmlWriter::printList);
        GenericRecordXmlWriter.handler(GenericRecordUtil.AnnotatedFlag.class, GenericRecordXmlWriter::printAnnotatedFlag);
        GenericRecordXmlWriter.handler(byte[].class, GenericRecordXmlWriter::printBytes);
        GenericRecordXmlWriter.handler(Point2D.class, GenericRecordXmlWriter::printPoint);
        GenericRecordXmlWriter.handler(Dimension2D.class, GenericRecordXmlWriter::printDimension);
        GenericRecordXmlWriter.handler(Rectangle2D.class, GenericRecordXmlWriter::printRectangle);
        GenericRecordXmlWriter.handler(Path2D.class, GenericRecordXmlWriter::printPath);
        GenericRecordXmlWriter.handler(AffineTransform.class, GenericRecordXmlWriter::printAffineTransform);
        GenericRecordXmlWriter.handler(Color.class, GenericRecordXmlWriter::printColor);
        GenericRecordXmlWriter.handler(BufferedImage.class, GenericRecordXmlWriter::printBufferedImage);
        GenericRecordXmlWriter.handler(Array.class, GenericRecordXmlWriter::printArray);
        GenericRecordXmlWriter.handler(Object.class, GenericRecordXmlWriter::printObject);
    }
}

