/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editparts;

import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.AutoexposeHelper;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ViewportHelper;

public class ViewportAutoexposeHelper
extends ViewportHelper
implements AutoexposeHelper {
    private static final Insets DEFAULT_EXPOSE_THRESHOLD = new Insets(18);
    private long lastStepTime = 0L;
    private Insets threshold;

    public ViewportAutoexposeHelper(GraphicalEditPart owner) {
        super(owner);
        this.threshold = DEFAULT_EXPOSE_THRESHOLD;
    }

    public ViewportAutoexposeHelper(GraphicalEditPart owner, Insets threshold) {
        super(owner);
        this.threshold = threshold;
    }

    @Override
    public boolean detect(Point where) {
        this.lastStepTime = 0L;
        Viewport port = this.findViewport(this.owner);
        Rectangle rect = Rectangle.SINGLETON;
        port.getClientArea(rect);
        port.translateToParent((Translatable)rect);
        port.translateToAbsolute((Translatable)rect);
        return rect.contains(where) && !rect.crop(this.threshold).contains(where);
    }

    @Override
    public boolean step(Point where) {
        long difference;
        Viewport port = this.findViewport(this.owner);
        Rectangle rect = Rectangle.SINGLETON;
        port.getClientArea(rect);
        port.translateToParent((Translatable)rect);
        port.translateToAbsolute((Translatable)rect);
        if (!rect.contains(where) || rect.crop(this.threshold).contains(where)) {
            return false;
        }
        int scrollOffset = 0;
        if (this.lastStepTime == 0L) {
            this.lastStepTime = System.currentTimeMillis();
        }
        if ((difference = System.currentTimeMillis() - this.lastStepTime) > 0L) {
            scrollOffset = (int)difference / 3;
            this.lastStepTime = System.currentTimeMillis();
        }
        if (scrollOffset == 0) {
            return true;
        }
        rect.crop(this.threshold);
        int region = rect.getPosition(where);
        Point loc = port.getViewLocation();
        if ((region & 4) != 0) {
            loc.y += scrollOffset;
        } else if ((region & 1) != 0) {
            loc.y -= scrollOffset;
        }
        if ((region & 0x10) != 0) {
            loc.x += scrollOffset;
        } else if ((region & 8) != 0) {
            loc.x -= scrollOffset;
        }
        port.setViewLocation(loc);
        return true;
    }

    public String toString() {
        return "ViewportAutoexposeHelper for: " + this.owner;
    }
}

