/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.editors;

import org.eclipse.birt.report.data.oda.jdbc.ui.editors.JdbcSQLContentAssistProcessor;
import org.eclipse.birt.report.data.oda.jdbc.ui.editors.NonRuleBasedDamagerRepairer;
import org.eclipse.birt.report.data.oda.jdbc.ui.editors.SQLKeywordScanner;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ColorManager;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class SQLSourceViewerConfiguration
extends SourceViewerConfiguration {
    private static final TextAttribute quoteString = new TextAttribute(ColorManager.getColor(42, 0, 255));
    private static final TextAttribute comment = new TextAttribute(ColorManager.getColor(63, 127, 95));
    private DataSourceDesign dsd;
    private long timeout;
    private boolean enableCodeAssist;

    public SQLSourceViewerConfiguration(DataSourceDesign dsd, long timeout, boolean enableCodeAssist) {
        this.dsd = dsd;
        this.timeout = timeout;
        this.enableCodeAssist = enableCodeAssist;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        NonRuleBasedDamagerRepairer dr = new NonRuleBasedDamagerRepairer(quoteString);
        reconciler.setDamager((IPresentationDamager)dr, "sql_quote_string1");
        reconciler.setRepairer((IPresentationRepairer)dr, "sql_quote_string1");
        dr = new NonRuleBasedDamagerRepairer(comment);
        reconciler.setDamager((IPresentationDamager)dr, "sql_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "sql_comment");
        DefaultDamagerRepairer ddr = new DefaultDamagerRepairer((ITokenScanner)new SQLKeywordScanner());
        reconciler.setDamager((IPresentationDamager)ddr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)ddr, "__dftl_partition_content_type");
        return reconciler;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"sql_quote_string1", "sql_comment", "__dftl_partition_content_type"};
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (!this.enableCodeAssist) {
            return null;
        }
        ContentAssistant assistant = new ContentAssistant();
        JdbcSQLContentAssistProcessor contentAssist = new JdbcSQLContentAssistProcessor(this.timeout);
        contentAssist.setDataSourceHandle(this.dsd);
        assistant.setContentAssistProcessor((IContentAssistProcessor)contentAssist, "__dftl_partition_content_type");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(10);
        return assistant;
    }
}

