/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de.internal;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.AbstractCrosstabModelTask;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabModelUtil;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabExtendedItemFactory;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class MeasureViewTask
extends AbstractCrosstabModelTask {
    protected MeasureViewHandle focus = null;

    public MeasureViewTask(MeasureViewHandle levelView) {
        super(levelView);
        this.focus = levelView;
    }

    public void removeHeader() throws SemanticException {
        PropertyHandle propHandle = this.focus.getHeaderProperty();
        List contents = propHandle.getContents();
        CommandStack stack = this.focus.getCommandStack();
        stack.startTrans(Messages.getString("MeasureViewTask.msg.remove.header"));
        try {
            int i = 0;
            while (i < contents.size()) {
                ((DesignElementHandle)contents.get(i)).drop();
                ++i;
            }
        }
        catch (SemanticException e) {
            this.focus.getLogger().log(Level.WARNING, e.getMessage(), e);
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public void addHeader() throws SemanticException {
        PropertyHandle propHandle = this.focus.getHeaderProperty();
        int expectHeaders = CrosstabModelUtil.computeAllMeasureHeaderCount(this.crosstab, this.focus);
        int availableHeaders = propHandle.getContentCount();
        if (availableHeaders >= expectHeaders) {
            this.focus.getLogger().log(Level.INFO, "Measure header already present, need not add another");
            return;
        }
        CommandStack stack = this.focus.getCommandStack();
        stack.startTrans(Messages.getString("MeasureViewTask.msg.add.header"));
        try {
            int i = 0;
            while (i < expectHeaders - availableHeaders) {
                ExtendedItemHandle headerCell = CrosstabExtendedItemFactory.createCrosstabCell(this.focus.getModuleHandle());
                propHandle.add((DesignElementHandle)headerCell);
                CrosstabModelUtil.notifyCreation(1, CrosstabUtil.getReportItem((DesignElementHandle)headerCell), null);
                ++i;
            }
        }
        catch (SemanticException e) {
            this.focus.getLogger().log(Level.WARNING, e.getMessage(), e);
            stack.rollback();
            throw e;
        }
        stack.commit();
    }
}

