/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model.thrift;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.AuthorizationException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public abstract class AbstractThriftClientWrapper
extends Cassandra.Client {
    Cassandra.Client client;

    public AbstractThriftClientWrapper(Cassandra.Client client) {
        super(client.getInputProtocol(), client.getOutputProtocol());
        this.client = client;
    }

    public void add(ByteBuffer key, ColumnParent column_parent, CounterColumn column, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        this.client.add(key, column_parent, column, consistency_level);
    }

    public void batch_mutate(Map<ByteBuffer, Map<String, List<Mutation>>> mutation_map, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        this.client.batch_mutate(mutation_map, consistency_level);
    }

    public String describe_cluster_name() throws TException {
        return this.client.describe_cluster_name();
    }

    public KsDef describe_keyspace(String keyspace) throws NotFoundException, InvalidRequestException, TException {
        return this.client.describe_keyspace(keyspace);
    }

    public List<KsDef> describe_keyspaces() throws InvalidRequestException, TException {
        return this.client.describe_keyspaces();
    }

    public String describe_partitioner() throws TException {
        return this.client.describe_partitioner();
    }

    public List<TokenRange> describe_ring(String keyspace) throws InvalidRequestException, TException {
        return this.client.describe_ring(keyspace);
    }

    public Map<String, List<String>> describe_schema_versions() throws InvalidRequestException, TException {
        return this.client.describe_schema_versions();
    }

    public String describe_snitch() throws TException {
        return this.client.describe_snitch();
    }

    public List<String> describe_splits(String cfName, String start_token, String end_token, int keys_per_split) throws TException, InvalidRequestException {
        return this.client.describe_splits(cfName, start_token, end_token, keys_per_split);
    }

    public String describe_version() throws TException {
        return this.client.describe_version();
    }

    public CqlResult execute_cql_query(ByteBuffer query, Compression compression) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException {
        return this.client.execute_cql_query(query, compression);
    }

    public ColumnOrSuperColumn get(ByteBuffer key, ColumnPath column_path, ConsistencyLevel consistency_level) throws InvalidRequestException, NotFoundException, UnavailableException, TimedOutException, TException {
        return this.client.get(key, column_path, consistency_level);
    }

    public int get_count(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.client.get_count(key, column_parent, predicate, consistency_level);
    }

    public List<KeySlice> get_indexed_slices(ColumnParent column_parent, IndexClause index_clause, SlicePredicate column_predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.client.get_indexed_slices(column_parent, index_clause, column_predicate, consistency_level);
    }

    public List<KeySlice> get_range_slices(ColumnParent column_parent, SlicePredicate predicate, KeyRange range, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.client.get_range_slices(column_parent, predicate, range, consistency_level);
    }

    public List<ColumnOrSuperColumn> get_slice(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.client.get_slice(key, column_parent, predicate, consistency_level);
    }

    public TProtocol getInputProtocol() {
        return this.client.getInputProtocol();
    }

    public TProtocol getOutputProtocol() {
        return this.client.getOutputProtocol();
    }

    public void insert(ByteBuffer key, ColumnParent column_parent, Column column, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        this.client.insert(key, column_parent, column, consistency_level);
    }

    public void login(AuthenticationRequest auth_request) throws AuthenticationException, AuthorizationException, TException {
        this.client.login(auth_request);
    }

    public Map<ByteBuffer, Integer> multiget_count(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.client.multiget_count(keys, column_parent, predicate, consistency_level);
    }

    public Map<ByteBuffer, List<ColumnOrSuperColumn>> multiget_slice(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.client.multiget_slice(keys, column_parent, predicate, consistency_level);
    }

    public void recv_add() throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        this.client.recv_add();
    }

    public void recv_batch_mutate() throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        this.client.recv_batch_mutate();
    }

    public String recv_describe_cluster_name() throws TException {
        return this.client.recv_describe_cluster_name();
    }

    public KsDef recv_describe_keyspace() throws NotFoundException, InvalidRequestException, TException {
        return this.client.recv_describe_keyspace();
    }

    public List<KsDef> recv_describe_keyspaces() throws InvalidRequestException, TException {
        return this.client.recv_describe_keyspaces();
    }

    public String recv_describe_partitioner() throws TException {
        return this.client.recv_describe_partitioner();
    }

    public List<TokenRange> recv_describe_ring() throws InvalidRequestException, TException {
        return this.client.recv_describe_ring();
    }

    public Map<String, List<String>> recv_describe_schema_versions() throws InvalidRequestException, TException {
        return this.client.recv_describe_schema_versions();
    }

    public String recv_describe_snitch() throws TException {
        return this.client.recv_describe_snitch();
    }

    public List<String> recv_describe_splits() throws TException, InvalidRequestException {
        return this.client.recv_describe_splits();
    }

    public String recv_describe_version() throws TException {
        return this.client.recv_describe_version();
    }

    public CqlResult recv_execute_cql_query() throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException {
        return this.client.recv_execute_cql_query();
    }

    public ColumnOrSuperColumn recv_get() throws InvalidRequestException, NotFoundException, UnavailableException, TimedOutException, TException {
        return this.client.recv_get();
    }

    public int recv_get_count() throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.client.recv_get_count();
    }

    public List<KeySlice> recv_get_indexed_slices() throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.client.recv_get_indexed_slices();
    }

    public List<KeySlice> recv_get_range_slices() throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.client.recv_get_range_slices();
    }

    public List<ColumnOrSuperColumn> recv_get_slice() throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.client.recv_get_slice();
    }

    public void recv_insert() throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        this.client.recv_insert();
    }

    public void recv_login() throws AuthenticationException, AuthorizationException, TException {
        this.client.recv_login();
    }

    public Map<ByteBuffer, Integer> recv_multiget_count() throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.client.recv_multiget_count();
    }

    public Map<ByteBuffer, List<ColumnOrSuperColumn>> recv_multiget_slice() throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.client.recv_multiget_slice();
    }

    public void recv_remove() throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        this.client.recv_remove();
    }

    public void recv_remove_counter() throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        this.client.recv_remove_counter();
    }

    public void recv_set_keyspace() throws InvalidRequestException, TException {
        this.client.recv_set_keyspace();
    }

    public String recv_system_add_column_family() throws InvalidRequestException, TException, SchemaDisagreementException {
        return this.client.recv_system_add_column_family();
    }

    public String recv_system_add_keyspace() throws InvalidRequestException, TException, SchemaDisagreementException {
        return this.client.recv_system_add_keyspace();
    }

    public String recv_system_drop_column_family() throws InvalidRequestException, TException, SchemaDisagreementException {
        return this.client.recv_system_drop_column_family();
    }

    public String recv_system_drop_keyspace() throws InvalidRequestException, TException, SchemaDisagreementException {
        return this.client.recv_system_drop_keyspace();
    }

    public String recv_system_update_column_family() throws InvalidRequestException, TException, SchemaDisagreementException {
        return this.client.recv_system_update_column_family();
    }

    public String recv_system_update_keyspace() throws InvalidRequestException, TException, SchemaDisagreementException {
        return this.client.recv_system_update_keyspace();
    }

    public void recv_truncate() throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        this.client.recv_truncate();
    }

    public void remove(ByteBuffer key, ColumnPath column_path, long timestamp, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        this.client.remove(key, column_path, timestamp, consistency_level);
    }

    public void remove_counter(ByteBuffer key, ColumnPath path, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        this.client.remove_counter(key, path, consistency_level);
    }

    public void send_add(ByteBuffer key, ColumnParent column_parent, CounterColumn column, ConsistencyLevel consistency_level) throws TException {
        this.client.send_add(key, column_parent, column, consistency_level);
    }

    public void send_batch_mutate(Map<ByteBuffer, Map<String, List<Mutation>>> mutation_map, ConsistencyLevel consistency_level) throws TException {
        this.client.send_batch_mutate(mutation_map, consistency_level);
    }

    public void send_describe_cluster_name() throws TException {
        this.client.send_describe_cluster_name();
    }

    public void send_describe_keyspace(String keyspace) throws TException {
        this.client.send_describe_keyspace(keyspace);
    }

    public void send_describe_keyspaces() throws TException {
        this.client.send_describe_keyspaces();
    }

    public void send_describe_partitioner() throws TException {
        this.client.send_describe_partitioner();
    }

    public void send_describe_ring(String keyspace) throws TException {
        this.client.send_describe_ring(keyspace);
    }

    public void send_describe_schema_versions() throws TException {
        this.client.send_describe_schema_versions();
    }

    public void send_describe_snitch() throws TException {
        this.client.send_describe_snitch();
    }

    public void send_describe_splits(String cfName, String start_token, String end_token, int keys_per_split) throws TException {
        this.client.send_describe_splits(cfName, start_token, end_token, keys_per_split);
    }

    public void send_describe_version() throws TException {
        this.client.send_describe_version();
    }

    public void send_execute_cql_query(ByteBuffer query, Compression compression) throws TException {
        this.client.send_execute_cql_query(query, compression);
    }

    public void send_get(ByteBuffer key, ColumnPath column_path, ConsistencyLevel consistency_level) throws TException {
        this.client.send_get(key, column_path, consistency_level);
    }

    public void send_get_count(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws TException {
        this.client.send_get_count(key, column_parent, predicate, consistency_level);
    }

    public void send_get_indexed_slices(ColumnParent column_parent, IndexClause index_clause, SlicePredicate column_predicate, ConsistencyLevel consistency_level) throws TException {
        this.client.send_get_indexed_slices(column_parent, index_clause, column_predicate, consistency_level);
    }

    public void send_get_range_slices(ColumnParent column_parent, SlicePredicate predicate, KeyRange range, ConsistencyLevel consistency_level) throws TException {
        this.client.send_get_range_slices(column_parent, predicate, range, consistency_level);
    }

    public void send_get_slice(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws TException {
        this.client.send_get_slice(key, column_parent, predicate, consistency_level);
    }

    public void send_insert(ByteBuffer key, ColumnParent column_parent, Column column, ConsistencyLevel consistency_level) throws TException {
        this.client.send_insert(key, column_parent, column, consistency_level);
    }

    public void send_login(AuthenticationRequest auth_request) throws TException {
        this.client.send_login(auth_request);
    }

    public void send_multiget_count(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws TException {
        this.client.send_multiget_count(keys, column_parent, predicate, consistency_level);
    }

    public void send_multiget_slice(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws TException {
        this.client.send_multiget_slice(keys, column_parent, predicate, consistency_level);
    }

    public void send_remove(ByteBuffer key, ColumnPath column_path, long timestamp, ConsistencyLevel consistency_level) throws TException {
        this.client.send_remove(key, column_path, timestamp, consistency_level);
    }

    public void send_remove_counter(ByteBuffer key, ColumnPath path, ConsistencyLevel consistency_level) throws TException {
        this.client.send_remove_counter(key, path, consistency_level);
    }

    public void send_set_keyspace(String keyspace) throws TException {
        this.client.send_set_keyspace(keyspace);
    }

    public void send_system_add_column_family(CfDef cf_def) throws TException {
        this.client.send_system_add_column_family(cf_def);
    }

    public void send_system_add_keyspace(KsDef ks_def) throws TException {
        this.client.send_system_add_keyspace(ks_def);
    }

    public void send_system_drop_column_family(String column_family) throws TException {
        this.client.send_system_drop_column_family(column_family);
    }

    public void send_system_drop_keyspace(String keyspace) throws TException {
        this.client.send_system_drop_keyspace(keyspace);
    }

    public void send_system_update_column_family(CfDef cf_def) throws TException {
        this.client.send_system_update_column_family(cf_def);
    }

    public void send_system_update_keyspace(KsDef ks_def) throws TException {
        this.client.send_system_update_keyspace(ks_def);
    }

    public void send_truncate(String cfname) throws TException {
        this.client.send_truncate(cfname);
    }

    public void set_keyspace(String keyspace) throws InvalidRequestException, TException {
        this.client.set_keyspace(keyspace);
    }

    public String system_add_column_family(CfDef cf_def) throws InvalidRequestException, TException, SchemaDisagreementException {
        return this.client.system_add_column_family(cf_def);
    }

    public String system_add_keyspace(KsDef ks_def) throws InvalidRequestException, TException, SchemaDisagreementException {
        return this.client.system_add_keyspace(ks_def);
    }

    public String system_drop_column_family(String column_family) throws InvalidRequestException, TException, SchemaDisagreementException {
        return this.client.system_drop_column_family(column_family);
    }

    public String system_drop_keyspace(String keyspace) throws InvalidRequestException, TException, SchemaDisagreementException {
        return this.client.system_drop_keyspace(keyspace);
    }

    public String system_update_column_family(CfDef cf_def) throws InvalidRequestException, TException, SchemaDisagreementException {
        return this.client.system_update_column_family(cf_def);
    }

    public String system_update_keyspace(KsDef ks_def) throws InvalidRequestException, TException, SchemaDisagreementException {
        return this.client.system_update_keyspace(ks_def);
    }

    public void truncate(String cfname) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        this.client.truncate(cfname);
    }
}

