/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.series;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.model.util.DefaultValueProvider;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartCheckbox;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class LineSeriesAttributeComposite
extends Composite
implements SelectionListener,
Listener {
    private Label lblShadow;
    private FillChooserComposite fccShadow = null;
    protected Group grpLine = null;
    private LineAttributesComposite liacLine = null;
    protected Series series = null;
    protected LineSeries defSeries = DefaultValueProvider.defLineSeries();
    protected ChartWizardContext context;
    private ChartCheckbox btnPalette;
    private ChartCheckbox btnCurve;
    private ChartCheckbox btnMissingValue;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.series");

    public LineSeriesAttributeComposite(Composite parent, int style, ChartWizardContext context, Series series) {
        super(parent, style);
        if (!(series instanceof LineSeriesImpl)) {
            try {
                throw new ChartException("org.eclipse.birt.chart.ui.extension", 30, "LineSeriesAttributeComposite.Exception.IllegalArgument", new Object[]{series.getClass().getName()}, Messages.getResourceBundle());
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
                e.printStackTrace();
            }
        }
        this.series = series;
        this.context = context;
        this.init();
        this.placeComponents();
        ChartUIUtil.bindHelp((Control)parent, (String)this.getHelpId(series));
    }

    private String getHelpId(Series series) {
        String helpId = "org.eclipse.birt.chart.cshelp.FormatLineChartYSeries_ID";
        if (series instanceof AreaSeries) {
            helpId = "org.eclipse.birt.chart.cshelp.FormatAreaChartYSeries_ID";
        } else if (series instanceof ScatterSeries) {
            helpId = "org.eclipse.birt.chart.cshelp.FormatScatterChartYSeries_ID";
        }
        return helpId;
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    protected void placeComponents() {
        this.setLayout((Layout)new GridLayout());
        this.grpLine = new Group((Composite)this, 0);
        GridLayout glLine = new GridLayout(2, true);
        glLine.horizontalSpacing = 0;
        this.grpLine.setLayout((Layout)glLine);
        this.grpLine.setLayoutData((Object)new GridData(1808));
        this.grpLine.setText(Messages.getString("LineSeriesAttributeComposite.Lbl.Line"));
        this.initUIComponents((Composite)this.grpLine);
        this.enableLineSettings(!this.context.getUIFactory().isSetInvisible((EObject)((LineSeries)this.series).getLineAttributes()));
    }

    protected void initUIComponents(Composite parent) {
        Composite cmpLine = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        cmpLine.setLayout((Layout)gl);
        cmpLine.setLayoutData((Object)new GridData(1808));
        int lineStyles = 15;
        this.liacLine = new LineAttributesComposite(cmpLine, 0, lineStyles |= this.context.getUIFactory().supportAutoUI() ? 16 : lineStyles, this.context, ((LineSeries)this.series).getLineAttributes(), this.defSeries.getLineAttributes());
        GridData gdLIACLine = new GridData(768);
        gdLIACLine.horizontalSpan = 2;
        this.liacLine.setLayoutData(gdLIACLine);
        this.liacLine.addListener(this);
        if (this.isShadowNeeded()) {
            Composite cmpShadow = new Composite(cmpLine, 0);
            GridLayout gl2 = new GridLayout(2, false);
            gl2.marginHeight = 0;
            gl2.marginBottom = 0;
            gl2.verticalSpacing = 0;
            cmpShadow.setLayout((Layout)gl2);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            cmpShadow.setLayoutData((Object)gd);
            this.lblShadow = new Label(cmpShadow, 0);
            this.lblShadow.setText(Messages.getString("LineSeriesAttributeComposite.Lbl.ShadowColor"));
            int iFillOption = 152;
            this.fccShadow = new FillChooserComposite(cmpShadow, 12, iFillOption |= this.context.getUIFactory().supportAutoUI() ? 4 : iFillOption, this.context, (Fill)((LineSeries)this.series).getShadowColor());
            GridData gdFCCShadow = new GridData(768);
            this.fccShadow.setLayoutData(gdFCCShadow);
            this.fccShadow.addListener(this);
        }
        Composite cmp = new Composite((Composite)this.grpLine, 0);
        GridLayout gl3 = new GridLayout(1, false);
        cmp.setLayout((Layout)gl3);
        this.btnPalette = this.context.getUIFactory().createChartCheckbox(cmp, 0, this.defSeries.isPaletteLineColor());
        this.btnPalette.setText(Messages.getString("LineSeriesAttributeComposite.Lbl.LinePalette"));
        this.btnPalette.setSelectionState(((LineSeries)this.series).isSetPaletteLineColor() ? (((LineSeries)this.series).isPaletteLineColor() ? 1 : 2) : 0);
        this.btnPalette.addSelectionListener((SelectionListener)this);
        this.btnCurve = this.context.getUIFactory().createChartCheckbox(cmp, 0, this.defSeries.isCurve());
        this.btnCurve.setText(Messages.getString("LineSeriesAttributeComposite.Lbl.ShowLinesAsCurves"));
        this.btnCurve.setSelectionState(((LineSeries)this.series).isSetCurve() ? (((LineSeries)this.series).isCurve() ? 1 : 2) : 0);
        this.btnCurve.addSelectionListener((SelectionListener)this);
        if (!(this.series instanceof AreaSeries && this.series.isSetStacked() && this.series.isStacked())) {
            this.btnMissingValue = this.context.getUIFactory().createChartCheckbox(cmp, 0, this.defSeries.isConnectMissingValue());
            this.btnMissingValue.setText(Messages.getString("LineSeriesAttributeComposite.Lbl.ConnectMissingValue"));
            this.btnMissingValue.setSelectionState(((LineSeries)this.series).isSetConnectMissingValue() ? (((LineSeries)this.series).isConnectMissingValue() ? 1 : 2) : 0);
            this.btnMissingValue.addSelectionListener((SelectionListener)this);
        }
    }

    public Point getPreferredSize() {
        return new Point(400, 200);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.btnCurve) {
            ChartElementUtil.setEObjectAttribute((EObject)this.series, (String)"curve", (Object)(this.btnCurve.getSelectionState() == 1 ? 1 : 0), (this.btnCurve.getSelectionState() == 0 ? 1 : 0) != 0);
        } else if (e.widget == this.btnPalette) {
            ChartElementUtil.setEObjectAttribute((EObject)this.series, (String)"paletteLineColor", (Object)(this.btnPalette.getSelectionState() == 1 ? 1 : 0), (this.btnPalette.getSelectionState() == 0 ? 1 : 0) != 0);
        } else if (e.widget == this.btnMissingValue) {
            ChartElementUtil.setEObjectAttribute((EObject)this.series, (String)"connectMissingValue", (Object)(this.btnMissingValue.getSelectionState() == 1 ? 1 : 0), (this.btnMissingValue.getSelectionState() == 0 ? 1 : 0) != 0);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void handleEvent(Event event) {
        boolean isUnset;
        boolean bl = isUnset = event.detail == ChartUIExtensionUtil.PROPERTY_UNSET;
        if (event.widget.equals((Object)this.liacLine)) {
            if (event.type == 4) {
                ChartElementUtil.setEObjectAttribute((EObject)((LineSeries)this.series).getLineAttributes(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                this.enableLineSettings(!this.context.getUIFactory().isSetInvisible((EObject)((LineSeries)this.series).getLineAttributes()));
            } else if (event.type == 1) {
                ChartElementUtil.setEObjectAttribute((EObject)((LineSeries)this.series).getLineAttributes(), (String)"style", (Object)event.data, (boolean)isUnset);
            } else if (event.type == 2) {
                ChartElementUtil.setEObjectAttribute((EObject)((LineSeries)this.series).getLineAttributes(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
            } else if (event.type == 3) {
                ((LineSeries)this.series).getLineAttributes().setColor((ColorDefinition)event.data);
            }
        } else if (event.widget.equals((Object)this.fccShadow)) {
            ((LineSeries)this.series).setShadowColor((ColorDefinition)event.data);
        }
    }

    protected boolean isShadowNeeded() {
        return !(this.series instanceof AreaSeries) && this.context.getModel().getDimension().getValue() != 2;
    }

    protected void enableLineSettings(boolean isEnabled) {
        if (this.lblShadow != null) {
            this.lblShadow.setEnabled(isEnabled);
        }
        if (this.fccShadow != null) {
            this.fccShadow.setEnabled(isEnabled);
        }
        if (this.btnPalette != null) {
            this.btnPalette.setEnabled(isEnabled);
        }
        if (this.btnMissingValue != null) {
            this.btnMissingValue.setEnabled(isEnabled);
        }
        this.btnCurve.setEnabled(isEnabled);
    }
}

