/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.loader;

import com.ibm.icu.text.MessageFormat;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCForeignKey;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCPrimaryKey;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCUniqueConstraint;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.Messages;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.ReferentialActionType;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;

public class JDBCTableConstraintLoader
extends JDBCBaseLoader {
    public static final String COLUMN_COLUMN_NAME = "COLUMN_NAME";
    public static final String COLUMN_KEY_SEQ = "KEY_SEQ";
    public static final String COLUMN_PK_NAME = "PK_NAME";
    public static final String COLUMN_PKCOLUMN_NAME = "PKCOLUMN_NAME";
    public static final String COLUMN_PKTABLE_CAT = "PKTABLE_CAT";
    public static final String COLUMN_PKTABLE_SCHEM = "PKTABLE_SCHEM";
    public static final String COLUMN_PKTABLE_NAME = "PKTABLE_NAME";
    public static final String COLUMN_FKCOLUMN_NAME = "FKCOLUMN_NAME";
    public static final String COLUMN_UPDATE_RULE = "UPDATE_RULE";
    public static final String COLUMN_DELETE_RULE = "DELETE_RULE";
    public static final String COLUMN_FK_NAME = "FK_NAME";
    public static final String COLUMN_DEFERRABILITY = "DEFERRABILITY";

    public JDBCTableConstraintLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public JDBCTableConstraintLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        if (catalogObject != null) assert (catalogObject instanceof Table);
    }

    public PrimaryKey loadPrimaryKey() throws SQLException {
        return this.loadPrimaryKey(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrimaryKey loadPrimaryKey(PrimaryKey existingPK) throws SQLException {
        ResultSet rs = null;
        try {
            TreeMap<Integer, Column> columns = new TreeMap<Integer, Column>();
            PrimaryKey pk = null;
            rs = this.createPrimaryKeyResultSet();
            while (rs.next()) {
                if (pk == null) {
                    String pkName = rs.getString(COLUMN_PK_NAME);
                    if (pkName == null) {
                        if (rs != null) {
                            this.closeResultSet(rs);
                        }
                        return null;
                    }
                    if (existingPK != null && pkName.equals(existingPK.getName())) {
                        pk = existingPK;
                        pk.getMembers().clear();
                        if (existingPK instanceof ICatalogObject) {
                            ((ICatalogObject)pk).refresh();
                        }
                    } else {
                        pk = this.createPrimaryKey();
                        pk.setName(pkName);
                    }
                }
                columns.put(new Integer(rs.getShort(COLUMN_KEY_SEQ)), this.findColumn(rs.getString(COLUMN_COLUMN_NAME)));
            }
            Iterator it = columns.values().iterator();
            while (true) {
                if (!it.hasNext()) {
                    PrimaryKey primaryKey = pk;
                    if (rs != null) {
                        this.closeResultSet(rs);
                    }
                    return primaryKey;
                }
                pk.getMembers().add(it.next());
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                this.closeResultSet(rs);
            }
            throw throwable;
        }
    }

    public Collection loadUniqueConstraints(PrimaryKey pk) throws SQLException {
        ArrayList retVal = new ArrayList();
        this.loadUniqueConstraints(pk, retVal, Collections.EMPTY_SET);
        return retVal;
    }

    public void loadUniqueConstraints(PrimaryKey pk, List containmentList, Collection existingUCs) throws SQLException {
        ResultSet rs = null;
        if (pk != null) {
            existingUCs.remove(pk);
        }
        try {
            HashMap<String, UniqueConstraint> constraints = new HashMap<String, UniqueConstraint>();
            HashMap constraintColumns = new HashMap();
            rs = this.createUniqueConstraintResultSet();
            while (rs.next()) {
                String ucName = rs.getString(COLUMN_PK_NAME);
                if (ucName.equals(pk == null ? null : pk.getName())) continue;
                if (!constraints.containsKey(ucName)) {
                    UniqueConstraint uc = (UniqueConstraint)this.getAndRemoveSQLObject(existingUCs, ucName);
                    if (uc == null) {
                        uc = this.createUniqueConstraint();
                        uc.setName(ucName);
                    } else {
                        uc.getMembers().clear();
                        if (uc instanceof ICatalogObject) {
                            ((ICatalogObject)uc).refresh();
                        }
                    }
                    containmentList.add(uc);
                    constraints.put(ucName, uc);
                    constraintColumns.put(ucName, new TreeMap());
                }
                ((Map)constraintColumns.get(ucName)).put(new Integer(rs.getShort(COLUMN_KEY_SEQ)), this.findColumn(rs.getString(COLUMN_PKCOLUMN_NAME)));
            }
            for (Map.Entry entry : constraints.entrySet()) {
                UniqueConstraint uc = (UniqueConstraint)entry.getValue();
                Iterator colIt = ((Map)constraintColumns.get(uc.getName())).values().iterator();
                while (colIt.hasNext()) {
                    uc.getMembers().add(colIt.next());
                }
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                this.closeResultSet(rs);
            }
            throw throwable;
        }
        if (rs != null) {
            this.closeResultSet(rs);
        }
    }

    public Collection loadForeignKeys() throws SQLException {
        ArrayList retVal = new ArrayList();
        this.loadForeignKeys(retVal, Collections.EMPTY_SET);
        return retVal;
    }

    public void loadForeignKeys(List containmentList, Collection existingFKs) throws SQLException {
        ResultSet rs = null;
        try {
            HashMap<String, ForeignKey> constraints = new HashMap<String, ForeignKey>();
            HashMap constraintColumns = new HashMap();
            rs = this.createForeignKeyResultSet();
            while (rs.next()) {
                String fkName = rs.getString(COLUMN_FK_NAME);
                if (!constraints.containsKey(fkName)) {
                    ForeignKey fk = (ForeignKey)this.getAndRemoveSQLObject(existingFKs, fkName);
                    if (fk == null) {
                        fk = this.createForeignKey();
                        fk.setName(fkName);
                    } else {
                        fk.getMembers().clear();
                        if (fk instanceof ICatalogObject) {
                            ((ICatalogObject)fk).refresh();
                        }
                    }
                    switch (rs.getShort(COLUMN_UPDATE_RULE)) {
                        case 0: {
                            fk.setOnUpdate(ReferentialActionType.CASCADE_LITERAL);
                            break;
                        }
                        case 1: {
                            fk.setOnUpdate(ReferentialActionType.RESTRICT_LITERAL);
                            break;
                        }
                        case 4: {
                            fk.setOnUpdate(ReferentialActionType.SET_DEFAULT_LITERAL);
                            break;
                        }
                        case 2: {
                            fk.setOnUpdate(ReferentialActionType.SET_NULL_LITERAL);
                            break;
                        }
                        default: {
                            fk.setOnUpdate(ReferentialActionType.NO_ACTION_LITERAL);
                        }
                    }
                    switch (rs.getShort(COLUMN_DELETE_RULE)) {
                        case 0: {
                            fk.setOnDelete(ReferentialActionType.CASCADE_LITERAL);
                            break;
                        }
                        case 1: {
                            fk.setOnDelete(ReferentialActionType.RESTRICT_LITERAL);
                            break;
                        }
                        case 4: {
                            fk.setOnDelete(ReferentialActionType.SET_DEFAULT_LITERAL);
                            break;
                        }
                        case 2: {
                            fk.setOnDelete(ReferentialActionType.SET_NULL_LITERAL);
                            break;
                        }
                        default: {
                            fk.setOnDelete(ReferentialActionType.NO_ACTION_LITERAL);
                        }
                    }
                    switch (rs.getShort(COLUMN_DEFERRABILITY)) {
                        case 5: {
                            fk.setDeferrable(true);
                            fk.setInitiallyDeferred(true);
                            break;
                        }
                        case 6: {
                            fk.setDeferrable(true);
                            fk.setInitiallyDeferred(false);
                            break;
                        }
                        default: {
                            fk.setDeferrable(false);
                        }
                    }
                    UniqueConstraint uk = this.findUniqueConstraint(rs.getString(COLUMN_PKTABLE_CAT), rs.getString(COLUMN_PKTABLE_SCHEM), rs.getString(COLUMN_PKTABLE_NAME), rs.getString(COLUMN_PK_NAME));
                    if (uk == null) continue;
                    fk.setUniqueConstraint(uk);
                    containmentList.add(fk);
                    constraints.put(fkName, fk);
                    constraintColumns.put(fkName, new TreeMap());
                }
                ((Map)constraintColumns.get(fkName)).put(new Integer(rs.getShort(COLUMN_KEY_SEQ)), this.findColumn(rs.getString(COLUMN_FKCOLUMN_NAME)));
            }
            for (Map.Entry entry : constraints.entrySet()) {
                ForeignKey fk = (ForeignKey)entry.getValue();
                Iterator colIt = ((Map)constraintColumns.get(fk.getName())).values().iterator();
                while (colIt.hasNext()) {
                    fk.getMembers().add(colIt.next());
                }
                this.initReferenceAnnotation(fk);
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                this.closeResultSet(rs);
            }
            throw throwable;
        }
        if (rs != null) {
            this.closeResultSet(rs);
        }
    }

    public void clearConstraints(EList constraintContainer, List remove) {
        constraintContainer.removeAll((Collection)remove);
    }

    protected ResultSet createPrimaryKeyResultSet() throws SQLException {
        try {
            Table table = this.getTable();
            Schema schema = table.getSchema();
            return this.getCatalogObject().getConnection().getMetaData().getPrimaryKeys(schema.getCatalog().getName(), schema.getName(), table.getName());
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getPrimaryKeys()"}));
            error.initCause(e);
            throw error;
        }
    }

    protected ResultSet createUniqueConstraintResultSet() throws SQLException {
        try {
            Table table = this.getTable();
            Schema schema = table.getSchema();
            return this.getCatalogObject().getConnection().getMetaData().getExportedKeys(schema.getCatalog().getName(), schema.getName(), table.getName());
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getExportedKeys()"}));
            error.initCause(e);
            throw error;
        }
    }

    protected ResultSet createForeignKeyResultSet() throws SQLException {
        try {
            Table table = this.getTable();
            Schema schema = table.getSchema();
            return this.getCatalogObject().getConnection().getMetaData().getImportedKeys(schema.getCatalog().getName(), schema.getName(), table.getName());
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getImportedKeys()"}));
            error.initCause(e);
            throw error;
        }
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {}
    }

    protected PrimaryKey createPrimaryKey() {
        return new JDBCPrimaryKey();
    }

    protected UniqueConstraint createUniqueConstraint() {
        return new JDBCUniqueConstraint();
    }

    protected ForeignKey createForeignKey() {
        return new JDBCForeignKey();
    }

    protected Table getTable() {
        return (Table)this.getCatalogObject();
    }

    protected void initReferenceAnnotation(ForeignKey fk) {
        EAnnotation eAnnotation = fk.addEAnnotation(RDBCorePlugin.FK_MODELING_RELATIONSHIP);
        fk.addEAnnotationDetail(eAnnotation, RDBCorePlugin.FK_IS_IDENTIFYING_RELATIONSHIP, new Boolean(this.foreignKeyIsIdentifyingRelationship(fk)).toString());
        fk.addEAnnotationDetail(eAnnotation, RDBCorePlugin.FK_CHILD_MULTIPLICITY, RDBCorePlugin.MANY);
        fk.addEAnnotationDetail(eAnnotation, RDBCorePlugin.FK_CHILD_ROLE_NAME, new String());
        fk.addEAnnotationDetail(eAnnotation, RDBCorePlugin.FK_PARENT_MULTIPLICITY, fk.getMembers().size() > 0 ? RDBCorePlugin.ZERO_TO_ONE : RDBCorePlugin.ONE);
        fk.addEAnnotationDetail(eAnnotation, RDBCorePlugin.FK_PARENT_ROLE_NAME, new String());
    }

    protected boolean foreignKeyIsIdentifyingRelationship(ForeignKey fk) {
        boolean isIdentifying = true;
        for (Column column : fk.getMembers()) {
            if (column.isPartOfPrimaryKey()) continue;
            isIdentifying = false;
            break;
        }
        return isIdentifying;
    }

    protected Column findColumn(String columnName) {
        if (columnName == null) {
            return null;
        }
        for (Column column : this.getTable().getColumns()) {
            if (!columnName.equals(column.getName())) continue;
            return column;
        }
        return null;
    }

    protected UniqueConstraint findUniqueConstraint(String catalogName, String schemaName, String tableName, String keyName) {
        if (keyName == null) {
            return null;
        }
        Table table = this.findTable(catalogName, schemaName, tableName);
        if (table == null || !(table instanceof BaseTable)) {
            return null;
        }
        for (UniqueConstraint uc : ((BaseTable)table).getUniqueConstraints()) {
            if (!keyName.equals(uc.getName())) continue;
            return uc;
        }
        return null;
    }

    protected Table findTable(String catalogName, String schemaName, String tableName) {
        if (tableName == null) {
            return null;
        }
        if (catalogName == null) {
            catalogName = this.getTable().getSchema().getCatalog().getName();
            try {
                if (this.getCatalogObject().getConnection().getMetaData().supportsCatalogsInTableDefinitions()) {
                    catalogName = new String();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (schemaName == null) {
            schemaName = this.getTable().getSchema().getName();
            try {
                if (this.getCatalogObject().getConnection().getMetaData().supportsSchemasInTableDefinitions()) {
                    schemaName = new String();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        Database db = this.getCatalogObject().getCatalogDatabase();
        for (Catalog catalog : db.getCatalogs()) {
            if (!catalogName.equals(catalog.getName())) continue;
            for (Schema schema : catalog.getSchemas()) {
                if (!schemaName.equals(schema.getName())) continue;
                for (Table table : schema.getTables()) {
                    if (!tableName.equals(table.getName())) continue;
                    return table;
                }
            }
        }
        return null;
    }
}

