/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.editor;

import java.util.HashMap;
import org.eclipse.app4mc.amalthea.model.editor.util.AmaltheaEditorUtil;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class DummyAmaltheaEditor
extends EditorPart {
    private static final String AMALTHEA_MODEL_EDITOR = "AMALTHEA Model Editor";
    private Label contents;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        IFile iFile = AmaltheaEditorUtil.getIFile(input);
        boolean isValidVersion = AmaltheaEditorUtil.isNamespaceValid(iFile);
        if (!isValidVersion) {
            this.showInvalidVersionDialog(iFile);
            this.closeEditor();
        }
    }

    private void showInvalidVersionDialog(IFile iFile) {
        IEclipseContext context;
        String versionFromModel = AmaltheaEditorUtil.getModelVersion(iFile);
        String versionFromMetaModel = ModelUtil.MODEL_VERSION;
        String versionMismatchMessage = NLS.bind((String)"Unsupported File ! \r\rEditor could not be opened because of a version mismatch. \r\rFound AMALTHEA model version : {0}\rCurrent editor supports only AMALTHEA model version :  {1}", (Object[])new Object[]{versionFromModel, versionFromMetaModel});
        MApplication application = (MApplication)PlatformUI.getWorkbench().getService(MApplication.class);
        if (application != null && (context = application.getContext()) != null) {
            Object latestSupportedMigrationVersion = context.get("APP4MC_MODEL_MIGRATION_VERSION");
            if (latestSupportedMigrationVersion != null) {
                IEventBroker broker;
                MessageDialog dialog = new MessageDialog(this.getSite().getShell(), AMALTHEA_MODEL_EDITOR, null, String.valueOf(versionMismatchMessage) + "\r\r** Start AMALTHEA Model Migration utility to convert the model", 6, 0, new String[]{"Migrate to " + versionFromMetaModel, "Show Migration Dialog", "Cancel"});
                int result = dialog.open();
                if ((result == 0 || result == 1) && (broker = (IEventBroker)this.getSite().getService(IEventBroker.class)) != null) {
                    String executionContext = result == 0 ? "simplemigration" : "dialogmigration";
                    HashMap<String, String> args = new HashMap<String, String>();
                    args.put("type", executionContext);
                    args.put("version", versionFromMetaModel);
                    broker.send("org/eclipse/app4mc/amalthea/converter/CONVERT", args);
                }
            } else {
                MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)AMALTHEA_MODEL_EDITOR, (String)(String.valueOf(versionMismatchMessage) + "\r\r** AMALTHEA Model Migration utility is not available"));
            }
        }
    }

    private void closeEditor() {
        Display display = this.getSite().getShell().getDisplay();
        IWorkbenchPage page = this.getSite().getPage();
        if (display != null && page != null) {
            display.asyncExec(() -> {
                boolean bl = page.closeEditor((IEditorPart)this, false);
            });
        }
    }

    public void createPartControl(Composite parent) {
        this.contents = new Label(parent, 0);
        this.contents.setText("Model migration required.");
    }

    public void setFocus() {
        if (this.contents != null) {
            this.contents.setFocus();
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }
}

