/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.sim.software;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.AbstractMemoryElement;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.HwAccessElement;
import org.eclipse.app4mc.amalthea.model.IExecutable;
import org.eclipse.app4mc.amalthea.model.Memory;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.SchedulerAllocation;
import org.eclipse.app4mc.amalthea.model.util.DeploymentUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

class SimSoftwareMemoryAccessHelper {
    private SimSoftwareMemoryAccessHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean validate(ActivityGraphItem activityGraphItem, AbstractMemoryElement abstractMemoryElement) {
        Set memories = DeploymentUtil.getMapping((AbstractMemoryElement)abstractMemoryElement);
        if (memories.isEmpty() || memories.size() > 1) {
            return true;
        }
        HashSet processingUnits = new HashSet();
        Runnable containingRunnable = SimSoftwareMemoryAccessHelper.getContainingRunnable(activityGraphItem);
        if (containingRunnable != null) {
            EList runnableCalls = containingRunnable.getRunnableCalls();
            for (RunnableCall runnableCall : runnableCalls) {
                Process containingProcess = SimSoftwareMemoryAccessHelper.getContainingProcess((ActivityGraphItem)runnableCall);
                if (containingProcess == null) continue;
                processingUnits.addAll(DeploymentUtil.getAssignedCoreForProcess((Process)containingProcess));
            }
        } else {
            Process containingProcess = SimSoftwareMemoryAccessHelper.getContainingProcess(activityGraphItem);
            if (containingProcess != null) {
                processingUnits.addAll(DeploymentUtil.getAssignedCoreForProcess((Process)containingProcess));
            } else if (activityGraphItem.eContainingFeature() instanceof Scheduler) {
                Scheduler scheduler = (Scheduler)activityGraphItem.eContainingFeature();
                for (SchedulerAllocation schedulerAllocation : AmaltheaIndex.getReferringObjects((EObject)scheduler, SchedulerAllocation.class)) {
                    processingUnits.addAll(schedulerAllocation.getResponsibility());
                }
            }
        }
        if (processingUnits.isEmpty()) {
            return true;
        }
        for (ProcessingUnit processingUnit : processingUnits) {
            for (Memory memory : memories) {
                Set hwAccessElements = AmaltheaIndex.getReferringObjects((EObject)memory, HwAccessElement.class);
                boolean foundAccessElement = false;
                for (HwAccessElement hwAccessElement : hwAccessElements) {
                    if (hwAccessElement.getSource() != processingUnit) continue;
                    foundAccessElement = true;
                    break;
                }
                if (foundAccessElement) continue;
                return false;
            }
        }
        return true;
    }

    private static Process getContainingProcess(ActivityGraphItem item) {
        IExecutable exec = item.getContainingExecutable();
        return exec instanceof Process ? (Process)exec : null;
    }

    private static Runnable getContainingRunnable(ActivityGraphItem item) {
        IExecutable exec = item.getContainingExecutable();
        return exec instanceof Runnable ? (Runnable)exec : null;
    }
}

