/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.ClearEvent;
import org.eclipse.app4mc.amalthea.model.Condition;
import org.eclipse.app4mc.amalthea.model.ConditionConjunction;
import org.eclipse.app4mc.amalthea.model.ConditionDisjunction;
import org.eclipse.app4mc.amalthea.model.ConditionDisjunctionEntry;
import org.eclipse.app4mc.amalthea.model.EnumMode;
import org.eclipse.app4mc.amalthea.model.ExecutionNeed;
import org.eclipse.app4mc.amalthea.model.Group;
import org.eclipse.app4mc.amalthea.model.IActivityGraphItemContainer;
import org.eclipse.app4mc.amalthea.model.IExecutable;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.LabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.LabelAccessStatistic;
import org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.ModeLabelCondition;
import org.eclipse.app4mc.amalthea.model.ModeLiteral;
import org.eclipse.app4mc.amalthea.model.ModeValueCondition;
import org.eclipse.app4mc.amalthea.model.NumericMode;
import org.eclipse.app4mc.amalthea.model.NumericStatistic;
import org.eclipse.app4mc.amalthea.model.ProbabilitySwitch;
import org.eclipse.app4mc.amalthea.model.ProbabilitySwitchEntry;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.RelationalOperator;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.ServerCall;
import org.eclipse.app4mc.amalthea.model.SetEvent;
import org.eclipse.app4mc.amalthea.model.SingleValueStatistic;
import org.eclipse.app4mc.amalthea.model.Switch;
import org.eclipse.app4mc.amalthea.model.SwitchEntry;
import org.eclipse.app4mc.amalthea.model.Ticks;
import org.eclipse.app4mc.amalthea.model.WaitEvent;
import org.eclipse.app4mc.amalthea.model.WhileLoop;
import org.eclipse.app4mc.amalthea.model.util.RuntimeUtil;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.jdt.annotation.NonNull;

public class SoftwareUtil {
    private SoftwareUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static EList<ActivityGraphItem> collectActivityGraphItems(IActivityGraphItemContainer container) {
        return SoftwareUtil.collectActivityGraphItems(container, null, ActivityGraphItem.class, null);
    }

    public static EList<ActivityGraphItem> collectActivityGraphItems(IActivityGraphItemContainer container, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems(container, modes, ActivityGraphItem.class, null);
    }

    public static EList<ActivityGraphItem> collectActivityGraphItems(IActivityGraphItemContainer container, EMap<ModeLabel, String> modes, Function<ActivityGraphItem, Boolean> filter) {
        return SoftwareUtil.collectActivityGraphItems(container, modes, ActivityGraphItem.class, filter);
    }

    public static <T extends ActivityGraphItem> EList<T> collectActivityGraphItems(IActivityGraphItemContainer container, EMap<ModeLabel, String> modes, Class<T> targetClass) {
        return SoftwareUtil.collectActivityGraphItems(container, modes, targetClass, null);
    }

    public static <T extends ActivityGraphItem> EList<T> collectActivityGraphItems(IActivityGraphItemContainer container, EMap<ModeLabel, String> modes, Class<T> targetClass, Function<T, Boolean> filter) {
        BasicEList itemList = new BasicEList();
        if (container != null) {
            SoftwareUtil.collectActivityGraphItems(container.getItems(), modes, targetClass, filter, itemList);
        }
        return itemList;
    }

    private static <T extends ActivityGraphItem> void collectActivityGraphItems(EList<ActivityGraphItem> input, EMap<ModeLabel, String> modes, Class<T> targetClass, Function<T, Boolean> filter, List<T> itemList) {
        for (ActivityGraphItem item : input) {
            if (item instanceof Group) {
                SoftwareUtil.collectActivityGraphItems((EList<ActivityGraphItem>)((Group)item).getItems(), modes, targetClass, filter, itemList);
                continue;
            }
            if (item instanceof WhileLoop) {
                SoftwareUtil.collectWhileLoopItems((WhileLoop)item, modes, targetClass, filter, itemList);
                continue;
            }
            if (item instanceof Switch) {
                SoftwareUtil.collectSwitchItems((Switch)item, modes, targetClass, filter, itemList);
                continue;
            }
            if (item instanceof Switch) {
                SoftwareUtil.collectModeSwitchItems((Switch)item, modes, targetClass, filter, itemList);
                continue;
            }
            if (item instanceof ProbabilitySwitch) {
                for (ProbabilitySwitchEntry pse : ((ProbabilitySwitch)item).getEntries()) {
                    SoftwareUtil.collectActivityGraphItems((EList<ActivityGraphItem>)pse.getItems(), modes, targetClass, filter, itemList);
                }
                continue;
            }
            if (!targetClass.isInstance(item)) continue;
            ActivityGraphItem castedItem = (ActivityGraphItem)targetClass.cast(item);
            if (filter != null && !filter.apply(castedItem).booleanValue()) continue;
            itemList.add(castedItem);
        }
    }

    private static <T extends ActivityGraphItem> void collectWhileLoopItems(WhileLoop loop, EMap<ModeLabel, String> modes, Class<T> targetClass, Function<T, Boolean> filter, List<T> itemList) {
        SoftwareUtil.collectActivityGraphItems((EList<ActivityGraphItem>)loop.getItems(), modes, targetClass, filter, itemList);
    }

    private static <T extends ActivityGraphItem> void collectSwitchItems(Switch genericSwitch, EMap<ModeLabel, String> modes, Class<T> targetClass, Function<T, Boolean> filter, List<T> itemList) {
        boolean includeDefault = true;
        for (SwitchEntry se : genericSwitch.getEntries()) {
            if (modes == null) {
                SoftwareUtil.collectActivityGraphItems((EList<ActivityGraphItem>)se.getItems(), modes, targetClass, filter, itemList);
                continue;
            }
            if (!SoftwareUtil.conditionIsSatisfiedBy(se.getCondition(), modes)) continue;
            SoftwareUtil.collectActivityGraphItems((EList<ActivityGraphItem>)se.getItems(), modes, targetClass, filter, itemList);
            includeDefault = false;
            break;
        }
        if (includeDefault && genericSwitch.getDefaultEntry() != null) {
            SoftwareUtil.collectActivityGraphItems((EList<ActivityGraphItem>)genericSwitch.getDefaultEntry().getItems(), modes, targetClass, filter, itemList);
        }
    }

    private static <T extends ActivityGraphItem> void collectModeSwitchItems(Switch modeSwitch, EMap<ModeLabel, String> modes, Class<T> targetClass, Function<T, Boolean> filter, List<T> itemList) {
        boolean includeDefault = true;
        for (SwitchEntry mse : modeSwitch.getEntries()) {
            if (modes == null) {
                SoftwareUtil.collectActivityGraphItems((EList<ActivityGraphItem>)mse.getItems(), modes, targetClass, filter, itemList);
                continue;
            }
            if (!SoftwareUtil.conditionIsSatisfiedBy(mse.getCondition(), modes)) continue;
            SoftwareUtil.collectActivityGraphItems((EList<ActivityGraphItem>)mse.getItems(), modes, targetClass, filter, itemList);
            includeDefault = false;
            break;
        }
        if (includeDefault && modeSwitch.getDefaultEntry() != null) {
            SoftwareUtil.collectActivityGraphItems((EList<ActivityGraphItem>)modeSwitch.getDefaultEntry().getItems(), modes, targetClass, filter, itemList);
        }
    }

    public static boolean conditionIsSatisfiedBy(Object condition, EMap<ModeLabel, String> context) {
        if (context == null) {
            return true;
        }
        if (condition instanceof ConditionDisjunction) {
            return SoftwareUtil.conditionIsSatisfiedBy((ConditionDisjunction)condition, context);
        }
        if (condition instanceof ConditionConjunction) {
            return SoftwareUtil.conditionIsSatisfiedBy((ConditionConjunction)condition, context);
        }
        if (condition instanceof ModeValueCondition) {
            return SoftwareUtil.conditionIsSatisfiedBy((ModeValueCondition)condition, context);
        }
        if (condition instanceof ModeLabelCondition) {
            return SoftwareUtil.conditionIsSatisfiedBy((ModeLabelCondition)condition, context);
        }
        return true;
    }

    public static boolean conditionIsSatisfiedBy(ConditionDisjunction condition, EMap<ModeLabel, String> context) {
        if (context == null) {
            return true;
        }
        for (ConditionDisjunctionEntry entry : condition.getEntries()) {
            if (!SoftwareUtil.conditionIsSatisfiedBy(entry, context)) continue;
            return true;
        }
        return false;
    }

    public static boolean conditionIsSatisfiedBy(ConditionConjunction condition, EMap<ModeLabel, String> context) {
        if (context == null) {
            return true;
        }
        for (Condition entry : condition.getEntries()) {
            if (SoftwareUtil.conditionIsSatisfiedBy(entry, context)) continue;
            return false;
        }
        return true;
    }

    public static boolean conditionIsSatisfiedBy(ModeValueCondition condition, EMap<ModeLabel, String> context) {
        if (context == null) {
            return true;
        }
        ModeLabel label = condition.getLabel();
        RelationalOperator relation = condition.getRelation();
        if (label == null || relation == RelationalOperator._UNDEFINED_) {
            return false;
        }
        String labelValue = (String)context.get((Object)label);
        return labelValue == null || SoftwareUtil.isTrue(label, label, relation, labelValue, condition.getValue());
    }

    public static boolean conditionIsSatisfiedBy(ModeLabelCondition condition, EMap<ModeLabel, String> context) {
        if (context == null) {
            return true;
        }
        ModeLabel label1 = condition.getLabel1();
        ModeLabel label2 = condition.getLabel2();
        RelationalOperator relation = condition.getRelation();
        if (label1 == null || label2 == null || relation == RelationalOperator._UNDEFINED_) {
            return false;
        }
        String labelValue1 = (String)context.get((Object)label1);
        String labelValue2 = (String)context.get((Object)label2);
        return labelValue1 == null || labelValue2 == null || SoftwareUtil.isTrue(label1, label2, relation, labelValue1, labelValue2);
    }

    private static boolean isTrue(ModeLabel label1, ModeLabel label2, RelationalOperator relation, String labelValue1, String labelValue2) {
        if (label1 == null || label1.getMode() == null || label2 == null || label2.getMode() == null || label1.getMode() != label2.getMode()) {
            return false;
        }
        if (label1.getMode() instanceof EnumMode) {
            ModeLiteral literal1 = ((EnumMode)label1.getMode()).getLiteral(labelValue1);
            ModeLiteral literal2 = ((EnumMode)label2.getMode()).getLiteral(labelValue2);
            if (literal1 == null || literal2 == null) {
                return false;
            }
            switch (relation) {
                case EQUAL: {
                    return literal1 == literal2;
                }
                case NOT_EQUAL: {
                    return literal1 != literal2;
                }
            }
        }
        if (label1.getMode() instanceof NumericMode) {
            Integer int1 = Ints.tryParse((String)labelValue1);
            Integer int2 = Ints.tryParse((String)labelValue2);
            if (int1 == null || int2 == null) {
                return false;
            }
            switch (relation) {
                case EQUAL: {
                    return int1.equals(int2);
                }
                case NOT_EQUAL: {
                    return !int1.equals(int2);
                }
                case GREATER_THAN: {
                    return int1 > int2;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return int1 >= int2;
                }
                case LESS_THAN: {
                    return int1 < int2;
                }
                case LESS_THAN_OR_EQUAL: {
                    return int1 <= int2;
                }
            }
        }
        return false;
    }

    public static Set<Label> getAccessedLabelSet(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)runnable.getActivityGraph(), modes, LabelAccess.class).stream().map(LabelAccess::getData).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Set<Label> getReadLabelSet(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems(runnable.getActivityGraph(), modes, LabelAccess.class, la -> la.getAccess() == LabelAccessEnum.READ).stream().map(LabelAccess::getData).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Set<Label> getWriteLabelSet(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems(runnable.getActivityGraph(), modes, LabelAccess.class, la -> la.getAccess() == LabelAccessEnum.WRITE).stream().map(LabelAccess::getData).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static List<LabelAccess> getLabelAccessList(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)runnable.getActivityGraph(), modes, LabelAccess.class);
    }

    public static List<LabelAccess> getReadLabelAccessList(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems(runnable.getActivityGraph(), modes, LabelAccess.class, la -> la.getAccess() == LabelAccessEnum.READ);
    }

    public static List<LabelAccess> getWriteLabelAccessList(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems(runnable.getActivityGraph(), modes, LabelAccess.class, la -> la.getAccess() == LabelAccessEnum.WRITE);
    }

    public static Map<Label, List<LabelAccess>> getLabelToLabelAccessMap(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems(runnable.getActivityGraph(), modes, LabelAccess.class, la -> la.getData() != null).stream().collect(Collectors.groupingBy(LabelAccess::getData));
    }

    public static Map<Label, List<LabelAccessStatistic>> getLabelAccessStatisticsMap(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems(runnable.getActivityGraph(), modes, LabelAccess.class, la -> la.getData() != null && la.getStatistic() != null).stream().collect(Collectors.groupingBy(LabelAccess::getData, Collectors.mapping(LabelAccess::getStatistic, Collectors.toList())));
    }

    public static Map<Label, List<LabelAccessStatistic>> getReadLabelAccessStatisticsMap(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems(runnable.getActivityGraph(), modes, LabelAccess.class, la -> la.getData() != null && la.getStatistic() != null && la.getAccess() == LabelAccessEnum.READ).stream().collect(Collectors.groupingBy(LabelAccess::getData, Collectors.mapping(LabelAccess::getStatistic, Collectors.toList())));
    }

    public static Map<Label, List<LabelAccessStatistic>> getWriteLabelAccessStatisticsMap(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems(runnable.getActivityGraph(), modes, LabelAccess.class, la -> la.getData() != null && la.getStatistic() != null && la.getAccess() == LabelAccessEnum.WRITE).stream().collect(Collectors.groupingBy(LabelAccess::getData, Collectors.mapping(LabelAccess::getStatistic, Collectors.toList())));
    }

    public static Set<Label> getAccessedLabelSet(Process process, EMap<ModeLabel, String> modes) {
        HashSet<Label> result = new HashSet<Label>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getAccessedLabelSet(r, modes));
        }
        return result;
    }

    public static Set<Label> getReadLabelSet(Process process, EMap<ModeLabel, String> modes) {
        HashSet<Label> result = new HashSet<Label>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getReadLabelSet(r, modes));
        }
        return result;
    }

    public static Set<Label> getWriteLabelSet(Process process, EMap<ModeLabel, String> modes) {
        HashSet<Label> result = new HashSet<Label>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getWriteLabelSet(r, modes));
        }
        return result;
    }

    public static List<LabelAccess> getLabelAccessList(Process process, EMap<ModeLabel, String> modes) {
        ArrayList<LabelAccess> result = new ArrayList<LabelAccess>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getLabelAccessList(r, modes));
        }
        return result;
    }

    public static Map<Label, List<LabelAccess>> getLabelToLabelAccessMap(Process process, EMap<ModeLabel, String> modes) {
        HashMap<Label, List<LabelAccess>> result = new HashMap<Label, List<LabelAccess>>();
        for (Runnable run : SoftwareUtil.getRunnableList(process, modes)) {
            Map<Label, List<LabelAccess>> labelToLabelAccessMap = SoftwareUtil.getLabelToLabelAccessMap(run, modes);
            for (Map.Entry<Label, List<LabelAccess>> entry : labelToLabelAccessMap.entrySet()) {
                Label label = entry.getKey();
                List<LabelAccess> accesses = entry.getValue();
                List accessList = result.computeIfAbsent(label, k -> new ArrayList());
                accessList.addAll(accesses);
            }
        }
        return result;
    }

    public static Map<Label, List<LabelAccessStatistic>> getLabelAccessStatisticsMap(Process process, EMap<ModeLabel, String> modes) {
        HashMap<Label, List<LabelAccessStatistic>> result = new HashMap<Label, List<LabelAccessStatistic>>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            Map<Label, List<LabelAccessStatistic>> labelToLabelAccessMap = SoftwareUtil.getLabelAccessStatisticsMap(r, modes);
            for (Map.Entry<Label, List<LabelAccessStatistic>> entry : labelToLabelAccessMap.entrySet()) {
                Label label = entry.getKey();
                List<LabelAccessStatistic> statistics = entry.getValue();
                List statisticsList = result.computeIfAbsent(label, k -> new ArrayList());
                statisticsList.addAll(statistics);
            }
        }
        return result;
    }

    public static Map<Label, List<LabelAccessStatistic>> getReadLabelAccessStatisticsMap(Process process, EMap<ModeLabel, String> modes) {
        HashMap<Label, List<LabelAccessStatistic>> result = new HashMap<Label, List<LabelAccessStatistic>>();
        for (Runnable run : SoftwareUtil.getRunnableList(process, modes)) {
            Map<Label, List<LabelAccessStatistic>> readLabelAccessStatisticsMap = SoftwareUtil.getReadLabelAccessStatisticsMap(run, modes);
            for (Map.Entry<Label, List<LabelAccessStatistic>> entry : readLabelAccessStatisticsMap.entrySet()) {
                Label label = entry.getKey();
                List<LabelAccessStatistic> statistics = entry.getValue();
                List statisticsList = result.computeIfAbsent(label, k -> new ArrayList());
                statisticsList.addAll(statistics);
            }
        }
        return result;
    }

    public static Map<Label, List<LabelAccessStatistic>> getWriteLabelAccessStatisticsMap(Process process, EMap<ModeLabel, String> modes) {
        HashMap<Label, List<LabelAccessStatistic>> result = new HashMap<Label, List<LabelAccessStatistic>>();
        for (Runnable run : SoftwareUtil.getRunnableList(process, modes)) {
            Map<Label, List<LabelAccessStatistic>> writeLabelAcessStatisticsMap = SoftwareUtil.getWriteLabelAccessStatisticsMap(run, modes);
            for (Map.Entry<Label, List<LabelAccessStatistic>> entry : writeLabelAcessStatisticsMap.entrySet()) {
                Label label = entry.getKey();
                List<LabelAccessStatistic> statistics = entry.getValue();
                List statisticsList = result.computeIfAbsent(label, k -> new ArrayList());
                statisticsList.addAll(statistics);
            }
        }
        return result;
    }

    public static float getLabelReadCount(Label label, Process process, EMap<ModeLabel, String> modes, RuntimeUtil.TimeType timeType) {
        if (timeType == null) {
            timeType = RuntimeUtil.TimeType.ACET;
        }
        EList<@NonNull LabelAccess> accessList = SoftwareUtil.collectActivityGraphItems(process.getActivityGraph(), modes, LabelAccess.class, la -> la.getAccess() == LabelAccessEnum.READ && la.getData() == label);
        return SoftwareUtil.sumUpLabelAccesses(timeType, accessList);
    }

    public static float getLabelWriteCount(Label label, Process process, EMap<ModeLabel, String> modes, RuntimeUtil.TimeType timeType) {
        if (timeType == null) {
            timeType = RuntimeUtil.TimeType.ACET;
        }
        EList<@NonNull LabelAccess> accessList = SoftwareUtil.collectActivityGraphItems(process.getActivityGraph(), modes, LabelAccess.class, la -> la.getAccess() == LabelAccessEnum.WRITE && la.getData() == label);
        return SoftwareUtil.sumUpLabelAccesses(timeType, accessList);
    }

    private static float sumUpLabelAccesses(RuntimeUtil.TimeType timeType, EList<@NonNull LabelAccess> accessList) {
        float accesses = 0.0f;
        for (LabelAccess la : accessList) {
            if (la.getStatistic() == null || la.getStatistic().getValue() == null) {
                accesses += 1.0f;
                continue;
            }
            NumericStatistic statistic = la.getStatistic().getValue();
            if (statistic instanceof SingleValueStatistic) {
                accesses += ((SingleValueStatistic)statistic).getValue();
                continue;
            }
            if (!(statistic instanceof MinAvgMaxStatistic)) continue;
            MinAvgMaxStatistic stat = (MinAvgMaxStatistic)statistic;
            switch (timeType) {
                case ACET: {
                    accesses += stat.getAvg();
                    break;
                }
                case BCET: {
                    accesses += (float)stat.getMin();
                    break;
                }
                case WCET: {
                    accesses += (float)stat.getMax();
                }
            }
        }
        return accesses;
    }

    public static List<Runnable> getRunnableList(Process process, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)process.getActivityGraph(), modes, RunnableCall.class).stream().map(RunnableCall::getRunnable).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Set<Runnable> getRunnableSet(Process process, EMap<ModeLabel, String> modes) {
        return new HashSet<Runnable>(SoftwareUtil.getRunnableList(process, modes));
    }

    public static float getLabelAccessCountFromStatistics(LabelAccess labelAcc, RuntimeUtil.TimeType accType) {
        if (labelAcc.getStatistic() == null) {
            return 1.0f;
        }
        float accesses = 1.0f;
        NumericStatistic value = labelAcc.getStatistic().getValue();
        if (value instanceof SingleValueStatistic) {
            accesses = ((SingleValueStatistic)value).getValue();
        } else if (value instanceof MinAvgMaxStatistic) {
            switch (accType) {
                case ACET: {
                    accesses = ((MinAvgMaxStatistic)value).getAvg();
                    break;
                }
                case BCET: {
                    accesses = ((MinAvgMaxStatistic)value).getMin();
                    break;
                }
                case WCET: {
                    accesses = ((MinAvgMaxStatistic)value).getMax();
                    break;
                }
                default: {
                    accesses = ((MinAvgMaxStatistic)value).getAvg();
                }
            }
        }
        return accesses;
    }

    public static List<Runnable> getReaderListOfLabel(Label label, EMap<ModeLabel, String> modes) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (LabelAccess la : label.getLabelAccesses()) {
            if (la.getAccess() != LabelAccessEnum.READ) continue;
            Runnable run = AmaltheaServices.getContainerOfType(la, Runnable.class);
            if (modes != null && !modes.isEmpty() && !SoftwareUtil.collectActivityGraphItems(run.getActivityGraph(), modes).contains((Object)la)) continue;
            result.add(AmaltheaServices.getContainerOfType(la, Runnable.class));
        }
        return result;
    }

    public static Set<Runnable> getReadersSetOfLabel(Label label, EMap<ModeLabel, String> modes) {
        return new HashSet<Runnable>(SoftwareUtil.getReaderListOfLabel(label, modes));
    }

    public static List<Runnable> getWriterListOfLabel(Label label, EMap<ModeLabel, String> modes) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (LabelAccess la : label.getLabelAccesses()) {
            if (!la.getAccess().equals((Object)LabelAccessEnum.WRITE)) continue;
            Runnable run = AmaltheaServices.getContainerOfType(la, Runnable.class);
            if (modes != null && !modes.isEmpty() && !SoftwareUtil.collectActivityGraphItems(run.getActivityGraph(), modes).contains((Object)la)) continue;
            result.add(AmaltheaServices.getContainerOfType(la, Runnable.class));
        }
        return result;
    }

    public static Set<Runnable> getWriterSetOfLabel(Label label, EMap<ModeLabel, String> modes) {
        return new HashSet<Runnable>(SoftwareUtil.getWriterListOfLabel(label, modes));
    }

    public static List<SetEvent> collectSetEvents(Process process, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)process.getActivityGraph(), modes, SetEvent.class);
    }

    public static List<ClearEvent> collectClearEvents(Process process, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)process.getActivityGraph(), modes, ClearEvent.class);
    }

    public static List<WaitEvent> collectWaitEvents(Process process, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)process.getActivityGraph(), modes, WaitEvent.class);
    }

    public static List<ActivityGraphItem> collectEventsOfProcess(Process process, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)process.getActivityGraph(), modes, (ActivityGraphItem call) -> call instanceof ClearEvent || call instanceof SetEvent || call instanceof WaitEvent);
    }

    public static List<Label> getInterTaskCommunication(Process sender, Process receiver, EMap<ModeLabel, String> modes) {
        ArrayList<Label> result = new ArrayList<Label>();
        result.addAll(SoftwareUtil.getWriteLabelSet(sender, modes));
        result.retainAll(SoftwareUtil.getReadLabelSet(receiver, modes));
        return result;
    }

    public static List<Process> getCallingProcesses(Runnable runnable, EMap<ModeLabel, String> modes) {
        ArrayList<Process> result = new ArrayList<Process>();
        block0: for (RunnableCall callerRC : runnable.getRunnableCalls()) {
            IExecutable caller = callerRC.getContainingExecutable();
            if (!(caller instanceof Process)) continue;
            Process proc = (Process)caller;
            if (modes != null && !modes.isEmpty()) {
                for (RunnableCall rc : SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)caller.getActivityGraph(), modes, RunnableCall.class)) {
                    if (rc.getRunnable() != runnable) continue;
                    result.add(proc);
                    continue block0;
                }
                continue;
            }
            result.add(proc);
        }
        return result;
    }

    public static List<Runnable> getCallingRunnables(Runnable runnable, EMap<ModeLabel, String> modes) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        block0: for (RunnableCall callerRC : runnable.getRunnableCalls()) {
            IExecutable caller = callerRC.getContainingExecutable();
            if (!(caller instanceof Runnable)) continue;
            Runnable run = (Runnable)caller;
            if (modes != null && !modes.isEmpty()) {
                for (RunnableCall rc : SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)caller.getActivityGraph(), modes, RunnableCall.class)) {
                    if (rc.getRunnable() != runnable) continue;
                    result.add(run);
                    continue block0;
                }
                continue;
            }
            result.add(run);
        }
        return result;
    }

    public static List<Runnable> getCalledRunnables(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)runnable.getActivityGraph(), modes, RunnableCall.class).stream().map(RunnableCall::getRunnable).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<ExecutionNeed> getExecutionNeeds(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)runnable.getActivityGraph(), modes, ExecutionNeed.class);
    }

    public static List<ExecutionNeed> getExecutionNeeds(Process process, EMap<ModeLabel, String> modes) {
        ArrayList<ExecutionNeed> result = new ArrayList<ExecutionNeed>();
        result.addAll((Collection<ExecutionNeed>)SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)process.getActivityGraph(), modes, ExecutionNeed.class));
        for (Runnable run : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getExecutionNeeds(run, modes));
        }
        return result;
    }

    public static List<Ticks> getTicks(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)runnable.getActivityGraph(), modes, Ticks.class);
    }

    public static List<Ticks> getTicks(Process process, EMap<ModeLabel, String> modes) {
        ArrayList<Ticks> result = new ArrayList<Ticks>();
        result.addAll((Collection<Ticks>)SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)process.getActivityGraph(), modes, Ticks.class));
        for (Runnable run : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getTicks(run, modes));
        }
        return result;
    }

    public static Set<ServerCall> getServerCallSet(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)runnable.getActivityGraph(), modes, ServerCall.class).stream().collect(Collectors.toSet());
    }

    public static Set<ServerCall> getServerCallSet(Process process, EMap<ModeLabel, String> modes) {
        HashSet<ServerCall> result = new HashSet<ServerCall>();
        for (Runnable run : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getServerCallSet(run, modes));
        }
        return result;
    }
}

