/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.editor.search;

import java.util.Collections;
import java.util.Optional;
import org.eclipse.app4mc.amalthea.model.editor.search.SearchMatch;
import org.eclipse.app4mc.amalthea.model.editor.search.SearchResultContentProvider;
import org.eclipse.app4mc.amalthea.model.editor.search.SearchResultLabelProvider;
import org.eclipse.app4mc.amalthea.model.editor.search.SearchResultTreeContentProvider;
import org.eclipse.app4mc.amalthea.model.editor.search.SearchResultTreeLabelProvider;
import org.eclipse.app4mc.amalthea.model.editor.util.AmaltheaEditorUtil;
import org.eclipse.app4mc.amalthea.model.presentation.AmaltheaUIPlugin;
import org.eclipse.app4mc.amalthea.model.presentation.ExtendedAmaltheaEditor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ModelSearchResultView
extends AbstractTextSearchViewPage {
    private SearchResultContentProvider contentProvider;
    private SearchResultTreeContentProvider contentTreeProvider;
    private final ToggleGroupViewAction toggleGroupViewAction = new ToggleGroupViewAction("Group by Type");

    public ModelSearchResultView() {
        super(3);
        Optional imgDesc = ResourceLocator.imageDescriptorFromBundle((String)AmaltheaUIPlugin.getPluginId(), (String)"/icons/full/obj16/presentation.gif");
        if (imgDesc.isPresent()) {
            this.toggleGroupViewAction.setImageDescriptor((ImageDescriptor)imgDesc.get());
        }
    }

    protected void elementsChanged(Object[] objects) {
        if (this.getLayout() == 1) {
            if (this.contentProvider != null) {
                this.contentProvider.addElements(objects);
            }
        } else if (this.contentTreeProvider != null) {
            this.contentTreeProvider.addElements(objects);
        }
        this.getViewer().refresh();
    }

    public Match[] getDisplayedMatches(Object element) {
        if (element instanceof TreeNode) {
            return super.getDisplayedMatches(((TreeNode)element).getValue());
        }
        return super.getDisplayedMatches(element);
    }

    public int getDisplayedMatchCount(Object element) {
        if (element instanceof TreeNode) {
            return super.getDisplayedMatchCount(((TreeNode)element).getValue());
        }
        return super.getDisplayedMatchCount(element);
    }

    protected void clear() {
        if (this.getLayout() == 1) {
            if (this.contentProvider != null) {
                this.contentProvider.clear();
            }
        } else if (this.contentTreeProvider != null) {
            this.contentTreeProvider.clear();
        }
        this.getViewer().refresh();
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        this.contentTreeProvider = new SearchResultTreeContentProvider();
        viewer.setContentProvider((IContentProvider)this.contentTreeProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new SearchResultTreeLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null));
    }

    protected void configureTableViewer(TableViewer viewer) {
        this.contentProvider = new SearchResultContentProvider();
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new SearchResultLabelProvider());
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        IWorkbenchPage page;
        IEditorPart editorPart;
        if (match == null || !(match.getElement() instanceof EObject)) {
            return;
        }
        EObject eObject = (EObject)match.getElement();
        IEditorInput editorInput = null;
        if (match instanceof SearchMatch) {
            editorInput = ((SearchMatch)match).getEditorInput();
        }
        if (editorInput == null) {
            editorInput = AmaltheaEditorUtil.getIEditorInput(eObject);
        }
        if ((editorPart = (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).openEditor(editorInput, "org.eclipse.app4mc.amalthea.model.editor.extended", true)) instanceof ExtendedAmaltheaEditor) {
            ((ExtendedAmaltheaEditor)editorPart).setSelectionToViewer(Collections.singleton(eObject));
        }
    }

    public void setLayout(int layout) {
        if (!this.isLayoutSupported(layout) || this.getLayout() == layout) {
            return;
        }
        this.getViewer().setSelection((ISelection)StructuredSelection.EMPTY, false);
        super.setLayout(layout);
    }

    protected void fillToolbar(IToolBarManager tbm) {
        super.fillToolbar(tbm);
        tbm.appendToGroup("group.viewerSetup", (IAction)this.toggleGroupViewAction);
    }

    private class ToggleGroupViewAction
    extends Action {
        public ToggleGroupViewAction(String text) {
            super(text, 2);
            this.setChecked(ModelSearchResultView.this.getLayout() == 2);
            this.setToolTipText(text);
        }

        public void run() {
            if (this.isChecked()) {
                ModelSearchResultView.this.setLayout(2);
            } else {
                ModelSearchResultView.this.setLayout(1);
            }
            ModelSearchResultView.this.getViewer().refresh();
        }
    }
}

