/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.editor.actions;

import java.util.regex.Pattern;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.editor.messages.Messages;
import org.eclipse.app4mc.amalthea.model.editor.search.ModelHitCollector;
import org.eclipse.app4mc.amalthea.model.editor.search.handlers.SearchDialog;
import org.eclipse.app4mc.amalthea.model.editor.search.handlers.SearchDialogSettings;
import org.eclipse.app4mc.amalthea.model.editor.util.AmaltheaEditorUtil;
import org.eclipse.app4mc.amalthea.model.presentation.AmaltheaUIPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SearchAction
extends Action {
    private IEditorPart editorPart;

    public SearchAction() {
        super(Messages.SearchAction_title, 1);
        this.setImageDescriptor(ResourceLocator.imageDescriptorFromBundle((String)AmaltheaUIPlugin.getPluginId(), (String)"/icons/full/obj16/find.gif").orElse(null));
        this.setToolTipText(Messages.SearchGUI_title);
    }

    public void setActiveEditor(IEditorPart editor) {
        this.editorPart = editor;
    }

    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        SearchDialogSettings settings = new SearchDialogSettings();
        IDialogSettings store = AmaltheaUIPlugin.getDefault().getDialogSettings();
        settings.loadFrom(store);
        SearchDialog dialog = new SearchDialog(window.getShell(), settings);
        int returnCode = dialog.open();
        if (returnCode == 0) {
            Pattern searchPattern = settings.computeSearchPattern();
            if (searchPattern == null) {
                return;
            }
            settings.saveTo(store);
            Amalthea model = AmaltheaEditorUtil.getModel(this.editorPart.getEditorInput());
            if (model == null) {
                return;
            }
            ModelHitCollector query = new ModelHitCollector(searchPattern, settings.computeFilterClass(), settings.isSearchRestrictedToFile(), (EObject)model, this.editorPart.getEditorInput());
            NewSearchUI.runQueryInBackground((ISearchQuery)query);
        }
    }
}

