/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.standard.os;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.ListObject;
import org.eclipse.app4mc.amalthea.model.SchedulingParameterDefinition;
import org.eclipse.app4mc.amalthea.model.Value;
import org.eclipse.app4mc.amalthea.model.impl.SchedulingParameterImpl;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="AM-OS-Scheduling-Parameter-Value-Number-Matches-Defined-Multiplicity", checks={"The number of values of the specified scheduling parameter must match the defined multiplicity in the scheduling parameter definition"})
public class AmOSSchedulingParameterMultiplicityMatchesDefinition
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getSchedulingParameter();
    }

    public void validate(EObject object, List<ValidationDiagnostic> results) {
        if (object instanceof SchedulingParameterImpl) {
            String message;
            SchedulingParameterImpl sp = (SchedulingParameterImpl)object;
            if (sp.getKey() == null) {
                return;
            }
            List<Value> values = AmOSSchedulingParameterMultiplicityMatchesDefinition.getAllValues(sp.getValue());
            SchedulingParameterDefinition spd = sp.getKey();
            if (spd.isMandatory() && values.isEmpty()) {
                message = "There is no value for " + this.typeInfo((EObject)sp) + " \"" + sp.getKey().getName() + "\" - the " + this.typeInfo((EObject)sp.getKey()) + " requires " + (spd.isMany() ? "at least" : "exactly") + " one value";
                this.addIssue(results, (EObject)sp, (EStructuralFeature)ePackage.getSchedulingParameter_Value(), message);
            }
            if (!spd.isMany() && values.size() > 1) {
                message = "There are multiple values for " + this.typeInfo((EObject)sp) + " \"" + sp.getKey().getName() + "\" - the " + this.typeInfo((EObject)sp.getKey()) + " allows not more than one value";
                this.addIssue(results, (EObject)sp, (EStructuralFeature)ePackage.getSchedulingParameter_Value(), message);
            }
        }
    }

    static List<Value> getAllValues(Value value) {
        ArrayList<Value> ret = new ArrayList<Value>();
        if (value == null) {
            return ret;
        }
        if (value instanceof ListObject) {
            ((ListObject)value).getValues().forEach(v -> {
                boolean bl = ret.addAll(AmOSSchedulingParameterMultiplicityMatchesDefinition.getAllValues(v));
            });
        } else {
            ret.add(value);
        }
        return ret;
    }
}

