/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.standard.os;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.SchedulingParameterDefinition;
import org.eclipse.app4mc.amalthea.model.Value;
import org.eclipse.app4mc.amalthea.model.impl.SchedulingParameterImpl;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.amalthea.validations.standard.os.AmOSSchedulingParameterMultiplicityMatchesDefinition;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="AM-OS-Scheduling-Parameter-Empty-Overriden-Value", checks={"There should be a value if a default value of a scheduling parameter is overridden"})
public class AmOSSchedulingParameterEmptyOverriddenValue
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getSchedulingParameter();
    }

    public void validate(EObject object, List<ValidationDiagnostic> results) {
        if (object instanceof SchedulingParameterImpl) {
            SchedulingParameterImpl sp = (SchedulingParameterImpl)object;
            if (sp.getKey() == null) {
                return;
            }
            List<Value> values = AmOSSchedulingParameterMultiplicityMatchesDefinition.getAllValues(sp.getValue());
            SchedulingParameterDefinition spd = sp.getKey();
            if (spd.eIsSet((EStructuralFeature)ePackage.getSchedulingParameterDefinition_DefaultValue()) && values.isEmpty()) {
                String message = "There should be " + (spd.isMany() ? "at least one" : "a") + " value provided for the overridden " + this.typeInfo((EObject)sp) + " \"" + spd.getName() + "\", otherwise the default value will be used";
                this.addIssue(results, (EObject)sp, (EStructuralFeature)ePackage.getSchedulingParameter_Value(), message);
            }
        }
    }
}

