/**
 ********************************************************************************
 * Copyright (c) 2021 Robert Bosch GmbH and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 ********************************************************************************
 */ 

package org.eclipse.app4mc.amalthea.model.editor.handler;

import java.io.File;
import java.io.IOException;

import javax.inject.Named;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.emf.AmaltheaResource;
import org.eclipse.app4mc.amalthea.model.io.AmaltheaFileHelper;
import org.eclipse.app4mc.amalthea.model.io.AmaltheaLoader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IDecoratorManager;

public class UncompressHandler {
	
	@Execute
	public void execute(@Named(IServiceConstants.ACTIVE_SELECTION) IStructuredSelection selection, Shell shell, IDecoratorManager decoratorManager) {
		if (selection.getFirstElement() instanceof IFile
				&& AmaltheaFileHelper.isModelFileExtension(((IFile)selection.getFirstElement()).getFileExtension())) {

			IFile file = (IFile) selection.getFirstElement();
			File modelFile = new File(file.getLocationURI());

			Amalthea model = AmaltheaLoader.loadFromFile(modelFile);
			if (model != null && model.eResource() instanceof AmaltheaResource) {
				AmaltheaResource modelResource = (AmaltheaResource) model.eResource();
				modelResource.setUseZip(false);

				try {
					modelResource.save(null);
					file.refreshLocal(IResource.DEPTH_INFINITE, null);
					decoratorManager.update("org.eclipse.app4mc.amalthea.file.compressed.decorator");
				} catch (IOException e) {
					MessageDialog.openError(shell, "Uncompress error", "Failed to uncompress the model file! " + e.getMessage());
				} catch (CoreException e) {
					Platform.getLog(getClass()).error(e.getLocalizedMessage(), e);
				}
			}
		}
	}

}
