/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.sim.os;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.InterruptController;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.SchedulerAllocation;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="Sim-OS-SchedulerAllocation", checks={"Scheduler must be referred to by exactly one scheduler allocation"})
public class SimOsSchedulerAllocation
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getScheduler();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        if (eObject instanceof InterruptController) {
            InterruptController isrController = (InterruptController)eObject;
            Set allocations = AmaltheaIndex.getReferringObjects((EObject)isrController).stream().filter(referer -> referer instanceof SchedulerAllocation).collect(Collectors.toSet());
            if (allocations.isEmpty()) {
                this.addIssue(results, (EObject)isrController, (EStructuralFeature)ePackage.getScheduler_SchedulerAllocations(), SimOsSchedulerAllocation.getMessageNoInterruptControllerAllocation());
            } else if (allocations.size() > 1) {
                this.addIssue(results, (EObject)isrController, (EStructuralFeature)ePackage.getScheduler_SchedulerAllocations(), SimOsSchedulerAllocation.getMessageManyInterruptControllerAllocations());
            }
        } else if (eObject instanceof Scheduler) {
            Scheduler scheduler = (Scheduler)eObject;
            Set allocations = AmaltheaIndex.getReferringObjects((EObject)scheduler).stream().filter(referer -> referer instanceof SchedulerAllocation).collect(Collectors.toSet());
            if (allocations.isEmpty()) {
                this.addIssue(results, (EObject)scheduler, (EStructuralFeature)ePackage.getScheduler_SchedulerAllocations(), SimOsSchedulerAllocation.getMessageNoSchedulerAllocation());
            } else if (allocations.size() > 1) {
                this.addIssue(results, (EObject)scheduler, (EStructuralFeature)ePackage.getScheduler_SchedulerAllocations(), SimOsSchedulerAllocation.getMessageManySchedulerAllocations());
            }
        }
    }

    public static String getMessageNoSchedulerAllocation() {
        return "Scheduler is not referred to by any scheduler allocation";
    }

    public static String getMessageManySchedulerAllocations() {
        return "Scheduler is referred to by more than one scheduler allocation";
    }

    public static String getMessageNoInterruptControllerAllocation() {
        return "ISR is not referred to by any scheduler allocation";
    }

    public static String getMessageManyInterruptControllerAllocations() {
        return "ISR is referred to by more than one scheduler allocation";
    }
}

