/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.editor.providers;

import org.apache.commons.lang.StringUtils;
import org.eclipse.app4mc.amalthea.model.presentation.ExtendedAmaltheaEditor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;

public class DelegatingLabelProvider
implements ILabelProvider {
    private ExtendedAmaltheaEditor editor;
    private ILabelProvider delegate;

    public DelegatingLabelProvider(ExtendedAmaltheaEditor editor, ILabelProvider delegate) {
        this.editor = editor;
        this.delegate = delegate;
    }

    public String getText(Object element) {
        String text = this.delegate.getText(element);
        if (StringUtils.isBlank((String)text)) {
            return "???";
        }
        String type = this.getTypeName(element);
        if (StringUtils.isBlank((String)type)) {
            return text;
        }
        String result = this.stripTypePrefix(text, type);
        if (this.editor.isShowTypesEnabled()) {
            result = String.valueOf(result) + " [" + type + "]";
        }
        return result;
    }

    private String getTypeName(Object element) {
        Object target = element;
        if (element instanceof IStructuredSelection) {
            target = ((IStructuredSelection)element).getFirstElement();
        }
        return target instanceof EObject ? ((EObject)target).eClass().getName() : null;
    }

    private String stripTypePrefix(String text, String type) {
        String typeWithBlanks = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)type), (char)' ');
        return StringUtils.removeStart((String)text.trim(), (String)(String.valueOf(typeWithBlanks) + " ")).trim();
    }

    public Image getImage(Object element) {
        return this.delegate.getImage(element);
    }

    public void dispose() {
        this.delegate.dispose();
        this.editor = null;
        this.delegate = null;
    }

    public void addListener(ILabelProviderListener listener) {
        this.delegate.addListener(listener);
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.delegate.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.delegate.removeListener(listener);
    }
}

