/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.draw3d.geometry.IVector2f;
import org.eclipse.draw3d.geometry.Vector2f;
import org.eclipse.draw3d.geometry.Vector2fImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArcHelper
implements Iterable<IVector2f> {
    private static final float PI2 = (float)Math.PI * 2;
    private IVector2f m_axes;
    private IVector2f m_center;
    private float m_cos;
    private int m_numSegments;
    private float m_sin;
    private IVector2f m_start;
    private boolean m_skipFinal;

    public ArcHelper(float i_precision, float i_x, float i_y, float i_width, float i_height, float i_start, float i_length, boolean i_skipFinal) {
        if (i_precision <= 0.0f || i_precision > 1.0f) {
            throw new IllegalArgumentException("precision must be greater than 0 and less than or equal to 1");
        }
        float start = i_start % ((float)Math.PI * 2);
        float length = i_length;
        this.m_axes = new Vector2fImpl(i_width / 2.0f, i_height / 2.0f);
        this.m_center = new Vector2fImpl(i_x + this.m_axes.getX(), i_y + this.m_axes.getY());
        float avgRadius = (this.m_axes.getX() + this.m_axes.getY()) / 2.0f;
        this.m_numSegments = (int)Math.ceil((double)(i_precision * 10.0f) * Math.sqrt(avgRadius) * (double)Math.abs(length) / 6.2831854820251465);
        float theta = length / (float)this.m_numSegments;
        this.m_skipFinal = i_skipFinal;
        if (this.m_skipFinal) {
            --this.m_numSegments;
        }
        this.m_cos = (float)Math.cos(theta);
        this.m_sin = (float)Math.sin(theta);
        this.m_start = new Vector2fImpl((float)Math.cos(start), (float)Math.sin(start));
    }

    public float[] getArray() {
        return this.getArray(new float[2 * this.getNumVertices()], 0);
    }

    public float[] getArray(float[] i_array) {
        return this.getArray(i_array, 0);
    }

    public float[] getArray(float[] i_array, int i_offset) {
        if (i_array.length - i_offset < 2 * this.getNumVertices()) {
            throw new IllegalArgumentException("i_array is too small");
        }
        int i = 0;
        for (IVector2f v : this) {
            i_array[i_offset + 2 * i] = v.getX();
            i_array[i_offset + 2 * i + 1] = v.getY();
            ++i;
        }
        return i_array;
    }

    public int getNumVertices() {
        return this.m_numSegments + 1;
    }

    @Override
    public Iterator<IVector2f> iterator() {
        return new ArcIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArcIterator
    implements Iterator<IVector2f> {
        private Vector2f m_next = new Vector2fImpl();
        private Vector2f m_result = new Vector2fImpl();
        private int m_segment = 0;

        private ArcIterator() {
            this.m_next.set(ArcHelper.this.m_start);
        }

        @Override
        public boolean hasNext() {
            return this.m_segment <= ArcHelper.this.m_numSegments;
        }

        @Override
        public IVector2f next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            float x = this.m_next.getX();
            float y = this.m_next.getY();
            this.m_result.setX(x * ArcHelper.this.m_axes.getX() + ArcHelper.this.m_center.getX());
            this.m_result.setY(y * -ArcHelper.this.m_axes.getY() + ArcHelper.this.m_center.getY());
            ++this.m_segment;
            if (this.hasNext()) {
                float t = x;
                x = ArcHelper.this.m_cos * x - ArcHelper.this.m_sin * y;
                y = ArcHelper.this.m_sin * t + ArcHelper.this.m_cos * y;
                this.m_next.set(x, y);
            }
            return this.m_result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

