/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.metaabm.IID;
import org.metaabm.MetaABMPackage;
import org.metaabm.act.AAct;
import org.metaabm.provider.MetaABMItemProvider;
import org.metaabm.provider.MetaABMItemProviderAdapterFactory;

public class SuggestLabelCommand
extends AbstractOverrideableCommand {
    Collection<? extends IID> ids;
    MetaABMItemProvider defaultProvider;
    List<Boolean> oldSame = new ArrayList<Boolean>();
    CompoundCommand command;

    public SuggestLabelCommand(MetaABMItemProvider provider, EditingDomain domain, IID id) {
        this(domain, Collections.singleton(id));
        this.defaultProvider = provider;
    }

    public SuggestLabelCommand(EditingDomain domain, IID id) {
        this(domain, Collections.singleton(id));
    }

    public SuggestLabelCommand(EditingDomain domain, Collection<? extends IID> ids) {
        super(domain, "Suggest Label", "Suggest Label");
        this.ids = ids;
        for (IID iID : this.ids) {
            String idealLabel = StringUtils.remove((String)iID.getLabel(), (String)" Copy");
            this.oldSame.add(this.suggestLabel(iID).equals(idealLabel));
        }
    }

    public String suggestID(IID id) {
        return this.getProviderFor(id).suggestID(id);
    }

    public String suggestLabel(IID id) {
        return this.getProviderFor(id).suggestLabel(id);
    }

    private MetaABMItemProvider getProviderFor(IID id) {
        if (this.defaultProvider != null) {
            return this.defaultProvider;
        }
        try {
            return (MetaABMItemProvider)MetaABMItemProviderAdapterFactory.getGenericAdapterFactory().adapt((Notifier)id, IEditingDomainItemProvider.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean doCanExecute() {
        return true;
    }

    public boolean doCanUndo() {
        return true;
    }

    public void doExecute() {
        this.command = new CompoundCommand();
        int i = 0;
        for (IID iID : this.ids) {
            if (StringUtils.isEmpty((String)iID.getLabel()) || this.oldSame.get(i).booleanValue()) {
                this.command.appendAndExecute(SetCommand.create((EditingDomain)this.getDomain(), (Object)iID, (Object)MetaABMPackage.Literals.IID__LABEL, (Object)this.suggestLabel(iID)));
            } else if (iID.getID() == null || !(iID instanceof AAct)) {
                this.command.appendAndExecute(SetCommand.create((EditingDomain)this.getDomain(), (Object)iID, (Object)MetaABMPackage.Literals.IID__LABEL, (Object)iID.getLabel()));
            }
            ++i;
        }
    }

    public void doRedo() {
        this.command.redo();
    }

    public void doUndo() {
        this.command.undo();
    }
}

