/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.rule;

import java.util.List;
import org.ascape.model.Agent;
import org.ascape.model.Cell;
import org.ascape.model.rule.Diffusable;
import org.ascape.model.rule.Diffusion;

public abstract class ParameterizedDiffusion
extends Diffusion {
    private static final long serialVersionUID = 1L;
    private double evaporationRate = 0.0;
    private double diffuseConstant = 1.0;

    public ParameterizedDiffusion(String name) {
        super(name);
    }

    public ParameterizedDiffusion(String name, float diffuseConstant, float evaporationRate) {
        super(name);
        this.setDiffusionConstant(diffuseConstant);
        this.setEvaporationRate(evaporationRate);
    }

    @Override
    public void execute(Agent agent) {
        double valueSum = 0.0;
        List neighbors = ((Cell)agent).findNeighbors();
        int i = 0;
        while (i < neighbors.size()) {
            valueSum += this.getDiffusionValue((Agent)neighbors.get(i));
            ++i;
        }
        valueSum -= (double)neighbors.size() * this.getDiffusionValue(agent);
        valueSum /= (double)neighbors.size();
        valueSum = this.getDiffusionValue(agent) + valueSum * this.getDiffusionConstant();
        ((Diffusable)((Object)agent)).setDiffusionTemp(valueSum *= 1.0 - this.getEvaporationRate());
    }

    public double getDiffusionConstant() {
        return this.diffuseConstant;
    }

    public void setDiffusionConstant(double diffuseConstant) {
        this.diffuseConstant = diffuseConstant;
    }

    public double getEvaporationRate() {
        return this.evaporationRate;
    }

    public void setEvaporationRate(double evaporationRate) {
        this.evaporationRate = evaporationRate;
    }
}

