/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parsetree.reconstr.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeIterator
implements TreeIterator<INode> {
    private INode current;
    private INode next;
    private Set<ICompositeNode> prunedComposites = Sets.newHashSet();

    public NodeIterator(INode node) {
        this.current = node;
        this.next = this.findNext(node);
    }

    private INode findPrevious(INode node) {
        ICompositeNode parent = node.getParent();
        if (parent == null) {
            return null;
        }
        ArrayList siblings = Lists.newArrayList(parent.getChildren());
        int index = siblings.indexOf(node);
        if (index > 0) {
            INode predecessor = (INode)siblings.get(index - 1);
            while (predecessor instanceof ICompositeNode && !this.prunedComposites.contains(predecessor)) {
                ArrayList predecessorChildren = Lists.newArrayList(((ICompositeNode)predecessor).getChildren());
                if (predecessorChildren.isEmpty()) {
                    return predecessor;
                }
                predecessor = (INode)predecessorChildren.get(predecessorChildren.size() - 1);
            }
            return predecessor;
        }
        return parent;
    }

    private INode findNext(INode node) {
        ArrayList children;
        if (node instanceof ICompositeNode && !this.prunedComposites.contains(node) && !(children = Lists.newArrayList(((ICompositeNode)node).getChildren())).isEmpty()) {
            return (INode)children.get(0);
        }
        return this.findNextSibling(node);
    }

    protected INode findNextSibling(INode node) {
        ICompositeNode parent = node.getParent();
        if (parent == null) {
            return null;
        }
        ArrayList siblings = Lists.newArrayList(parent.getChildren());
        int index = siblings.indexOf(node);
        if (index < siblings.size() - 1) {
            return (INode)siblings.get(index + 1);
        }
        return this.findNextSibling(parent);
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public INode next() {
        this.current = this.next;
        this.next = this.findNext(this.next);
        return this.current;
    }

    public boolean hasPrevious() {
        return this.current != null;
    }

    public INode previous() {
        this.next = this.current;
        this.current = this.findPrevious(this.current);
        return this.next;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void prune() {
        if (this.current instanceof ICompositeNode) {
            this.prunedComposites.add((ICompositeNode)this.current);
            this.next = this.findNext(this.current);
        }
    }
}

