/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.operation;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.AccumulatingProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.util.Policy;
import org.eclipse.rwt.internal.lifecycle.UICallBackServiceHandler;
import org.eclipse.rwt.lifecycle.UICallBack;
import org.eclipse.swt.widgets.Display;

public class ModalContext {
    private static boolean debug = false;
    private static int modalLevel = 0;
    private static boolean runInSeparateThread = true;

    /*
     * Unable to fully structure code
     */
    public static boolean canProgressMonitorBeUsed(IProgressMonitor monitor1, IProgressMonitor monitor2) {
        if (monitor1 != monitor2) ** GOTO lbl5
        return true;
lbl-1000:
        // 1 sources

        {
            if ((monitor1 = ((ProgressMonitorWrapper)monitor1).getWrappedProgressMonitor()) != monitor2) continue;
            return true;
lbl5:
            // 2 sources

            ** while (monitor1 instanceof ProgressMonitorWrapper)
        }
lbl6:
        // 1 sources

        return false;
    }

    public static void checkCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private static ModalContextThread getCurrentModalContextThread() {
        Thread t = Thread.currentThread();
        if (t instanceof ModalContextThread) {
            return (ModalContextThread)t;
        }
        return null;
    }

    public static int getModalLevel() {
        return modalLevel;
    }

    public static boolean isModalContextThread(Thread thread) {
        return thread instanceof ModalContextThread;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void run(IRunnableWithProgress operation, boolean fork, IProgressMonitor monitor, Display display) throws InvocationTargetException, InterruptedException {
        Assert.isTrue((operation != null && monitor != null ? 1 : 0) != 0);
        ++modalLevel;
        try {
            if (monitor != null) {
                monitor.setCanceled(false);
            }
            if (!fork || !runInSeparateThread) {
                ModalContext.runInCurrentThread(operation, monitor);
            } else {
                ModalContextThread t = ModalContext.getCurrentModalContextThread();
                if (t != null) {
                    Assert.isTrue((boolean)ModalContext.canProgressMonitorBeUsed(monitor, t.progressMonitor));
                    ModalContext.runInCurrentThread(operation, monitor);
                } else {
                    t = new ModalContextThread(operation, monitor, display);
                    Throwable listenerException = null;
                    if (operation instanceof IThreadListener) {
                        listenerException = ModalContext.invokeThreadListener((IThreadListener)((Object)operation), t);
                    }
                    String key = String.valueOf(t.hashCode());
                    UICallBackServiceHandler.activateUICallBacksFor((String)key);
                    if (listenerException == null) {
                        t.start();
                        t.block();
                    } else if (t.throwable == null) {
                        t.throwable = listenerException;
                    }
                    Throwable throwable = t.throwable;
                    if (throwable != null) {
                        if (debug && !(throwable instanceof InterruptedException) && !(throwable instanceof OperationCanceledException)) {
                            System.err.println("Exception in modal context operation:");
                            throwable.printStackTrace();
                            System.err.println("Called from:");
                            new InvocationTargetException(null).printStackTrace();
                        }
                        if (throwable instanceof InvocationTargetException) {
                            throw (InvocationTargetException)throwable;
                        }
                        if (throwable instanceof InterruptedException) {
                            throw (InterruptedException)throwable;
                        }
                        if (!(throwable instanceof OperationCanceledException)) throw new InvocationTargetException(throwable);
                        throw new InterruptedException(throwable.getMessage());
                    }
                }
            }
            Object var8_10 = null;
            --modalLevel;
            return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            --modalLevel;
            throw throwable;
        }
    }

    static Throwable invokeThreadListener(IThreadListener listener, Thread switchingThread) {
        try {
            listener.threadChange(switchingThread);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Error e) {
            return e;
        }
        catch (RuntimeException e) {
            return e;
        }
        return null;
    }

    private static void runInCurrentThread(IRunnableWithProgress runnable, IProgressMonitor progressMonitor) throws InterruptedException, InvocationTargetException {
        try {
            if (runnable != null) {
                runnable.run(progressMonitor);
            }
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new InvocationTargetException(e);
        }
        catch (Error e) {
            throw new InvocationTargetException(e);
        }
    }

    public static void setDebugMode(boolean debugMode) {
        debug = debugMode;
    }

    public static void setAllowReadAndDispatch(boolean allowReadAndDispatch) {
        runInSeparateThread = allowReadAndDispatch;
    }

    private static class ModalContextThread
    extends Thread {
        private IRunnableWithProgress runnable;
        private Throwable throwable;
        private IProgressMonitor progressMonitor;
        private Display display;
        private volatile boolean continueEventDispatching = true;
        private Thread callingThread;

        private ModalContextThread(IRunnableWithProgress operation, IProgressMonitor monitor, Display display) {
            super("ModalContext");
            Assert.isTrue((monitor != null && display != null ? 1 : 0) != 0);
            this.runnable = operation;
            this.progressMonitor = new AccumulatingProgressMonitor(monitor, display);
            this.display = display;
            this.callingThread = Thread.currentThread();
        }

        public void run() {
            UICallBack.runNonUIThreadWithFakeContext((Display)this.display, (Runnable)new Runnable(this){
                final /* synthetic */ ModalContextThread this$1;
                {
                    this.this$1 = modalContextThread;
                }

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    Throwable exception2;
                    try {
                        try {
                            if (ModalContextThread.access$0(this.this$1) != null) {
                                ModalContextThread.access$0(this.this$1).run(ModalContextThread.access$6(this.this$1));
                            }
                        }
                        catch (InvocationTargetException e) {
                            ModalContextThread.access$3(this.this$1, e);
                        }
                        catch (InterruptedException e) {
                            ModalContextThread.access$3(this.this$1, e);
                        }
                        catch (RuntimeException e) {
                            ModalContextThread.access$3(this.this$1, e);
                        }
                        catch (ThreadDeath e) {
                            throw e;
                        }
                        catch (Error e) {
                            ModalContextThread.access$3(this.this$1, e);
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable exception2;
                        Object var2_7 = null;
                        if (ModalContextThread.access$0(this.this$1) instanceof IThreadListener && (exception2 = ModalContext.invokeThreadListener((IThreadListener)((Object)ModalContextThread.access$0(this.this$1)), ModalContextThread.access$1(this.this$1))) != null && ModalContextThread.access$2(this.this$1) == null) {
                            ModalContextThread.access$3(this.this$1, exception2);
                        }
                        ModalContextThread.access$4(this.this$1).syncExec(new Runnable(this){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                            }
                        });
                        ModalContextThread.access$5(this.this$1, false);
                        ModalContextThread.access$4(this.this$1).asyncExec(null);
                        String key = String.valueOf(this.this$1.hashCode());
                        UICallBackServiceHandler.deactivateUICallBacksFor((String)key);
                        throw throwable;
                    }
                    {
                        Object var2_8 = null;
                    }
                    if (ModalContextThread.access$0(this.this$1) instanceof IThreadListener && (exception2 = ModalContext.invokeThreadListener((IThreadListener)((Object)ModalContextThread.access$0(this.this$1)), ModalContextThread.access$1(this.this$1))) != null && ModalContextThread.access$2(this.this$1) == null) {
                        ModalContextThread.access$3(this.this$1, exception2);
                    }
                    ModalContextThread.access$4(this.this$1).syncExec(new /* invalid duplicate definition of identical inner class */);
                    ModalContextThread.access$5(this.this$1, false);
                    ModalContextThread.access$4(this.this$1).asyncExec(null);
                    String key = String.valueOf(this.this$1.hashCode());
                    UICallBackServiceHandler.deactivateUICallBacksFor((String)key);
                }
            });
        }

        public void block() {
            if (this.display == Display.getCurrent()) {
                int exceptionCount = 0;
                while (this.continueEventDispatching) {
                    try {
                        if (!this.display.readAndDispatch()) {
                            this.display.sleep();
                        }
                        exceptionCount = 0;
                    }
                    catch (ThreadDeath e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        if (t instanceof VirtualMachineError) {
                            throw (VirtualMachineError)t;
                        }
                        if (++exceptionCount > 50 || this.display.isDisposed()) {
                            if (t instanceof RuntimeException) {
                                throw (RuntimeException)t;
                            }
                            if (t instanceof Error) {
                                throw (Error)t;
                            }
                            throw new RuntimeException(t);
                        }
                        Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", "Unhandled event loop exception during blocked modal context.", t));
                    }
                }
            } else {
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    this.throwable = e;
                }
            }
        }

        static /* synthetic */ IRunnableWithProgress access$0(ModalContextThread modalContextThread) {
            return modalContextThread.runnable;
        }

        static /* synthetic */ Thread access$1(ModalContextThread modalContextThread) {
            return modalContextThread.callingThread;
        }

        static /* synthetic */ Display access$4(ModalContextThread modalContextThread) {
            return modalContextThread.display;
        }

        static /* synthetic */ void access$5(ModalContextThread modalContextThread, boolean bl) {
            modalContextThread.continueEventDispatching = bl;
        }
    }
}

