/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointOrganizer;
import org.eclipse.debug.internal.ui.elements.adapters.DefaultBreakpointsViewInput;
import org.eclipse.debug.internal.ui.model.elements.ElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.update.BreakpointManagerProxy;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainer;
import org.eclipse.debug.internal.ui.views.breakpoints.ElementComparator;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;

public class BreakpointManagerContentProvider
extends ElementContentProvider
implements IBreakpointsListener {
    private ISchedulingRule fBreakpointsListenerSchedulingRule = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    };
    public static boolean DEBUG_BREAKPOINT_DELTAS = false;
    private final Map fInputToData = Collections.synchronizedMap(new InputDataMap());
    private boolean fIsBreakpointListener = false;
    private final IBreakpointManager fBpManager = DebugPlugin.getDefault().getBreakpointManager();
    static /* synthetic */ Class class$0;

    static {
        DEBUG_BREAKPOINT_DELTAS = DebugUIPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.debug.ui/debug/viewers/breakpointDeltas"));
    }

    protected IBreakpoint[] filterBreakpoints(DefaultBreakpointsViewInput input, IStructuredSelection selectionFilter, IBreakpoint[] breakpoints) {
        if (selectionFilter != null && !selectionFilter.isEmpty()) {
            List targets = this.getDebugTargets(selectionFilter);
            ArrayList<IBreakpoint> retVal = new ArrayList<IBreakpoint>();
            if (targets != null) {
                int i = 0;
                while (i < breakpoints.length) {
                    if (this.supportsBreakpoint(targets, breakpoints[i])) {
                        retVal.add(breakpoints[i]);
                    }
                    ++i;
                }
            }
            return retVal.toArray(new IBreakpoint[retVal.size()]);
        }
        return breakpoints;
    }

    protected boolean supportsBreakpoint(IStructuredSelection ss, IBreakpoint breakpoint) {
        return this.supportsBreakpoint(this.getDebugTargets(ss), breakpoint);
    }

    protected boolean supportsBreakpoint(List targets, IBreakpoint breakpoint) {
        boolean exist = targets.size() == 0;
        int i = 0;
        while (!exist && i < targets.size()) {
            IDebugTarget target = (IDebugTarget)targets.get(i);
            exist |= target.supportsBreakpoint(breakpoint);
            ++i;
        }
        return exist;
    }

    protected List getDebugTargets(IStructuredSelection ss) {
        ArrayList<IDebugTarget> debugTargets = new ArrayList<IDebugTarget>(2);
        if (ss != null) {
            Iterator i = ss.iterator();
            while (i.hasNext()) {
                IDebugTarget target;
                Object next = i.next();
                if (next instanceof IDebugElement) {
                    debugTargets.add(((IDebugElement)next).getDebugTarget());
                    continue;
                }
                if (next instanceof ILaunch) {
                    IDebugTarget[] targets = ((ILaunch)next).getDebugTargets();
                    int j = 0;
                    while (j < targets.length) {
                        debugTargets.add(targets[j]);
                        ++j;
                    }
                    continue;
                }
                if (next instanceof IProcess) {
                    IProcess iProcess = (IProcess)next;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((target = (IDebugTarget)iProcess.getAdapter((Class)clazz)) == null) continue;
                    debugTargets.add(target);
                    continue;
                }
                if (!(next instanceof IAdaptable)) continue;
                IAdaptable iAdaptable = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((target = (IDebugTarget)iAdaptable.getAdapter((Class)clazz)) == null) continue;
                debugTargets.add(target);
            }
        }
        return debugTargets;
    }

    protected int getMaxInputsCache() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void contextDisposed(IPresentationContext context) {
        ArrayList removed = new ArrayList(1);
        Map map = this.fInputToData;
        synchronized (map) {
            Iterator itr = this.fInputToData.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                IPresentationContext entryContext = ((DefaultBreakpointsViewInput)entry.getKey()).getContext();
                if (!context.equals(entryContext)) continue;
                removed.add(entry.getValue());
                itr.remove();
            }
        }
        int i = 0;
        while (i < removed.size()) {
            ((InputData)removed.get(i)).dispose();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerModelProxy(DefaultBreakpointsViewInput input, BreakpointManagerProxy proxy) {
        BreakpointManagerContentProvider breakpointManagerContentProvider = this;
        synchronized (breakpointManagerContentProvider) {
            if (!this.fIsBreakpointListener) {
                this.fBpManager.addBreakpointListener((IBreakpointsListener)this);
                this.fIsBreakpointListener = true;
            }
        }
        InputData inputData = this.getInputData(input);
        if (inputData != null) {
            inputData.proxyInstalled(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterModelProxy(DefaultBreakpointsViewInput input, BreakpointManagerProxy proxy) {
        InputData inputData = (InputData)this.fInputToData.get(input);
        if (inputData != null) {
            inputData.proxyDisposed(proxy);
            if (this.fInputToData.isEmpty()) {
                BreakpointManagerContentProvider breakpointManagerContentProvider = this;
                synchronized (breakpointManagerContentProvider) {
                    if (this.fIsBreakpointListener) {
                        this.fBpManager.removeBreakpointListener((IBreakpointsListener)this);
                        this.fIsBreakpointListener = false;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputData getInputData(DefaultBreakpointsViewInput input) {
        if (Boolean.TRUE.equals(input.getContext().getProperty("PROPERTY_DISPOSED"))) {
            return null;
        }
        InputData data = null;
        Map map = this.fInputToData;
        synchronized (map) {
            data = (InputData)this.fInputToData.get(input);
            if (data == null) {
                data = new InputData(input);
                this.fInputToData.put(input, data);
            }
        }
        return data;
    }

    protected IStructuredSelection getSelectionFilter(Object input, IStructuredSelection debugContext) {
        IPresentationContext presentation;
        if (input instanceof DefaultBreakpointsViewInput && Boolean.TRUE.equals((presentation = ((DefaultBreakpointsViewInput)input).getContext()).getProperty("FilterSelection"))) {
            return debugContext;
        }
        return null;
    }

    protected boolean supportsContextId(String id) {
        return id.equals("org.eclipse.debug.ui.BreakpointView");
    }

    protected int getChildCount(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        DefaultBreakpointsViewInput bpManagerInput;
        InputData inputData;
        Object input = monitor.getViewerInput();
        if (input instanceof DefaultBreakpointsViewInput && (inputData = this.getInputData(bpManagerInput = (DefaultBreakpointsViewInput)input)) != null) {
            return inputData.fContainer.getChildren().length;
        }
        return 0;
    }

    protected Object[] getChildren(Object parent, int index, int length, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        DefaultBreakpointsViewInput bpManagerInput;
        InputData inputData;
        Object input = monitor.getViewerInput();
        if (input instanceof DefaultBreakpointsViewInput && (inputData = this.getInputData(bpManagerInput = (DefaultBreakpointsViewInput)input)) != null) {
            Object[] children = inputData.fContainer.getChildren();
            return this.getElements(children, index, length);
        }
        return EMPTY;
    }

    public void breakpointsAdded(final IBreakpoint[] breakpoints) {
        new Job("Breakpoints View Update Job"){
            {
                this.setSystem(true);
                this.setRule(BreakpointManagerContentProvider.this.fBreakpointsListenerSchedulingRule);
            }

            protected IStatus run(IProgressMonitor monitor) {
                InputData[] datas = BreakpointManagerContentProvider.this.fInputToData.values().toArray(new InputData[0]);
                int i = 0;
                while (i < datas.length) {
                    datas[i].breakpointsAdded(breakpoints);
                    ++i;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void breakpointsRemoved(final IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        new Job("Breakpoints View Update Job"){
            {
                this.setSystem(true);
                this.setRule(BreakpointManagerContentProvider.this.fBreakpointsListenerSchedulingRule);
            }

            protected IStatus run(IProgressMonitor monitor) {
                InputData[] datas = BreakpointManagerContentProvider.this.fInputToData.values().toArray(new InputData[0]);
                int i = 0;
                while (i < datas.length) {
                    datas[i].breakpointsRemoved(breakpoints);
                    ++i;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void breakpointsChanged(final IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        new Job("Breakpoints View Update Job"){
            {
                this.setSystem(true);
                this.setRule(BreakpointManagerContentProvider.this.fBreakpointsListenerSchedulingRule);
            }

            protected IStatus run(IProgressMonitor monitor) {
                InputData[] datas = BreakpointManagerContentProvider.this.fInputToData.values().toArray(new InputData[0]);
                int i = 0;
                while (i < datas.length) {
                    datas[i].breakpointsChanged(breakpoints);
                    ++i;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void appendModelDelta(BreakpointContainer parent, ModelDelta parentDelta, int flags, IBreakpoint breakpoint) {
        BreakpointContainer[] containers = parent.getContainers();
        if (parent.contains(breakpoint)) {
            if (containers.length != 0) {
                int i = 0;
                while (i < containers.length) {
                    ModelDelta nodeDelta = parentDelta.addNode(containers[i], 2048);
                    this.appendModelDelta(containers[i], nodeDelta, flags, breakpoint);
                    ++i;
                }
            } else {
                parentDelta.addNode(breakpoint, flags);
            }
        }
    }

    private void appendModelDeltaToElement(IModelDelta parentDelta, Object element, int flags) {
        if (element.equals(parentDelta.getElement())) {
            ((ModelDelta)parentDelta).setFlags(parentDelta.getFlags() | flags);
            return;
        }
        IModelDelta[] childDeltas = parentDelta.getChildDeltas();
        int i = 0;
        while (i < childDeltas.length) {
            if (element.equals(childDeltas[i].getElement())) {
                ((ModelDelta)childDeltas[i]).setFlags(childDeltas[i].getFlags() | flags);
                return;
            }
            this.appendModelDeltaToElement(childDeltas[i], element, flags);
            ++i;
        }
    }

    private class InputData {
        private final DefaultBreakpointsViewInput fInput;
        private final List fProxies = new ArrayList(1);
        private ElementComparator fComparator;
        private final BreakpointContainer fContainer;
        private IBreakpointOrganizer[] fOrganizers;
        private IStructuredSelection fDebugContext = StructuredSelection.EMPTY;
        private IPropertyChangeListener fOrganizersListener = new IPropertyChangeListener(this){
            final /* synthetic */ InputData this$1;
            {
                this.this$1 = inputData;
            }

            public void propertyChange(PropertyChangeEvent event) {
                this.this$1.updateContainers();
            }
        };
        private IPropertyChangeListener fPresentationContextListener = new IPropertyChangeListener(this){
            final /* synthetic */ InputData this$1;
            {
                this.this$1 = inputData;
            }

            public void propertyChange(PropertyChangeEvent event) {
                InputData.access$0(this.this$1, event);
            }
        };
        private IDebugContextListener fDebugContextListener = new IDebugContextListener(this){
            final /* synthetic */ InputData this$1;
            {
                this.this$1 = inputData;
            }

            public void debugContextChanged(DebugContextEvent event) {
                InputData.access$1(this.this$1, event);
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InputData(DefaultBreakpointsViewInput input) {
            this.fInput = input;
            this.fComparator = (ElementComparator)input.getContext().getProperty("ElementComparator");
            this.fOrganizers = (IBreakpointOrganizer[])input.getContext().getProperty("BreakpointOrganizers");
            ModelDelta initialDelta = new ModelDelta(this.fInput, 0, 0, -1);
            IBreakpoint[] breakpoints = BreakpointManagerContentProvider.this.filterBreakpoints(this.fInput, BreakpointManagerContentProvider.this.getSelectionFilter(this.fInput, this.getDebugContext()), BreakpointManagerContentProvider.this.fBpManager.getBreakpoints());
            this.fContainer = this.createRootContainer(initialDelta, this.fInput, this.fOrganizers, breakpoints);
            this.registerOrganizersListener(null, this.fOrganizers);
            input.getContext().addPropertyChangeListener(this.fPresentationContextListener);
            IWorkbenchWindow window = this.fInput.getContext().getWindow();
            if (window != null) {
                IDebugContextService debugContextService = DebugUITools.getDebugContextManager().getContextService(window);
                ISelection debugContext = debugContextService.getActiveContext();
                if (debugContext instanceof IStructuredSelection) {
                    InputData inputData = this;
                    synchronized (inputData) {
                        this.fDebugContext = (IStructuredSelection)debugContext;
                    }
                }
                debugContextService.addDebugContextListener(this.fDebugContextListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispose() {
            IBreakpointOrganizer[] organizers;
            InputData inputData = this;
            synchronized (inputData) {
                organizers = this.fOrganizers;
                this.fOrganizers = null;
            }
            this.registerOrganizersListener(organizers, null);
            this.fInput.getContext().removePropertyChangeListener(this.fPresentationContextListener);
            IWorkbenchWindow window = this.fInput.getContext().getWindow();
            if (window != null) {
                IDebugContextService debugContextService = DebugUITools.getDebugContextManager().getContextService(window);
                debugContextService.removeDebugContextListener(this.fDebugContextListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void proxyInstalled(BreakpointManagerProxy proxy) {
            ModelDelta rootDelta = null;
            InputData inputData = this;
            synchronized (inputData) {
                this.fProxies.add(proxy);
                rootDelta = new ModelDelta(this.fInput, 0, 0, -1);
                this.buildInstallDelta(rootDelta, this.fContainer);
                if (DEBUG_BREAKPOINT_DELTAS) {
                    System.out.println("PROXY INSTALLED (" + proxy + ")\n");
                }
                proxy.postModelChanged(rootDelta, false);
            }
        }

        synchronized void proxyDisposed(BreakpointManagerProxy proxy) {
            this.fProxies.remove(proxy);
            if (DEBUG_BREAKPOINT_DELTAS) {
                System.out.println("PROXY DISPOSED (" + proxy + ")\n");
            }
        }

        synchronized BreakpointManagerProxy[] getProxies() {
            return this.fProxies.toArray(new BreakpointManagerProxy[this.fProxies.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setOrganizers(IBreakpointOrganizer[] organizers) {
            IBreakpointOrganizer[] oldOrganizers = null;
            InputData inputData = this;
            synchronized (inputData) {
                oldOrganizers = this.fOrganizers;
                this.fOrganizers = organizers;
            }
            this.registerOrganizersListener(oldOrganizers, organizers);
            this.updateContainers();
        }

        private void registerOrganizersListener(IBreakpointOrganizer[] oldOrganizers, IBreakpointOrganizer[] newOrganizers) {
            int i;
            if (oldOrganizers != null) {
                i = 0;
                while (i < oldOrganizers.length) {
                    oldOrganizers[i].removePropertyChangeListener(this.fOrganizersListener);
                    ++i;
                }
            }
            if (newOrganizers != null) {
                i = 0;
                while (i < newOrganizers.length) {
                    newOrganizers[i].addPropertyChangeListener(this.fOrganizersListener);
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateContainers() {
            IBreakpoint[] breakpoints = BreakpointManagerContentProvider.this.filterBreakpoints(this.fInput, BreakpointManagerContentProvider.this.getSelectionFilter(this.fInput, this.getDebugContext()), BreakpointManagerContentProvider.this.fBpManager.getBreakpoints());
            InputData inputData = this;
            synchronized (inputData) {
                ModelDelta delta = new ModelDelta(this.fInput, 0);
                ModelDelta dummyDelta = new ModelDelta(null, 0);
                BreakpointContainer refContainer = this.createRootContainer(dummyDelta, this.fInput, this.fOrganizers, breakpoints);
                this.deleteRemovedElements(this.fContainer, refContainer, delta);
                BreakpointContainer.copyOrganizers(this.fContainer, refContainer);
                IBreakpoint newBreakpoint = this.insertAddedElements(this.fContainer, refContainer, delta);
                delta.setChildCount(this.fContainer.getChildren().length);
                if (newBreakpoint != null) {
                    BreakpointManagerContentProvider.this.appendModelDeltaToElement(delta, newBreakpoint, 0x200000);
                }
                if (DEBUG_BREAKPOINT_DELTAS) {
                    System.out.println("POST BREAKPOINT DELTA (setOrganizers)\n");
                }
                this.postModelChanged(delta, false);
            }
        }

        private synchronized IStructuredSelection getDebugContext() {
            return this.fDebugContext;
        }

        private void presentationPropertyChanged(PropertyChangeEvent event) {
            if ("PROPERTY_DISPOSED".equals(event.getProperty())) {
                BreakpointManagerContentProvider.this.contextDisposed(this.fInput.getContext());
            }
            if ("BreakpointOrganizers".equals(event.getProperty())) {
                IBreakpointOrganizer[] organizers = (IBreakpointOrganizer[])event.getNewValue();
                this.setOrganizers(organizers);
            } else if ("FilterSelection".equals(event.getProperty())) {
                IStructuredSelection selection = null;
                if (Boolean.TRUE.equals(event.getNewValue())) {
                    selection = this.getDebugContext();
                }
                this.setFilterSelection(selection);
            } else if ("TrackSelection".equals(event.getProperty())) {
                IStructuredSelection selection = null;
                if (Boolean.TRUE.equals(event.getNewValue())) {
                    selection = this.getDebugContext();
                }
                this.trackSelection(selection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void debugContextChanged(DebugContextEvent event) {
            Object newContext = event.getContext() instanceof IStructuredSelection ? (IStructuredSelection)event.getContext() : StructuredSelection.EMPTY;
            InputData inputData = this;
            synchronized (inputData) {
                this.fDebugContext = newContext;
            }
            if (Boolean.TRUE.equals(this.fInput.getContext().getProperty("FilterSelection"))) {
                this.setFilterSelection((IStructuredSelection)newContext);
            }
            if (Boolean.TRUE.equals(this.fInput.getContext().getProperty("TrackSelection"))) {
                this.trackSelection((IStructuredSelection)newContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setFilterSelection(IStructuredSelection ss) {
            ModelDelta delta = new ModelDelta(this.fInput, 0);
            boolean changed = false;
            IBreakpoint[] allBreakpoints = BreakpointManagerContentProvider.this.fBpManager.getBreakpoints();
            boolean[] supportedBreakpoints = new boolean[allBreakpoints.length];
            int i = 0;
            while (i < allBreakpoints.length) {
                supportedBreakpoints[i] = BreakpointManagerContentProvider.this.supportsBreakpoint(ss, allBreakpoints[i]);
                ++i;
            }
            InputData inputData = this;
            synchronized (inputData) {
                HashSet<IBreakpoint> existingBreakpoints = new HashSet<IBreakpoint>(Arrays.asList(this.fContainer.getBreakpoints()));
                int i2 = 0;
                while (i2 < allBreakpoints.length) {
                    if (!supportedBreakpoints[i2] && existingBreakpoints.contains(allBreakpoints[i2])) {
                        this.fContainer.removeBreakpoint(allBreakpoints[i2], delta);
                        changed = true;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < allBreakpoints.length) {
                    if (supportedBreakpoints[i2] && !existingBreakpoints.contains(allBreakpoints[i2])) {
                        this.fContainer.addBreakpoint(allBreakpoints[i2], delta);
                        changed = true;
                    }
                    ++i2;
                }
                if (changed) {
                    if (DEBUG_BREAKPOINT_DELTAS) {
                        System.out.println("POST BREAKPOINT DELTA (setFilterSelection)\n");
                    }
                    this.postModelChanged(delta, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void trackSelection(IStructuredSelection selection) {
            if (selection == null || selection.size() != 1) {
                return;
            }
            Iterator iter = selection.iterator();
            Object firstElement = iter.next();
            if (firstElement == null || iter.hasNext()) {
                return;
            }
            IThread thread = null;
            if (firstElement instanceof IStackFrame) {
                thread = ((IStackFrame)firstElement).getThread();
            } else if (firstElement instanceof IThread) {
                thread = (IThread)firstElement;
            } else {
                return;
            }
            IBreakpoint[] breakpoints = thread.getBreakpoints();
            HashSet<IBreakpoint> bpsSet = new HashSet<IBreakpoint>(breakpoints.length * 4 / 3);
            int i = 0;
            while (i < breakpoints.length) {
                bpsSet.add(breakpoints[i]);
                ++i;
            }
            ModelDelta delta = new ModelDelta(this.fInput, 0);
            InputData inputData = this;
            synchronized (inputData) {
                if (this.buildTrackSelectionDelta(delta, this.fContainer, bpsSet)) {
                    if (DEBUG_BREAKPOINT_DELTAS) {
                        System.out.println("POST BREAKPOINT DELTA (trackSelection)\n");
                    }
                    BreakpointManagerProxy[] proxies = this.getProxies();
                    int i2 = 0;
                    while (i2 < proxies.length) {
                        proxies[i2].postModelChanged(delta, true);
                        ++i2;
                    }
                }
            }
        }

        private boolean buildTrackSelectionDelta(ModelDelta delta, BreakpointContainer container, Set breakpoints) {
            Object[] children = container.getChildren();
            delta.setChildCount(children.length);
            int i = 0;
            while (i < children.length) {
                ModelDelta childDelta = delta.addNode(children[i], i, 0);
                if (children[i] instanceof BreakpointContainer) {
                    BreakpointContainer childContainer = (BreakpointContainer)children[i];
                    boolean containsBP = false;
                    IBreakpoint[] containerBPs = childContainer.getBreakpoints();
                    int j = 0;
                    while (j < containerBPs.length) {
                        if (breakpoints.contains(containerBPs[j])) {
                            containsBP = true;
                            break;
                        }
                        ++j;
                    }
                    if (containsBP && this.buildTrackSelectionDelta(childDelta, childContainer, breakpoints)) {
                        return true;
                    }
                } else if (children[i] instanceof IBreakpoint && breakpoints.contains(children[i])) {
                    childDelta.setFlags(0x300000);
                    return true;
                }
                ++i;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void breakpointsAdded(IBreakpoint[] breakpoints) {
            IBreakpoint[] filteredBreakpoints = BreakpointManagerContentProvider.this.filterBreakpoints(this.fInput, BreakpointManagerContentProvider.this.getSelectionFilter(this.fInput, this.getDebugContext()), breakpoints);
            if (filteredBreakpoints.length > 0) {
                InputData inputData = this;
                synchronized (inputData) {
                    ModelDelta delta = new ModelDelta(this.fInput, 0, 0, -1);
                    int i = 0;
                    while (i < filteredBreakpoints.length) {
                        if (DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(filteredBreakpoints[i].getMarker()) != null) {
                            this.fContainer.addBreakpoint(filteredBreakpoints[i], delta);
                        }
                        ++i;
                    }
                    delta.setChildCount(this.fContainer.getChildren().length);
                    if (filteredBreakpoints.length > 0) {
                        BreakpointManagerContentProvider.this.appendModelDeltaToElement(delta, filteredBreakpoints[0], 0x200000);
                    }
                    if (DEBUG_BREAKPOINT_DELTAS) {
                        System.out.println("POST BREAKPOINT DELTA (breakpointsAddedInput)\n");
                    }
                    this.postModelChanged(delta, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void breakpointsRemoved(IBreakpoint[] breakpoints) {
            InputData inputData = this;
            synchronized (inputData) {
                boolean removed = false;
                ModelDelta delta = new ModelDelta(this.fInput, 0);
                int i = 0;
                while (i < breakpoints.length) {
                    removed = this.fContainer.removeBreakpoint(breakpoints[i], delta) || removed;
                    ++i;
                }
                if (removed) {
                    if (DEBUG_BREAKPOINT_DELTAS) {
                        System.out.println("POST BREAKPOINT DELTA (breakpointsRemovedInput)\n");
                    }
                    this.postModelChanged(delta, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void breakpointsChanged(IBreakpoint[] breakpoints) {
            IBreakpoint[] filteredBreakpoints = BreakpointManagerContentProvider.this.filterBreakpoints(this.fInput, BreakpointManagerContentProvider.this.getSelectionFilter(this.fInput, this.getDebugContext()), breakpoints);
            InputData inputData = this;
            synchronized (inputData) {
                ModelDelta delta = new ModelDelta(this.fInput, 0);
                ArrayList<IBreakpoint> removed = new ArrayList<IBreakpoint>();
                ArrayList<IBreakpoint> added = new ArrayList<IBreakpoint>();
                List<IBreakpoint> filteredAsList = Arrays.asList(filteredBreakpoints);
                int i = 0;
                while (i < breakpoints.length) {
                    IBreakpoint bp = breakpoints[i];
                    boolean oldContainedBp = this.fContainer.contains(bp);
                    boolean newContained = filteredAsList.contains(bp);
                    if (oldContainedBp && !newContained) {
                        removed.add(bp);
                    } else if (!oldContainedBp && newContained) {
                        added.add(bp);
                    }
                    ++i;
                }
                if (!added.isEmpty()) {
                    this.breakpointsAdded(added.toArray(new IBreakpoint[added.size()]));
                }
                if (!removed.isEmpty()) {
                    this.breakpointsRemoved(removed.toArray(new IBreakpoint[removed.size()]));
                }
                i = 0;
                while (i < filteredBreakpoints.length) {
                    BreakpointManagerContentProvider.this.appendModelDelta(this.fContainer, delta, 3072, filteredBreakpoints[i]);
                    ++i;
                }
                if (DEBUG_BREAKPOINT_DELTAS) {
                    System.out.println("POST BREAKPOINT DELTA (breakpointsChanged)\n");
                }
                this.postModelChanged(delta, false);
            }
        }

        private void buildInstallDelta(ModelDelta delta, BreakpointContainer container) {
            Object[] children = container.getChildren();
            delta.setChildCount(children.length);
            int i = 0;
            while (i < children.length) {
                ModelDelta childDelta = delta.addNode(children[i], i, 0);
                if (children[i] instanceof BreakpointContainer) {
                    childDelta.setFlags(0x400000);
                    this.buildInstallDelta(childDelta, (BreakpointContainer)children[i]);
                } else if (children[i] instanceof IBreakpoint) {
                    childDelta.setFlags(0x400000);
                }
                ++i;
            }
        }

        private IBreakpoint insertAddedElements(BreakpointContainer container, BreakpointContainer refContainer, ModelDelta containerDelta) {
            IBreakpoint newBreakpoint = null;
            Object[] children = container.getChildren();
            Object[] refChildren = refContainer.getChildren();
            int i = 0;
            while (i < refChildren.length) {
                Object element = this.getElement(children, refChildren[i]);
                if (element == null) {
                    if (refChildren[i] instanceof BreakpointContainer) {
                        BreakpointContainer.addChildContainer(container, (BreakpointContainer)refChildren[i], containerDelta);
                    } else {
                        BreakpointContainer.addBreakpoint(container, (IBreakpoint)refChildren[i], containerDelta);
                        if (newBreakpoint == null) {
                            newBreakpoint = (IBreakpoint)refChildren[i];
                        }
                    }
                } else if (element instanceof BreakpointContainer) {
                    ModelDelta childDelta = containerDelta.addNode(element, container.getChildIndex(element), 2048, -1);
                    BreakpointContainer.copyOrganizers((BreakpointContainer)element, (BreakpointContainer)refChildren[i]);
                    newBreakpoint = this.insertAddedElements((BreakpointContainer)element, (BreakpointContainer)refChildren[i], childDelta);
                    childDelta.setChildCount(((BreakpointContainer)element).getChildren().length);
                }
                ++i;
            }
            return newBreakpoint;
        }

        private void deleteRemovedElements(BreakpointContainer container, BreakpointContainer refContainer, ModelDelta containerDelta) {
            Object[] children = container.getChildren();
            Object[] refChildren = refContainer.getChildren();
            int i = 0;
            while (i < children.length) {
                Object element = this.getElement(refChildren, children[i]);
                if (element == null) {
                    if (children[i] instanceof BreakpointContainer) {
                        BreakpointContainer.removeAll((BreakpointContainer)children[i], containerDelta);
                    } else {
                        BreakpointContainer.removeBreakpoint(container, (IBreakpoint)children[i], containerDelta);
                    }
                } else if (element instanceof BreakpointContainer) {
                    ModelDelta childDelta = containerDelta.addNode(children[i], 2048);
                    this.deleteRemovedElements((BreakpointContainer)children[i], (BreakpointContainer)element, childDelta);
                }
                ++i;
            }
        }

        private Object getElement(Object[] collection, Object element) {
            int i = 0;
            while (i < collection.length) {
                if (collection[i] instanceof BreakpointContainer && element instanceof BreakpointContainer ? collection[i].equals(element) : collection[i].equals(element)) {
                    return collection[i];
                }
                ++i;
            }
            return null;
        }

        private BreakpointContainer createRootContainer(ModelDelta rootDelta, DefaultBreakpointsViewInput input, IBreakpointOrganizer[] organizers, IBreakpoint[] breakpoints) {
            BreakpointContainer container = new BreakpointContainer(organizers, this.fComparator);
            container.initDefaultContainers(rootDelta);
            int i = 0;
            while (i < breakpoints.length) {
                container.addBreakpoint(breakpoints[i], rootDelta);
                ++i;
            }
            return container;
        }

        private synchronized void postModelChanged(IModelDelta delta, boolean select) {
            int i = 0;
            while (this.fProxies != null && i < this.fProxies.size()) {
                ((BreakpointManagerProxy)this.fProxies.get(i)).postModelChanged(delta, select);
                ++i;
            }
        }

        static /* synthetic */ void access$0(InputData inputData, PropertyChangeEvent propertyChangeEvent) {
            inputData.presentationPropertyChanged(propertyChangeEvent);
        }

        static /* synthetic */ void access$1(InputData inputData, DebugContextEvent debugContextEvent) {
            inputData.debugContextChanged(debugContextEvent);
        }
    }

    private class InputDataMap
    extends LinkedHashMap {
        private static final long serialVersionUID = 1L;

        public InputDataMap() {
            super(1, 0.75f, true);
        }

        protected boolean removeEldestEntry(Map.Entry arg0) {
            InputData data = (InputData)arg0.getValue();
            if (this.size() > BreakpointManagerContentProvider.this.getMaxInputsCache() && data.fProxies.isEmpty()) {
                data.dispose();
                return true;
            }
            return false;
        }
    }
}

