/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.compound.AllocEntry;
import org.eclipse.birt.core.archive.compound.ArchiveConstants;
import org.eclipse.birt.core.archive.compound.ArchiveFileV2;

class AllocTableLoader
implements ArchiveConstants {
    protected Node nodes = new Node();
    protected AllocEntry fatEntry = new AllocEntry(1);

    AllocTableLoader() {
        Node fatNode = new Node();
        fatNode.entry = this.fatEntry;
        this.nodes.next = fatNode;
    }

    ArrayList getEntryies() {
        ArrayList<AllocEntry> entries = new ArrayList<AllocEntry>();
        Node entryNode = this.nodes.next;
        while (entryNode != null) {
            entries.add(entryNode.entry);
            entryNode = entryNode.next;
        }
        return entries;
    }

    private void appendBlock(int blockIndex, int blockId) {
        Node prevNode = null;
        Node entryNode = this.nodes.next;
        do {
            if (entryNode.entry.getLastBlock() == blockIndex) {
                entryNode.entry.appendBlock(blockId);
                if (entryNode != this.nodes.next) {
                    prevNode.next = entryNode.next;
                    entryNode.next = this.nodes.next;
                    this.nodes.next = entryNode;
                }
                return;
            }
            prevNode = entryNode;
        } while ((entryNode = entryNode.next) != null);
        entryNode = new Node();
        entryNode.entry = new AllocEntry(blockIndex);
        entryNode.entry.appendBlock(blockId);
        entryNode.next = this.nodes.next;
        this.nodes.next = entryNode;
    }

    void load(ArchiveFileV2 af) throws IOException {
        int BLOCK_SIZE = af.BLOCK_SIZE;
        int INDEX_PER_BLOCK = BLOCK_SIZE / 4;
        byte[] buffer = new byte[BLOCK_SIZE];
        int readBlocks = 0;
        int blockIndex = 0;
        while (readBlocks < this.fatEntry.getTotalBlocks()) {
            int fatBlockId = this.fatEntry.getBlock(readBlocks);
            af.read(fatBlockId, 0, buffer, 0, BLOCK_SIZE);
            int i = 0;
            while (i < INDEX_PER_BLOCK) {
                int blockId = ArchiveUtil.bytesToInteger(buffer, i * 4);
                if (blockId > 0) {
                    this.appendBlock(blockIndex, blockId);
                }
                ++blockIndex;
                ++i;
            }
            ++readBlocks;
        }
        this.merge(this.nodes);
    }

    void merge(Node nodes) {
        Node entryNode = nodes.next;
        Node prevNode = nodes;
        while (entryNode != null) {
            boolean hasMerged = false;
            Node compareNode = nodes.next;
            int blockIndex = entryNode.entry.getFirstBlock();
            while (compareNode != null) {
                if (compareNode == entryNode) {
                    compareNode = compareNode.next;
                    continue;
                }
                if (compareNode.entry.getLastBlock() == blockIndex) {
                    int i = 1;
                    while (i < entryNode.entry.getTotalBlocks()) {
                        int blockId = entryNode.entry.getBlock(i);
                        compareNode.entry.appendBlock(blockId);
                        ++i;
                    }
                    prevNode.next = entryNode.next;
                    hasMerged = true;
                    break;
                }
                compareNode = compareNode.next;
            }
            if (!hasMerged) {
                prevNode = entryNode;
            }
            entryNode = entryNode.next;
        }
    }

    static class Node {
        AllocEntry entry;
        Node next;

        Node() {
        }
    }
}

