/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SortOption implements Enumerator
{
    ASCENDING_LITERAL(0, "Ascending", "Ascending"),
    DESCENDING_LITERAL(1, "Descending", "Descending");

    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    private static final SortOption[] VALUES_ARRAY;
    public static final List<SortOption> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SortOption[]{ASCENDING_LITERAL, DESCENDING_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SortOption get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SortOption result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SortOption getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SortOption result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SortOption get(int value) {
        switch (value) {
            case 0: {
                return ASCENDING_LITERAL;
            }
            case 1: {
                return DESCENDING_LITERAL;
            }
        }
        return null;
    }

    private SortOption(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

